/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.xdr.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.XdrDataType;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.type.XdrSimple;

public class XdrLong
extends XdrSimple<Long> {
    public XdrLong() {
        this((Long)null);
    }

    public XdrLong(Long value) {
        super(XdrDataType.LONG, value);
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        return 8;
    }

    @Override
    protected void toBytes() throws IOException {
        long value = (Long)this.getValue();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        buffer.flip();
        this.setBytes(buffer.array());
    }

    @Override
    protected void toValue() {
        if (this.getBytes().length != 8) {
            byte[] longBytes = ByteBuffer.allocate(8).put(this.getBytes(), 0, 8).array();
            this.setBytes(longBytes);
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.getBytes());
        this.setValue(buffer.getLong());
    }
}

