/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminContext;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.AdminRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.AdminMessageCode;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.AdminMessageType;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.AdminReq;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.IdentityInfoCode;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.KadminCode;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.message.KeytabMessageCode;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.XdrFieldInfo;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.type.XdrStructType;
import org.apache.hadoop.shaded.org.xnio.sasl.SaslWrapper;

public abstract class AdminHandler {
    public void init(AdminContext context) {
    }

    public void handleRequest(AdminRequest adminRequest, SaslWrapper sasl) throws KrbException {
        adminRequest.process();
        AdminReq adminReq = adminRequest.getAdminReq();
        try {
            ByteBuffer requestMessage = KadminCode.encodeWrapMessage(adminReq, sasl);
            requestMessage.flip();
            this.sendMessage(adminRequest, requestMessage);
        }
        catch (IOException e) {
            throw new KrbException("Admin sends request message failed", (Throwable)e);
        }
    }

    public void onResponseMessage(AdminRequest adminRequest, ByteBuffer responseMessage) throws KrbException {
        AdminMessageCode decoded = new AdminMessageCode();
        try {
            decoded.decode(responseMessage);
        }
        catch (IOException e) {
            throw new KrbException("On response message failed.", (Throwable)e);
        }
        XdrFieldInfo[] fieldInfos = ((XdrStructType)decoded.getValue()).getXdrFieldInfos();
        AdminMessageType type = (AdminMessageType)fieldInfos[0].getValue();
        switch (type) {
            case ADD_PRINCIPAL_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.ADD_PRINCIPAL_REQ) {
                    System.out.println((String)fieldInfos[2].getValue());
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.ADD_PRINCIPAL_REP);
            }
            case DELETE_PRINCIPAL_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.DELETE_PRINCIPAL_REQ) {
                    System.out.println((String)fieldInfos[2].getValue());
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.DELETE_PRINCIPAL_REP);
            }
            case RENAME_PRINCIPAL_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.RENAME_PRINCIPAL_REQ) {
                    System.out.println((String)fieldInfos[2].getValue());
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.RENAME_PRINCIPAL_REP);
            }
            case CHANGE_PWD_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.CHANGE_PWD_REQ) {
                    System.out.println((String)fieldInfos[2].getValue());
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.CHANGE_PWD_REP);
            }
            default: {
                throw new KrbException("Response message type error: " + type);
            }
        }
    }

    public List<String> onResponseMessageForList(AdminRequest adminRequest, ByteBuffer responseMessage) throws KrbException {
        List<String> princalsList = null;
        AdminMessageCode decoded = new AdminMessageCode();
        try {
            decoded.decode(responseMessage);
        }
        catch (IOException e) {
            throw new KrbException("On response message failed.", (Throwable)e);
        }
        XdrFieldInfo[] fieldInfos = ((XdrStructType)decoded.getValue()).getXdrFieldInfos();
        AdminMessageType type = (AdminMessageType)fieldInfos[0].getValue();
        switch (type) {
            case GET_PRINCS_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.GET_PRINCS_REQ) {
                    String[] temp = ((String)fieldInfos[2].getValue()).trim().split(" ");
                    princalsList = Arrays.asList(temp);
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.GET_PRINCS_REP);
            }
            default: {
                throw new KrbException("Response message type error: " + type);
            }
        }
        return princalsList;
    }

    public byte[] onResponseMessageForBytesArray(AdminRequest adminRequest, ByteBuffer responseMessage) throws KrbException {
        byte[] keytabFileBytes = null;
        KeytabMessageCode decoded = new KeytabMessageCode();
        try {
            decoded.decode(responseMessage);
        }
        catch (IOException e) {
            throw new KrbException("On response message failed.", (Throwable)e);
        }
        XdrFieldInfo[] fieldInfos = ((XdrStructType)decoded.getValue()).getXdrFieldInfos();
        AdminMessageType type = (AdminMessageType)fieldInfos[0].getValue();
        switch (type) {
            case EXPORT_KEYTAB_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() == AdminMessageType.EXPORT_KEYTAB_REQ) {
                    keytabFileBytes = (byte[])fieldInfos[2].getValue();
                    break;
                }
                throw new KrbException("Response message type error: need " + AdminMessageType.EXPORT_KEYTAB_REP);
            }
            default: {
                throw new KrbException("Response message type error: " + type);
            }
        }
        return keytabFileBytes;
    }

    public KrbIdentity onResponseMessageForIdentity(AdminRequest adminRequest, ByteBuffer responseMessage) throws KrbException {
        KrbIdentity identity = null;
        IdentityInfoCode decoded = new IdentityInfoCode();
        try {
            decoded.decode(responseMessage);
        }
        catch (IOException e) {
            throw new KrbException("On response message failed.", (Throwable)e);
        }
        XdrFieldInfo[] fieldInfos = ((XdrStructType)decoded.getValue()).getXdrFieldInfos();
        AdminMessageType type = (AdminMessageType)fieldInfos[0].getValue();
        switch (type) {
            case GET_PRINCIPAL_REP: {
                if (adminRequest.getAdminReq().getAdminMessageType() != AdminMessageType.GET_PRINCIPAL_REQ) break;
                identity = new KrbIdentity((String)fieldInfos[2].getValue());
                identity.setExpireTime(new KerberosTime((Long)fieldInfos[3].getValue()));
                identity.setCreatedTime(new KerberosTime((Long)fieldInfos[4].getValue()));
                identity.setKdcFlags((Integer)fieldInfos[5].getValue());
                identity.setKeyVersion((Integer)fieldInfos[6].getValue());
                int keySize = (Integer)fieldInfos[7].getValue();
                String[] keySet = ((String)fieldInfos[8].getValue()).split(",");
                for (int i = 0; i < keySize; ++i) {
                    EncryptionKey key = new EncryptionKey();
                    key.setKeyType(EncryptionType.fromName(keySet[i]));
                    identity.addKey(key);
                }
                break;
            }
            default: {
                throw new KrbException("Response message type error: " + type);
            }
        }
        return identity;
    }

    protected abstract void sendMessage(AdminRequest var1, ByteBuffer var2) throws IOException;

    protected abstract List<String> handleRequestForList(AdminRequest var1, SaslWrapper var2) throws KrbException;

    protected abstract byte[] handleRequestForBytes(AdminRequest var1, SaslWrapper var2) throws KrbException;

    protected abstract KrbIdentity handleRequestForIdentity(AdminRequest var1, SaslWrapper var2) throws KrbException;
}

