/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.common.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerReplicaStates
implements ReflectMapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final char SEPARATOR = ':';
    public static final int MAX_RETRIES = 5;
    @JsonProperty
    public final String path;
    @JsonProperty
    public final int cversion;
    @JsonProperty
    public final Map<String, State> states;
    private volatile Boolean allActive;

    public PerReplicaStates(String path, int cversion, List<String> states) {
        this.path = path;
        this.cversion = cversion;
        LinkedHashMap<String, State> tmp = new LinkedHashMap<String, State>();
        for (String state : states) {
            State rs = State.parse(state);
            if (rs == null) continue;
            State existing = (State)tmp.get(rs.replica);
            if (existing == null) {
                tmp.put(rs.replica, rs);
                continue;
            }
            tmp.put(rs.replica, rs.insert(existing));
        }
        this.states = tmp;
    }

    public static PerReplicaStates empty(String collectionName) {
        return new PerReplicaStates(DocCollection.getCollectionPath(collectionName), 0, List.of());
    }

    public boolean allActive() {
        if (this.allActive != null) {
            return this.allActive;
        }
        this.allActive = this.states.values().stream().allMatch(s -> s.state == Replica.State.ACTIVE);
        return this.allActive;
    }

    public static Set<String> findModifiedReplicas(PerReplicaStates old, PerReplicaStates fresh) {
        HashSet<String> result = new HashSet<String>();
        if (fresh == null) {
            result.addAll(old.states.keySet());
            return result;
        }
        old.states.forEach((s, state) -> {
            if (!Objects.equals(fresh.get((String)s), state)) {
                result.add((String)s);
            }
        });
        fresh.states.forEach((s, state) -> {
            if (old.get((String)s) == null) {
                result.add((String)s);
            }
        });
        return result;
    }

    public static String getReplicaName(String s) {
        int idx = s.indexOf(58);
        if (idx > 0) {
            return s.substring(0, idx);
        }
        return null;
    }

    public State get(String replica) {
        return this.states.get(replica);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{").append(this.path).append("/[").append(this.cversion).append("]: [");
        this.appendStates(sb);
        return sb.append("]}").toString();
    }

    private StringBuilder appendStates(final StringBuilder sb) {
        this.states.forEach(new BiConsumer<String, State>(){
            int count = 0;

            @Override
            public void accept(String s, State state) {
                if (this.count++ > 0) {
                    sb.append(", ");
                }
                sb.append(state.asString);
                for (State d : state.getDuplicates()) {
                    sb.append(d.asString);
                }
            }
        });
        return sb;
    }

    @Override
    public void writeMap(final MapWriter.EntryWriter ew) throws IOException {
        ReflectMapWriter.super.writeMap(new MapWriter.EntryWriter(){

            @Override
            public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
                if ("states".equals(k.toString())) {
                    ew.put((CharSequence)"states", iw -> PerReplicaStates.this.states.forEach((s, state) -> iw.addNoEx(state.toString())));
                } else {
                    ew.put(k, v);
                }
                return this;
            }
        });
    }

    public static class State
    implements MapWriter {
        public final String replica;
        public final Replica.State state;
        public final Boolean isLeader;
        public final int version;
        public final String asString;
        final State duplicate;

        private State(String serialized, List<String> pieces) {
            this.asString = serialized;
            this.replica = pieces.get(0);
            this.version = Integer.parseInt(pieces.get(1));
            String encodedStatus = pieces.get(2);
            this.state = Replica.getState(encodedStatus);
            this.isLeader = pieces.size() > 3 && "L".equals(pieces.get(3));
            this.duplicate = null;
        }

        public static State parse(String serialized) {
            List<String> pieces = StrUtils.splitSmart(serialized, ':');
            if (pieces.size() < 3) {
                return null;
            }
            return new State(serialized, pieces);
        }

        public State(String replica, Replica.State state, Boolean isLeader, int version) {
            this(replica, state, isLeader, version, null);
        }

        public State(String replica, Replica.State state, Boolean isLeader, int version, State duplicate) {
            this.replica = replica;
            this.state = state == null ? Replica.State.ACTIVE : state;
            this.isLeader = isLeader == null ? Boolean.FALSE : isLeader;
            this.version = version;
            this.asString = this.serialize();
            this.duplicate = duplicate;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"name", this.replica);
            ew.put((CharSequence)"version", this.version);
            ew.put((CharSequence)"state", this.state.toString());
            if (this.isLeader.booleanValue()) {
                ew.put((CharSequence)"leader", this.isLeader);
            }
            ew.putIfNotNull((CharSequence)"duplicate", this.duplicate);
        }

        private State insert(State duplicate) {
            assert (this.replica.equals(duplicate.replica));
            if (this.version >= duplicate.version) {
                if (this.duplicate != null) {
                    duplicate = new State(duplicate.replica, duplicate.state, duplicate.isLeader, duplicate.version, this.duplicate);
                }
                return new State(this.replica, this.state, this.isLeader, this.version, duplicate);
            }
            return duplicate.insert(this);
        }

        List<State> getDuplicates() {
            if (this.duplicate == null) {
                return Collections.emptyList();
            }
            ArrayList<State> result = new ArrayList<State>();
            State current = this.duplicate;
            while (current != null) {
                result.add(current);
                current = current.duplicate;
            }
            return result;
        }

        private String serialize() {
            StringBuilder sb = new StringBuilder(this.replica).append(":").append(this.version).append(":").append(this.state.shortName);
            if (this.isLeader.booleanValue()) {
                sb.append(":").append("L");
            }
            return sb.toString();
        }

        public String toString() {
            return this.asString;
        }

        public boolean equals(Object o) {
            if (o instanceof State) {
                State that = (State)o;
                return Objects.equals(this.asString, that.asString);
            }
            return false;
        }

        public int hashCode() {
            return this.asString.hashCode();
        }

        public State getDuplicate() {
            return this.duplicate;
        }
    }

    public static class Operation {
        public final Type typ;
        public final State state;

        public Operation(Type typ, State replicaState) {
            this.typ = typ;
            this.state = replicaState;
        }

        public String toString() {
            return this.typ.toString() + " : " + this.state;
        }

        public static enum Type {
            ADD,
            DELETE;

        }
    }
}

