/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import java.io.IOException;
import org.apache.solr.metrics.SolrMetricsContext;

public interface SolrMetricProducer
extends AutoCloseable {
    public static String getUniqueMetricTag(Object o, String parentName) {
        String name = o.getClass().getSimpleName() + "@" + Integer.toHexString(o.hashCode());
        if (parentName != null && parentName.contains(name)) {
            throw new RuntimeException("Parent already includes this component! parent=" + parentName + ", this=" + name);
        }
        return parentName == null ? name : parentName + ":" + name;
    }

    public void initializeMetrics(SolrMetricsContext var1, String var2);

    public SolrMetricsContext getSolrMetricsContext();

    @Override
    default public void close() throws IOException {
        SolrMetricsContext context = this.getSolrMetricsContext();
        if (context == null) {
            return;
        }
        context.unregister();
    }
}

