"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _constants = require("./constants");
var _connector_service = require("../services/connector_service");
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const connectorRouter = router => {
  router.get({
    path: _constants.CONNECTOR_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, res) => {
    try {
      const payload = await _connector_service.ConnectorService.search({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId: request.query.data_source_id,
          context
        }),
        from: 0,
        size: 10000
      });
      return res.ok({
        body: payload
      });
    } catch (err) {
      return res.badRequest({
        body: err.message
      });
    }
  });
  router.get({
    path: _constants.INTERNAL_CONNECTOR_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, res) => {
    try {
      const data = await _connector_service.ConnectorService.getUniqueInternalConnectorNames({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId: request.query.data_source_id,
          context
        }),
        size: 10000
      });
      return res.ok({
        body: {
          data
        }
      });
    } catch (err) {
      return res.badRequest({
        body: err.message
      });
    }
  });
};
exports.connectorRouter = connectorRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9jb25zdGFudHMiLCJfY29ubmVjdG9yX3NlcnZpY2UiLCJfdXRpbHMiLCJjb25uZWN0b3JSb3V0ZXIiLCJyb3V0ZXIiLCJnZXQiLCJwYXRoIiwiQ09OTkVDVE9SX0FQSV9FTkRQT0lOVCIsInZhbGlkYXRlIiwicXVlcnkiLCJzY2hlbWEiLCJvYmplY3QiLCJkYXRhX3NvdXJjZV9pZCIsIm1heWJlIiwic3RyaW5nIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXMiLCJwYXlsb2FkIiwiQ29ubmVjdG9yU2VydmljZSIsInNlYXJjaCIsInRyYW5zcG9ydCIsImdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQiLCJkYXRhU291cmNlSWQiLCJmcm9tIiwic2l6ZSIsIm9rIiwiYm9keSIsImVyciIsImJhZFJlcXVlc3QiLCJtZXNzYWdlIiwiSU5URVJOQUxfQ09OTkVDVE9SX0FQSV9FTkRQT0lOVCIsImRhdGEiLCJnZXRVbmlxdWVJbnRlcm5hbENvbm5lY3Rvck5hbWVzIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbImNvbm5lY3Rvcl9yb3V0ZXIudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xuaW1wb3J0IHsgSVJvdXRlciB9IGZyb20gJy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5pbXBvcnQgeyBDT05ORUNUT1JfQVBJX0VORFBPSU5ULCBJTlRFUk5BTF9DT05ORUNUT1JfQVBJX0VORFBPSU5UIH0gZnJvbSAnLi9jb25zdGFudHMnO1xuaW1wb3J0IHsgQ29ubmVjdG9yU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2Nvbm5lY3Rvcl9zZXJ2aWNlJztcbmltcG9ydCB7IGdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQgfSBmcm9tICcuL3V0aWxzJztcblxuZXhwb3J0IGNvbnN0IGNvbm5lY3RvclJvdXRlciA9IChyb3V0ZXI6IElSb3V0ZXIpID0+IHtcbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiBDT05ORUNUT1JfQVBJX0VORFBPSU5ULFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGRhdGFfc291cmNlX2lkOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH0sXG4gICAgYXN5bmMgKGNvbnRleHQsIHJlcXVlc3QsIHJlcykgPT4ge1xuICAgICAgdHJ5IHtcbiAgICAgICAgY29uc3QgcGF5bG9hZCA9IGF3YWl0IENvbm5lY3RvclNlcnZpY2Uuc2VhcmNoKHtcbiAgICAgICAgICB0cmFuc3BvcnQ6IGF3YWl0IGdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQoe1xuICAgICAgICAgICAgZGF0YVNvdXJjZUlkOiByZXF1ZXN0LnF1ZXJ5LmRhdGFfc291cmNlX2lkLFxuICAgICAgICAgICAgY29udGV4dCxcbiAgICAgICAgICB9KSxcbiAgICAgICAgICBmcm9tOiAwLFxuICAgICAgICAgIHNpemU6IDEwMDAwLFxuICAgICAgICB9KTtcbiAgICAgICAgcmV0dXJuIHJlcy5vayh7IGJvZHk6IHBheWxvYWQgfSk7XG4gICAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgcmV0dXJuIHJlcy5iYWRSZXF1ZXN0KHsgYm9keTogZXJyLm1lc3NhZ2UgfSk7XG4gICAgICB9XG4gICAgfVxuICApO1xuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6IElOVEVSTkFMX0NPTk5FQ1RPUl9BUElfRU5EUE9JTlQsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgZGF0YV9zb3VyY2VfaWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoY29udGV4dCwgcmVxdWVzdCwgcmVzKSA9PiB7XG4gICAgICB0cnkge1xuICAgICAgICBjb25zdCBkYXRhID0gYXdhaXQgQ29ubmVjdG9yU2VydmljZS5nZXRVbmlxdWVJbnRlcm5hbENvbm5lY3Rvck5hbWVzKHtcbiAgICAgICAgICB0cmFuc3BvcnQ6IGF3YWl0IGdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQoe1xuICAgICAgICAgICAgZGF0YVNvdXJjZUlkOiByZXF1ZXN0LnF1ZXJ5LmRhdGFfc291cmNlX2lkLFxuICAgICAgICAgICAgY29udGV4dCxcbiAgICAgICAgICB9KSxcbiAgICAgICAgICBzaXplOiAxMDAwMCxcbiAgICAgICAgfSk7XG4gICAgICAgIHJldHVybiByZXMub2soeyBib2R5OiB7IGRhdGEgfSB9KTtcbiAgICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgICByZXR1cm4gcmVzLmJhZFJlcXVlc3QoeyBib2R5OiBlcnIubWVzc2FnZSB9KTtcbiAgICAgIH1cbiAgICB9XG4gICk7XG59O1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFFQSxJQUFBQyxVQUFBLEdBQUFELE9BQUE7QUFDQSxJQUFBRSxrQkFBQSxHQUFBRixPQUFBO0FBQ0EsSUFBQUcsTUFBQSxHQUFBSCxPQUFBO0FBVEE7QUFDQTtBQUNBO0FBQ0E7O0FBUU8sTUFBTUksZUFBZSxHQUFJQyxNQUFlLElBQUs7RUFDbERBLE1BQU0sQ0FBQ0MsR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRUMsaUNBQXNCO0lBQzVCQyxRQUFRLEVBQUU7TUFDUkMsS0FBSyxFQUFFQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbkJDLGNBQWMsRUFBRUYsb0JBQU0sQ0FBQ0csS0FBSyxDQUFDSCxvQkFBTSxDQUFDSSxNQUFNLENBQUMsQ0FBQztNQUM5QyxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FBT0MsT0FBTyxFQUFFQyxPQUFPLEVBQUVDLEdBQUcsS0FBSztJQUMvQixJQUFJO01BQ0YsTUFBTUMsT0FBTyxHQUFHLE1BQU1DLG1DQUFnQixDQUFDQyxNQUFNLENBQUM7UUFDNUNDLFNBQVMsRUFBRSxNQUFNLElBQUFDLG1DQUE0QixFQUFDO1VBQzVDQyxZQUFZLEVBQUVQLE9BQU8sQ0FBQ1AsS0FBSyxDQUFDRyxjQUFjO1VBQzFDRztRQUNGLENBQUMsQ0FBQztRQUNGUyxJQUFJLEVBQUUsQ0FBQztRQUNQQyxJQUFJLEVBQUU7TUFDUixDQUFDLENBQUM7TUFDRixPQUFPUixHQUFHLENBQUNTLEVBQUUsQ0FBQztRQUFFQyxJQUFJLEVBQUVUO01BQVEsQ0FBQyxDQUFDO0lBQ2xDLENBQUMsQ0FBQyxPQUFPVSxHQUFHLEVBQUU7TUFDWixPQUFPWCxHQUFHLENBQUNZLFVBQVUsQ0FBQztRQUFFRixJQUFJLEVBQUVDLEdBQUcsQ0FBQ0U7TUFBUSxDQUFDLENBQUM7SUFDOUM7RUFDRixDQUNGLENBQUM7RUFDRDFCLE1BQU0sQ0FBQ0MsR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRXlCLDBDQUErQjtJQUNyQ3ZCLFFBQVEsRUFBRTtNQUNSQyxLQUFLLEVBQUVDLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztRQUNuQkMsY0FBYyxFQUFFRixvQkFBTSxDQUFDRyxLQUFLLENBQUNILG9CQUFNLENBQUNJLE1BQU0sQ0FBQyxDQUFDO01BQzlDLENBQUM7SUFDSDtFQUNGLENBQUMsRUFDRCxPQUFPQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsR0FBRyxLQUFLO0lBQy9CLElBQUk7TUFDRixNQUFNZSxJQUFJLEdBQUcsTUFBTWIsbUNBQWdCLENBQUNjLCtCQUErQixDQUFDO1FBQ2xFWixTQUFTLEVBQUUsTUFBTSxJQUFBQyxtQ0FBNEIsRUFBQztVQUM1Q0MsWUFBWSxFQUFFUCxPQUFPLENBQUNQLEtBQUssQ0FBQ0csY0FBYztVQUMxQ0c7UUFDRixDQUFDLENBQUM7UUFDRlUsSUFBSSxFQUFFO01BQ1IsQ0FBQyxDQUFDO01BQ0YsT0FBT1IsR0FBRyxDQUFDUyxFQUFFLENBQUM7UUFBRUMsSUFBSSxFQUFFO1VBQUVLO1FBQUs7TUFBRSxDQUFDLENBQUM7SUFDbkMsQ0FBQyxDQUFDLE9BQU9KLEdBQUcsRUFBRTtNQUNaLE9BQU9YLEdBQUcsQ0FBQ1ksVUFBVSxDQUFDO1FBQUVGLElBQUksRUFBRUMsR0FBRyxDQUFDRTtNQUFRLENBQUMsQ0FBQztJQUM5QztFQUNGLENBQ0YsQ0FBQztBQUNILENBQUM7QUFBQ0ksT0FBQSxDQUFBL0IsZUFBQSxHQUFBQSxlQUFBIn0=