/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.function.Supplier;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.osgi.framework.BundleContext;

public class JustOSGiImpl<T>
extends OSGiImpl<T> {
    public JustOSGiImpl(Collection<T> t) {
        this(() -> t);
    }

    public JustOSGiImpl(Supplier<Collection<T>> supplier) {
        super((BundleContext bundleContext, Publisher<T> op) -> {
            Collection collection = (Collection)supplier.get();
            ArrayList<Runnable> references = new ArrayList<Runnable>(collection.size());
            try {
                for (Object t : collection) {
                    references.add(op.publish(t));
                }
            }
            catch (Exception e) {
                JustOSGiImpl.cleanUp(references);
                throw e;
            }
            return new OSGiResultImpl(() -> JustOSGiImpl.cleanUp(references));
        });
    }

    private static void cleanUp(ArrayList<Runnable> references) {
        ListIterator<Runnable> iterator = references.listIterator(references.size());
        while (iterator.hasPrevious()) {
            try {
                iterator.previous().run();
            }
            catch (Exception exception) {}
        }
    }

    public JustOSGiImpl(T t) {
        this(() -> Collections.singletonList(t));
    }
}

