/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.events.TopicGlobEventFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GenericEventTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber,
EventFilter {
    public static final String MODULE_TYPE_ID = "core.GenericEventTrigger";
    public static final String CFG_TOPIC = "topic";
    public static final String CFG_SOURCE = "source";
    public static final String CFG_TYPES = "types";
    public static final String CFG_PAYLOAD = "payload";
    private final Logger logger = LoggerFactory.getLogger(GenericEventTriggerHandler.class);
    private final String source;
    private final @Nullable TopicGlobEventFilter topicFilter;
    private final Set<String> types;
    private final @Nullable Pattern payloadPattern;
    private @Nullable ServiceRegistration<?> eventSubscriberRegistration;

    public GenericEventTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.source = (String)module.getConfiguration().get(CFG_SOURCE);
        String topic = (String)module.getConfiguration().get(CFG_TOPIC);
        this.topicFilter = !topic.isBlank() ? new TopicGlobEventFilter(topic) : null;
        this.types = module.getConfiguration().get(CFG_TYPES) != null ? Set.of(((String)module.getConfiguration().get(CFG_TYPES)).split(",")) : Set.of();
        String payload = (String)module.getConfiguration().get(CFG_PAYLOAD);
        this.payloadPattern = !payload.isBlank() ? Pattern.compile(payload) : null;
        this.eventSubscriberRegistration = bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        this.logger.trace("Registered EventSubscriber: Topic: {} Type: {} Source: {} Payload: {}", new Object[]{topic, this.types, this.source, payload});
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public @Nullable EventFilter getEventFilter() {
        return this;
    }

    public void receive(Event event) {
        ModuleHandlerCallback callback = this.callback;
        if (callback != null) {
            this.logger.trace("Received Event: Topic: {} Type: {} Source: {} Payload: {}", new Object[]{event.getTopic(), event.getType(), event.getSource(), event.getPayload()});
            HashMap<String, Event> values = new HashMap<String, Event>();
            values.put("event", event);
            ((TriggerHandlerCallback)callback).triggered((Trigger)this.module, values);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.eventSubscriberRegistration != null) {
            this.eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }

    public boolean apply(Event event) {
        this.logger.trace("->FILTER: {}: {}", (Object)event.getTopic(), (Object)this.source);
        TopicGlobEventFilter localTopicFilter = this.topicFilter;
        if (localTopicFilter != null && !this.topicFilter.apply(event)) {
            return false;
        }
        if (!this.source.isEmpty() && !this.source.equals(event.getSource())) {
            return false;
        }
        Pattern localPayloadPattern = this.payloadPattern;
        return localPayloadPattern == null || localPayloadPattern.matcher(event.getPayload()).find();
    }
}

