/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.openide.util.Parameters;

public final class GraphNode<I extends GraphNodeImplementation> {
    public static final int UNMANAGED = 0;
    public static final int MANAGED = 1;
    public static final int OVERRIDES_MANAGED = 2;
    private I impl;
    private I parentAfterFix;
    private final Set<I> duplicates;
    private int level;
    private int managedState = 0;

    public GraphNode(@NonNull I impl) {
        Parameters.notNull((CharSequence)"impl", impl);
        this.impl = impl;
        this.duplicates = new HashSet<I>();
    }

    public String getName() {
        return this.impl.getName();
    }

    public I getImpl() {
        return this.impl;
    }

    public String getTooltipText() {
        return this.impl.getTooltipText();
    }

    public void addDuplicateOrConflict(I i) {
        this.duplicates.add(i);
    }

    public void removeDuplicateOrConflict(I i) {
        this.duplicates.remove(i);
    }

    public Set<I> getDuplicatesOrConflicts() {
        return Collections.unmodifiableSet(this.duplicates);
    }

    public I getParent() {
        if (this.parentAfterFix != null) {
            return this.parentAfterFix;
        }
        return this.impl.getParent();
    }

    public void setParent(I newParent) {
        this.parentAfterFix = newParent;
    }

    public void setImpl(I i) {
        this.impl = i;
    }

    boolean isRoot() {
        return this.level == 0;
    }

    public void setPrimaryLevel(int i) {
        this.level = i;
    }

    public int getPrimaryLevel() {
        return this.level;
    }

    int getManagedState() {
        return this.managedState;
    }

    public void setManagedState(int state) {
        this.managedState = state;
    }

    int getConflictType(Function<I, Boolean> isConflict, BiFunction<I, I, Integer> compare) {
        int ret = 0;
        for (GraphNodeImplementation dupl : this.duplicates) {
            if (!isConflict.apply(dupl).booleanValue()) continue;
            int result = compare.apply(this.impl, dupl);
            if (result < 0) {
                return 2;
            }
            if (result <= 0) continue;
            ret = 1;
        }
        return ret;
    }

    public boolean represents(I i) {
        if (this.impl.equals(i)) {
            return true;
        }
        for (GraphNodeImplementation dupl : this.duplicates) {
            if (!i.equals(dupl)) continue;
            return true;
        }
        return false;
    }
}

