/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitUser;

public final class GitTag {
    private final String id;
    private final String name;
    private final String message;
    private final String taggedObject;
    private final GitUser tagger;
    private final GitObjectType type;
    private boolean lightWeight;

    GitTag(RevTag revTag) {
        this.id = ObjectId.toString((ObjectId)revTag.getId());
        this.name = revTag.getTagName();
        this.message = revTag.getFullMessage();
        this.taggedObject = ObjectId.toString((ObjectId)revTag.getObject().getId());
        PersonIdent personIdent = revTag.getTaggerIdent();
        if (personIdent == null) {
            personIdent = new PersonIdent("", "");
        }
        this.tagger = new GitUser(personIdent.getName(), personIdent.getEmailAddress());
        this.type = this.getType(revTag.getObject());
        this.lightWeight = false;
    }

    GitTag(String tagName, RevObject revObject) {
        this.id = ObjectId.toString((ObjectId)revObject.getId());
        this.name = tagName;
        this.message = null;
        this.taggedObject = this.id;
        this.tagger = null;
        this.type = this.getType(revObject);
        this.lightWeight = true;
    }

    GitTag(String tagName, GitRevisionInfo revCommit) {
        this.id = revCommit.getRevision();
        this.name = tagName;
        this.message = revCommit.getFullMessage();
        this.taggedObject = this.id;
        this.tagger = revCommit.getAuthor() == null ? revCommit.getCommitter() : revCommit.getAuthor();
        this.type = GitObjectType.COMMIT;
        this.lightWeight = true;
    }

    public String getTagId() {
        return this.id;
    }

    public String getTagName() {
        return this.name;
    }

    public String getTaggedObjectId() {
        return this.taggedObject;
    }

    public String getMessage() {
        return this.message;
    }

    public GitUser getTagger() {
        return this.tagger;
    }

    public GitObjectType getTaggedObjectType() {
        return this.type;
    }

    public boolean isLightWeight() {
        return this.lightWeight;
    }

    private GitObjectType getType(RevObject object) {
        GitObjectType objType = GitObjectType.UNKNOWN;
        if (object != null) {
            switch (object.getType()) {
                case 1: {
                    objType = GitObjectType.COMMIT;
                    break;
                }
                case 3: {
                    objType = GitObjectType.BLOB;
                    break;
                }
                case 4: {
                    objType = GitObjectType.TAG;
                    break;
                }
                case 2: {
                    objType = GitObjectType.TREE;
                }
            }
        }
        return objType;
    }
}

