/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.schema.completion.CompletionPaintComponent;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.openide.util.ImageUtilities;

public class AttributeResultItem
extends CompletionResultItem {
    public static final String ATTRIBUTE_EQUALS_AND_VALUE_STRING = "=\"\"";
    private int caretOffset = -1;

    public AttributeResultItem(AbstractAttribute attribute, CompletionContext context) {
        super((AXIComponent)attribute, context);
        this.itemText = attribute.getName();
        this.icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/xml/schema/completion/resources/attribute.png");
    }

    public AttributeResultItem(AbstractAttribute attribute, String prefix, CompletionContext context) {
        super((AXIComponent)attribute, context);
        this.itemText = prefix + ":" + attribute.getName();
        this.icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/xml/schema/completion/resources/attribute.png");
    }

    @Override
    protected String getInsertingText(JTextComponent component, int textPos, String primaryText, int removeLen) {
        this.createTokenSequence(component);
        int d = this.tokenSequence.move(textPos);
        if (!this.tokenSequence.moveNext()) {
            return super.getInsertingText(component, textPos, primaryText, removeLen);
        }
        Token token = this.tokenSequence.token();
        TokenId id = token.id();
        if (d == 0 && this.context.getTypedChars() == null) {
            if (id == XMLTokenId.ARGUMENT) {
                this.caretOffset = 2;
                return primaryText + " ";
            }
            this.caretOffset = 1;
            return primaryText;
        }
        if (id != XMLTokenId.ARGUMENT) {
            this.caretOffset = 1;
            return primaryText;
        }
        while (this.tokenSequence.moveNext()) {
            token = this.tokenSequence.token();
            id = token.id();
            if (id == XMLTokenId.WS || id == XMLTokenId.OPERATOR || id != XMLTokenId.VALUE) continue;
            this.caretOffset = 0;
            return primaryText.substring(0, primaryText.length() - 1);
        }
        this.caretOffset = 1;
        return primaryText;
    }

    @Override
    protected int caretOffset() {
        return this.caretOffset;
    }

    @Override
    protected int removeTextLength(JTextComponent component, int offset, int removeLength) {
        if (removeLength <= 0) {
            return super.removeTextLength(component, offset, removeLength);
        }
        TokenSequence s = this.createTokenSequence(component);
        s.move(offset);
        if (!s.moveNext()) {
            return super.removeTextLength(component, offset, removeLength);
        }
        TokenId id = s.token().id();
        if (id != XMLTokenId.ARGUMENT) {
            return s.token().length() - (offset - s.offset());
        }
        int l = s.offset() + s.token().length();
        while (s.moveNext()) {
            id = s.token().id();
            if (id == XMLTokenId.VALUE) {
                return s.offset() - offset + 1;
            }
            if (id != XMLTokenId.WS && id != XMLTokenId.OPERATOR) break;
            l = s.offset() + s.token().length();
        }
        return l - offset;
    }

    @Override
    public String getReplacementText() {
        return this.itemText + ATTRIBUTE_EQUALS_AND_VALUE_STRING;
    }

    @Override
    public String getDisplayText() {
        return this.getItemText();
    }

    @Override
    public CompletionPaintComponent getPaintComponent() {
        if (this.component == null) {
            this.component = new CompletionPaintComponent.AttributePaintComponent(this);
        }
        return this.component;
    }

    @Override
    public int getCaretPosition() {
        return this.getReplacementText().length() - this.caretOffset;
    }
}

