/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread.graph;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.TestNGException;
import org.testng.internal.DynamicGraph;
import org.testng.internal.thread.TestNGThreadFactory;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;

public class GraphThreadPoolExecutor<T>
extends ThreadPoolExecutor {
    private final DynamicGraph<T> m_graph;
    private final Queue<Runnable> m_activeRunnables = new ConcurrentLinkedDeque<Runnable>();
    private final IThreadWorkerFactory<T> m_factory;

    public GraphThreadPoolExecutor(String string, DynamicGraph<T> dynamicGraph, IThreadWorkerFactory<T> iThreadWorkerFactory, int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue, new TestNGThreadFactory(string));
        this.m_graph = dynamicGraph;
        this.m_factory = iThreadWorkerFactory;
        if (this.m_graph.getFreeNodes().isEmpty()) {
            throw new TestNGException("The graph of methods contains a cycle:" + dynamicGraph.getEdges());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            List<T> list = this.m_graph.getFreeNodes();
            this.runNodes(list);
        }
    }

    private void runNodes(List<T> list) {
        List<IWorker<T>> list2 = this.m_factory.createWorkers(list);
        for (IWorker<T> iWorker : list2) {
            this.m_activeRunnables.add(iWorker);
            this.setStatus(iWorker, DynamicGraph.Status.RUNNING);
            try {
                this.execute(iWorker);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(IWorker<T> iWorker, DynamicGraph.Status status) {
        if (status == DynamicGraph.Status.FINISHED) {
            this.m_activeRunnables.remove(iWorker);
        }
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            for (T t : iWorker.getTasks()) {
                this.m_graph.setStatus(t, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterExecute(Runnable runnable, Throwable throwable) {
        this.setStatus((IWorker)runnable, DynamicGraph.Status.FINISHED);
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            if (this.m_graph.getNodeCount() == this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED)) {
                this.shutdown();
            } else {
                List<T> list = this.m_graph.getFreeNodes();
                this.runNodes(list);
            }
        }
    }
}

