/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.CssDeclarationContext;
import org.netbeans.modules.css.editor.ParsingErrorsFilter;
import org.netbeans.modules.css.editor.csl.CssErrorFactory;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.SemanticAnalyzerResult;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.ErrorsProvider;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.ResolvedProperty;
import org.netbeans.modules.css.lib.api.properties.Token;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NotImplementedException;

public class CssAnalyser
implements ErrorsProvider {
    private static final String UNKNOWN_PROPERTY_BUNDLE_KEY = "unknown_property";
    private static final String UNKNOWN_PROPERTY_ERROR_KEY_DELIMITER = "/";
    private static final String UNKNOWN_PROPERTY_ERROR_KEY = "unknown_property/";
    private static final String INVALID_PROPERTY_VALUE = "invalid_property_value";
    private static final Collection<String> NON_CSS21_DECLARATION_PROPERTY_NAMES = Arrays.asList("opacity", "resize", "text-overflow", "text-shadow", "filter");
    private static final Collection<String> NON_CSS21_DECLARATION_PROPERTY_VALUES = Arrays.asList("expression");

    public List<? extends FilterableError> getExtendedDiagnostics(CssParserResult parserResult) {
        Node node = parserResult.getParseTree();
        final Snapshot snapshot = parserResult.getSnapshot();
        final FileObject file = snapshot.getSource().getFileObject();
        ArrayList errors = new ArrayList();
        NodeVisitor<List<FilterableError>> visitor = new NodeVisitor<List<FilterableError>>(errors){

            public boolean visit(Node node) {
                if (node.type() == NodeType.propertyDeclaration) {
                    Node parent = node.parent().parent();
                    if (parent.type() == NodeType.declarations) {
                        switch (parent.parent().type()) {
                            case fontFace: 
                            case counterStyle: {
                                return false;
                            }
                        }
                    }
                    SemanticAnalyzerResult analyzeDeclaration = CssModuleSupport.analyzeDeclaration(node);
                    switch (analyzeDeclaration.getType()) {
                        case ERRONEOUS: {
                            throw new NotImplementedException();
                        }
                        case VALID: {
                            return false;
                        }
                    }
                    if (Css3Utils.containsGeneratedCode(node.image())) {
                        return false;
                    }
                    CssDeclarationContext ctx = new CssDeclarationContext(node);
                    Node propertyNode = ctx.getProperty();
                    Node valueNode = ctx.getPropertyValue();
                    if (propertyNode != null) {
                        String propertyName = NodeUtil.unescape((CharSequence)ctx.getPropertyNameImage());
                        if (CssAnalyser.isNonCss21CompatibleDeclarationPropertyName(propertyName)) {
                            return false;
                        }
                        PropertyDefinition property = Properties.getPropertyDefinition((String)propertyName);
                        if (!Css3Utils.containsGeneratedCode(propertyName) && !Css3Utils.isVendorSpecificProperty(propertyName) && property == null) {
                            FileObject file2;
                            String msg = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.UNKNOWN_PROPERTY_BUNDLE_KEY, (Object)propertyName);
                            String key = CssAnalyser.UNKNOWN_PROPERTY_ERROR_KEY + propertyName;
                            FilterableError error = CssErrorFactory.createError(key, msg, msg, file2 = snapshot.getSource().getFileObject(), propertyNode.from(), propertyNode.to(), false, Severity.WARNING, ParsingErrorsFilter.getEnableFilterAction(file2, key), ParsingErrorsFilter.getDisableFilterAction(file2, key));
                            if (error != null) {
                                ((List)this.getResult()).add(error);
                            }
                        }
                        if (valueNode != null && property != null) {
                            ResolvedProperty pv;
                            if (NodeUtil.containsError((Node)valueNode)) {
                                return false;
                            }
                            String valueImage = ctx.getPropertyValueImage();
                            if (!(Css3Utils.containsGeneratedCode(valueImage) || Css3Utils.isVendorSpecificPropertyValue(file, valueImage) || (pv = new ResolvedProperty(file, property, (CharSequence)valueImage)).isResolved() || ctx.containsIEBS9Hack() || ctx.containsIEStarHack())) {
                                FilterableError error;
                                String errorMsg = null;
                                List unresolved = pv.getUnresolvedTokens();
                                if (unresolved.isEmpty()) {
                                    return false;
                                }
                                Token unexpectedToken = (Token)unresolved.iterator().next();
                                if (CssAnalyser.isNonCss21CompatiblePropertyValue(unexpectedToken.toString())) {
                                    return false;
                                }
                                CharSequence unexpectedTokenImg = unexpectedToken.image();
                                if (Css3Utils.isVendorSpecificPropertyValue(file, unexpectedTokenImg)) {
                                    return false;
                                }
                                if (errorMsg == null) {
                                    errorMsg = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.INVALID_PROPERTY_VALUE, (Object)unexpectedToken.image().toString());
                                }
                                if ((error = CssAnalyser.makeError(valueNode.from(), valueNode.to(), snapshot, CssAnalyser.INVALID_PROPERTY_VALUE, errorMsg, errorMsg, false, Severity.WARNING)) != null) {
                                    ((List)this.getResult()).add(error);
                                }
                            }
                        }
                    }
                }
                return false;
            }
        };
        visitor.visitChildren(node);
        return errors;
    }

    private static FilterableError makeError(int astFrom, int astTo, Snapshot snapshot, String key, String displayName, String description, boolean lineError, Severity severity) {
        assert (astFrom <= astTo);
        return CssErrorFactory.createError(key, displayName, description, snapshot.getSource().getFileObject(), astFrom, astTo, lineError, severity);
    }

    public static boolean isConfigurableError(String errorKey) {
        return CssAnalyser.isUnknownPropertyError(errorKey);
    }

    public static boolean isUnknownPropertyError(String errorKey) {
        return errorKey.startsWith(UNKNOWN_PROPERTY_ERROR_KEY);
    }

    public static String getUnknownPropertyName(String unknownPropertyErrorKey) {
        assert (unknownPropertyErrorKey.startsWith(UNKNOWN_PROPERTY_ERROR_KEY));
        int index = unknownPropertyErrorKey.indexOf(UNKNOWN_PROPERTY_ERROR_KEY_DELIMITER);
        return unknownPropertyErrorKey.substring(index + 1);
    }

    private static boolean isNonCss21CompatibleDeclarationPropertyName(String propertyName) {
        return NON_CSS21_DECLARATION_PROPERTY_NAMES.contains(propertyName);
    }

    private static boolean isNonCss21CompatiblePropertyValue(String propertyValue) {
        return NON_CSS21_DECLARATION_PROPERTY_VALUES.contains(propertyValue);
    }
}

