/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import com.oracle.bmc.identity.Identity;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.IncompatibleTenancyItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.openide.NotifyDescriptor;

public final class CompartmentStep
extends AbstractStep<CompartmentItem> {
    private Map<String, OCIItem> compartments = null;
    private TenancyItem tenancy;
    private CompartmentItem selected;

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        h.progress(Bundle.CollectingItems_Text());
        this.tenancy = (TenancyItem)values.getValueForStep(TenancyStep.class);
        this.compartments = this.tenancy != null && !(this.tenancy instanceof IncompatibleTenancyItem) ? CompartmentStep.getFlatCompartment(this.tenancy) : Collections.emptyMap();
    }

    @Override
    public NotifyDescriptor createInput() {
        if (this.tenancy == null) {
            return new NotifyDescriptor.QuickPick("", Bundle.NoTenancy(), Collections.emptyList(), false);
        }
        if (this.tenancy instanceof IncompatibleTenancyItem) {
            return new NotifyDescriptor.QuickPick("", Bundle.IncompatibleTenancy(), Collections.emptyList(), false);
        }
        if (this.onlyOneChoice()) {
            throw new IllegalStateException("Input shouldn't be displayed for one choice");
        }
        if (this.compartments.isEmpty()) {
            return Steps.createQuickPick(this.compartments, Bundle.NoCompartment());
        }
        return Steps.createQuickPick(this.compartments, Bundle.SelectCompartment());
    }

    @Override
    public void setValue(String selected) {
        this.selected = (CompartmentItem)this.compartments.get(selected);
    }

    @Override
    public CompartmentItem getValue() {
        if (this.onlyOneChoice()) {
            return (CompartmentItem)this.compartments.values().iterator().next();
        }
        return this.selected;
    }

    @Override
    public boolean onlyOneChoice() {
        return this.compartments.size() == 1;
    }

    private static Map<String, OCIItem> getFlatCompartment(TenancyItem tenancy) {
        ListCompartmentsResponse response;
        final HashMap<OCID, FlatCompartmentItem> compartments = new HashMap<OCID, FlatCompartmentItem>();
        OCIProfile session = OCIManager.getDefault().getActiveProfile(tenancy);
        Identity identityClient = session.newClient(IdentityClient.class);
        String nextPageToken = null;
        String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
        String regionCode = session.getRegion().getRegionCode();
        do {
            response = identityClient.listCompartments(ListCompartmentsRequest.builder().compartmentId(tenancy.getKey().getValue()).compartmentIdInSubtree(true).lifecycleState(Compartment.LifecycleState.Active).accessLevel(ListCompartmentsRequest.AccessLevel.Accessible).limit(1000).page(nextPageToken).build());
            for (Compartment comp : response.getItems()) {
                FlatCompartmentItem ci = new FlatCompartmentItem(comp, tenancyId, regionCode){

                    @Override
                    FlatCompartmentItem getItem(OCID compId) {
                        return (FlatCompartmentItem)compartments.get(compId);
                    }
                };
                compartments.put(ci.getKey(), ci);
            }
        } while ((nextPageToken = response.getOpcNextPage()) != null);
        Map<String, OCIItem> pickItems = CompartmentStep.computeFlatNames(compartments);
        pickItems.put(Bundle.Root(tenancy.getName()), tenancy);
        return pickItems;
    }

    private static Map<String, OCIItem> computeFlatNames(Map<OCID, FlatCompartmentItem> compartments) {
        TreeMap<String, OCIItem> pickItems = new TreeMap<String, OCIItem>(String.CASE_INSENSITIVE_ORDER);
        for (FlatCompartmentItem comp : compartments.values()) {
            pickItems.put(comp.getName(), comp);
        }
        return pickItems;
    }

    private static abstract class FlatCompartmentItem
    extends CompartmentItem {
        private final OCID parentId;
        private String flatName;

        private FlatCompartmentItem(Compartment ociComp, String tenancyId, String regionCode) {
            super(OCID.of(ociComp.getId(), "Compartment"), ociComp.getCompartmentId(), ociComp.getName(), tenancyId, regionCode);
            this.setDescription(ociComp.getDescription());
            this.parentId = OCID.of(ociComp.getCompartmentId(), "Compartment");
        }

        @Override
        public String getName() {
            if (this.parentId.getValue() == null) {
                return "";
            }
            if (this.flatName == null) {
                String parentFlatName = "";
                FlatCompartmentItem parentComp = this.getItem(this.parentId);
                if (parentComp != null) {
                    parentFlatName = parentComp.getName();
                }
                this.flatName = super.getName();
                if (!parentFlatName.isEmpty()) {
                    this.flatName = parentFlatName + "/" + this.flatName;
                }
            }
            return this.flatName;
        }

        abstract FlatCompartmentItem getItem(OCID var1);
    }
}

