/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetMirrorRecordRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private MirrorRecordType mirrorRecordType;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public MirrorRecordType getMirrorRecordType() {
        return this.mirrorRecordType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).mirrorRecordType(this.mirrorRecordType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",mirrorRecordType=").append(String.valueOf((Object)this.mirrorRecordType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMirrorRecordRequest)) {
            return false;
        }
        GetMirrorRecordRequest other = (GetMirrorRecordRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals((Object)this.mirrorRecordType, (Object)other.mirrorRecordType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.mirrorRecordType == null ? 43 : this.mirrorRecordType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMirrorRecordRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private MirrorRecordType mirrorRecordType = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder mirrorRecordType(MirrorRecordType mirrorRecordType) {
            this.mirrorRecordType = mirrorRecordType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMirrorRecordRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.mirrorRecordType(o.getMirrorRecordType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMirrorRecordRequest build() {
            GetMirrorRecordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMirrorRecordRequest buildWithoutInvocationCallback() {
            GetMirrorRecordRequest request = new GetMirrorRecordRequest();
            request.repositoryId = this.repositoryId;
            request.mirrorRecordType = this.mirrorRecordType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum MirrorRecordType implements BmcEnum
    {
        Current("current"),
        LastSuccessful("lastSuccessful");

        private final String value;
        private static Map<String, MirrorRecordType> map;

        private MirrorRecordType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MirrorRecordType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MirrorRecordType: " + key);
        }

        static {
            map = new HashMap<String, MirrorRecordType>();
            for (MirrorRecordType v : MirrorRecordType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

