/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.OkeCanaryStrategy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="strategyType")
@JsonFilter(value="explicitlySetFilter")
public final class NginxCanaryStrategy
extends OkeCanaryStrategy {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="ingressName")
    private final String ingressName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public NginxCanaryStrategy(String namespace, String ingressName) {
        this.namespace = namespace;
        this.ingressName = ingressName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getIngressName() {
        return this.ingressName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NginxCanaryStrategy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", ingressName=").append(String.valueOf(this.ingressName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NginxCanaryStrategy)) {
            return false;
        }
        NginxCanaryStrategy other = (NginxCanaryStrategy)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.ingressName, other.ingressName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.ingressName == null ? 43 : this.ingressName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="ingressName")
        private String ingressName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder ingressName(String ingressName) {
            this.ingressName = ingressName;
            this.__explicitlySet__.add("ingressName");
            return this;
        }

        public NginxCanaryStrategy build() {
            NginxCanaryStrategy model = new NginxCanaryStrategy(this.namespace, this.ingressName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NginxCanaryStrategy model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("ingressName")) {
                this.ingressName(model.getIngressName());
            }
            return this;
        }
    }
}

