/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.admin.AdminFactoryHttp;
import org.netbeans.modules.payara.tooling.admin.AdminFactoryRest;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.Runner;
import org.netbeans.modules.payara.tooling.data.PayaraAdminInterface;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;

public abstract class AdminFactory {
    private static final Logger LOGGER = new Logger(AdminFactory.class);

    static AdminFactory getInstance(PayaraPlatformVersionAPI version) throws CommandException {
        if (version.isMinimumSupportedVersion()) {
            return AdminFactoryRest.getInstance();
        }
        throw new CommandException("Unknown Payara version");
    }

    public static AdminFactory getInstance(PayaraAdminInterface adminInterface) throws CommandException {
        switch (adminInterface) {
            case REST: {
                return AdminFactoryRest.getInstance();
            }
            case HTTP: {
                return AdminFactoryHttp.getInstance();
            }
        }
        throw new CommandException("Unknown Payara administration interface type");
    }

    public abstract Runner getRunner(PayaraServer var1, Command var2);

    Runner newRunner(PayaraServer srv, Command cmd, Class runnerClass) throws CommandException {
        String METHOD = "newRunner";
        Constructor con = null;
        Runner runner = null;
        try {
            con = runnerClass.getConstructor(PayaraServer.class, Command.class);
        }
        catch (NoSuchMethodException | SecurityException nsme) {
            throw new CommandException("Cannot initialize Runner class", nsme);
        }
        if (con == null) {
            return runner;
        }
        try {
            runner = (Runner)con.newInstance(srv, cmd);
        }
        catch (IllegalAccessException | InstantiationException ie) {
            throw new CommandException("Cannot initialize Runner class", ie);
        }
        catch (InvocationTargetException ite) {
            LOGGER.log(Level.WARNING, "exceptionMsg", ite.getMessage());
            Throwable t = ite.getCause();
            if (t != null) {
                LOGGER.log(Level.WARNING, "cause", t.getMessage());
            }
            throw new CommandException("Cannot initialize Runner class", ite);
        }
        return runner;
    }
}

