/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lsp.CodeAction;
import org.netbeans.api.lsp.Position;
import org.netbeans.modules.lsp.DiagnosticUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class Diagnostic {
    private final Position startPosition;
    private final Position endPosition;
    private final String description;
    private final Severity severity;
    private final String code;
    private final LazyCodeActions actions;
    private final URL codeDescription;

    private Diagnostic(Position startPosition, Position endPosition, String description, Severity severity, String code, URL codeDescription, LazyCodeActions actions) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.description = description;
        this.severity = severity;
        this.code = code;
        this.codeDescription = codeDescription;
        this.actions = actions;
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public String getDescription() {
        return this.description;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getCode() {
        return this.code;
    }

    public URL getCodeDescription() {
        return this.codeDescription;
    }

    public LazyCodeActions getActions() {
        return this.actions;
    }

    public static ReporterControl findReporterControl(@NullAllowed Lookup context, @NullAllowed FileObject file) {
        return DiagnosticUtils.findReporterControl(context, file);
    }

    public static enum Severity {
        Error,
        Warning,
        Hint,
        Information;

    }

    public static interface LazyCodeActions {
        public List<CodeAction> computeCodeActions(Consumer<Exception> var1);
    }

    public static interface ReporterControl {
        public void diagnosticChanged(Collection<FileObject> var1, String var2);
    }

    public static final class Builder {
        private final Position startPosition;
        private final Position endPosition;
        private final String description;
        private Severity severity;
        private String code;
        private URL codeDescription;
        private LazyCodeActions actions;

        private Builder(Position startPosition, Position endPosition, String description) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.description = description;
        }

        public static Builder create(Position startPosition, Position endPosition, String description) {
            return new Builder(startPosition, endPosition, description);
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Builder setCodeDescription(URL codeDescription) {
            this.codeDescription = codeDescription;
            return this;
        }

        public Builder addActions(LazyCodeActions actions) {
            this.actions = actions;
            return this;
        }

        public Diagnostic build() {
            return new Diagnostic(this.startPosition, this.endPosition, this.description, this.severity, this.code, this.codeDescription, this.actions);
        }
    }
}

