/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.dependencies;

import java.io.File;
import java.util.LinkedHashSet;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.dependencies.Bundle;
import org.netbeans.modules.gradle.dependencies.DependencyAdder;
import org.netbeans.modules.gradle.dependencies.RewriteContext;
import org.netbeans.modules.project.dependency.DependencyChange;
import org.netbeans.modules.project.dependency.DependencyChangeException;
import org.netbeans.modules.project.dependency.DependencyChangeRequest;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.spi.ProjectDependencyModifier;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DependencyModifierImpl
implements ProjectDependencyModifier {
    private final Project project;

    public DependencyModifierImpl(Project project) {
        this.project = project;
    }

    void assertProjectMetadataCorrect() throws DependencyChangeException {
        NbGradleProject gp = NbGradleProject.get((Project)this.project);
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        for (File f : gp.getGradleFiles().getProjectFiles()) {
            EditorCookie cake;
            FileObject fo = FileUtil.toFileObject((File)f);
            if (fo == null || (cake = (EditorCookie)fo.getLookup().lookup(EditorCookie.class)) == null || !cake.isModified()) continue;
            files.add(fo);
        }
        if (!files.isEmpty()) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.OUT_OF_SYNC, Bundle.ERR_ProjectFilesOutOfSync(), files);
        }
    }

    public ProjectDependencyModifier.Result computeChange(DependencyChangeRequest request) throws DependencyChangeException {
        DependencyResult r = ProjectDependencies.findDependencies((Project)this.project, (ProjectDependencies.DependencyQuery)ProjectDependencies.newQuery((Scope[])new Scope[]{Scopes.DECLARED}));
        if (r == null) {
            return null;
        }
        this.assertProjectMetadataCorrect();
        RewriteContext context = new RewriteContext(this.project, r);
        DependencyAdder adder = new DependencyAdder(this.project, context);
        block3: for (DependencyChange change : request.getOperations()) {
            switch (change.getKind()) {
                case ADD: {
                    adder.processRequest(change);
                    continue block3;
                }
            }
            throw new DependencyChangeException(change, null, DependencyChangeException.Reason.MALFORMED);
        }
        adder.execute();
        final WorkspaceEdit e = context.createWorkspaceEdit();
        return new ProjectDependencyModifier.Result(){

            public String getId() {
                return "project-dependency-add";
            }

            public boolean suppresses(ProjectDependencyModifier.Result check) {
                return false;
            }

            public WorkspaceEdit getWorkspaceEdit() {
                return e;
            }
        };
    }
}

