/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAddonRequest
extends BmcRequest<Void> {
    private String clusterId;
    private String addonName;
    private String opcRequestId;

    public String getClusterId() {
        return this.clusterId;
    }

    public String getAddonName() {
        return this.addonName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().clusterId(this.clusterId).addonName(this.addonName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",clusterId=").append(String.valueOf(this.clusterId));
        sb.append(",addonName=").append(String.valueOf(this.addonName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAddonRequest)) {
            return false;
        }
        GetAddonRequest other = (GetAddonRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.clusterId, other.clusterId) && Objects.equals(this.addonName, other.addonName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.addonName == null ? 43 : this.addonName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAddonRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String clusterId = null;
        private String addonName = null;
        private String opcRequestId = null;

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAddonRequest o) {
            this.clusterId(o.getClusterId());
            this.addonName(o.getAddonName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAddonRequest build() {
            GetAddonRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAddonRequest buildWithoutInvocationCallback() {
            GetAddonRequest request = new GetAddonRequest();
            request.clusterId = this.clusterId;
            request.addonName = this.addonName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

