/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SQLFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    private static final String SQL_MIME_TYPE = "text/x-sql";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset getEncoding(FileObject file) {
        String mimeType = FileUtil.getMIMEType((FileObject)file, (String[])new String[]{SQL_MIME_TYPE});
        if (mimeType != null && mimeType.equals(SQL_MIME_TYPE)) {
            byte[] buff = new byte[4];
            InputStream is = null;
            int bytesRead = 0;
            try {
                is = file.getInputStream();
                bytesRead = is.read(buff);
            }
            catch (Exception exception) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (bytesRead == 4 && SQLFileEncodingQueryImpl.isUTF16(buff)) {
                return StandardCharsets.UTF_16;
            }
        }
        return null;
    }

    private static boolean isUTF16(byte[] buff) {
        switch (buff[0]) {
            case -2: {
                return buff[1] == -1 && (buff[2] != 0 || buff[3] != 0);
            }
            case -1: {
                return buff[1] == -2 && (buff[2] != 0 || buff[3] != 0);
            }
        }
        return false;
    }
}

