/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.jstesting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.clientproject.jstesting.JsTestingProviderAccessor;
import org.netbeans.modules.web.clientproject.jstesting.JsTestingProviderRenderer;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CustomizerJsTesting
extends JPanel
implements ChangeListener {
    private final ProjectCustomizer.Category category;
    private final Project project;
    private final JsTestingProvider originalProvider;
    private final Map<JsTestingProvider, CustomizerPanelImplementation> providerPanels;
    private final UsageLogger usageLogger = new UsageLogger.Builder("org.netbeans.ui.metrics.web.common").message(UsageLogger.class, "USG_TEST_CONFIG_JS").firstMessageOnly(false).create();
    volatile JsTestingProvider selectedProvider;
    volatile CustomizerPanelImplementation selectedPanel;
    private JComboBox<JsTestingProvider> providerComboBox;
    private JLabel providerLabel;
    private JPanel providerPanel;
    private JSeparator separator;

    CustomizerJsTesting(ProjectCustomizer.Category category, Project project) {
        assert (EventQueue.isDispatchThread());
        assert (category != null);
        assert (project != null);
        this.category = category;
        this.project = project;
        this.originalProvider = JsTestingProviders.getDefault().getJsTestingProvider(project, false);
        this.providerPanels = this.createProviderPanels();
        this.selectedProvider = this.originalProvider;
        this.selectedPanel = this.getSelectedPanel();
        this.initComponents();
        this.init();
    }

    private Map<JsTestingProvider, CustomizerPanelImplementation> createProviderPanels() {
        HashMap<JsTestingProvider, CustomizerPanelImplementation> panels = new HashMap<JsTestingProvider, CustomizerPanelImplementation>();
        for (JsTestingProvider provider : JsTestingProviders.getDefault().getJsTestingProviders()) {
            panels.put(provider, JsTestingProviderAccessor.getDefault().createCustomizerPanel(provider, this.project));
        }
        return panels;
    }

    private void init() {
        this.providerComboBox.addItem(null);
        for (JsTestingProvider provider : JsTestingProviders.getDefault().getJsTestingProviders()) {
            this.providerComboBox.addItem(provider);
        }
        this.providerComboBox.setSelectedItem(this.originalProvider);
        this.providerComboBox.setRenderer(new JsTestingProviderRenderer());
        this.providerComboBox.addActionListener(new ProviderActionListener());
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerJsTesting.this.storeData();
            }
        });
        this.category.setCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerJsTesting.this.cleanup();
            }
        });
        this.providerChanged();
    }

    void providerChanged() {
        assert (EventQueue.isDispatchThread());
        if (this.selectedPanel != null) {
            this.selectedPanel.removeChangeListener(this);
        }
        this.providerPanel.removeAll();
        this.selectedProvider = (JsTestingProvider)this.providerComboBox.getSelectedItem();
        this.selectedPanel = this.getSelectedPanel();
        if (this.selectedPanel != null) {
            this.selectedPanel.addChangeListener(this);
            this.providerPanel.add((Component)this.selectedPanel.getComponent(), "Center");
        }
        this.providerPanel.revalidate();
        this.providerPanel.repaint();
        this.validateData();
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        if (this.selectedProvider == null) {
            this.category.setErrorMessage(null);
            this.category.setValid(true);
            return;
        }
        if (this.selectedPanel == null) {
            this.category.setErrorMessage(null);
            this.category.setValid(true);
            return;
        }
        if (this.selectedPanel.isValid()) {
            this.category.setErrorMessage(this.selectedPanel.getWarningMessage());
            this.category.setValid(true);
            return;
        }
        assert (this.selectedPanel.getErrorMessage() != null) : "Error must be return for invalid panel of " + this.selectedProvider;
        this.category.setErrorMessage(this.selectedPanel.getErrorMessage());
        this.category.setValid(false);
    }

    void storeData() {
        assert (!EventQueue.isDispatchThread());
        if (this.selectedPanel != null) {
            this.selectedPanel.save();
        }
        if (Objects.equals(this.originalProvider, this.selectedProvider)) {
            return;
        }
        this.usageLogger.log(new Object[]{this.project.getClass().getName(), this.selectedProvider == null ? "" : this.selectedProvider.getIdentifier()});
        if (this.originalProvider != null) {
            JsTestingProviderAccessor.getDefault().notifyEnabled(this.originalProvider, this.project, false);
        }
        if (this.selectedProvider != null) {
            JsTestingProviderAccessor.getDefault().notifyEnabled(this.selectedProvider, this.project, true);
        }
    }

    void cleanup() {
        if (this.selectedPanel != null) {
            this.selectedPanel.removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validateData();
    }

    @CheckForNull
    private CustomizerPanelImplementation getSelectedPanel() {
        assert (EventQueue.isDispatchThread());
        assert (this.providerPanels != null);
        return this.providerPanels.get(this.selectedProvider);
    }

    private void initComponents() {
        this.providerLabel = new JLabel();
        this.providerComboBox = new JComboBox();
        this.separator = new JSeparator();
        this.providerPanel = new JPanel();
        this.providerLabel.setLabelFor(this.providerComboBox);
        Mnemonics.setLocalizedText((JLabel)this.providerLabel, (String)NbBundle.getMessage(CustomizerJsTesting.class, (String)"CustomizerJsTesting.providerLabel.text"));
        this.providerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.providerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providerComboBox, -2, -1, -2)).addComponent(this.separator));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.providerLabel).addComponent(this.providerComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE)));
    }

    private final class ProviderActionListener
    implements ActionListener {
        private ProviderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerJsTesting.this.providerChanged();
        }
    }
}

