/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.SystemReader;

public class InstallBuiltinLfsCommand
implements LfsFactory.LfsInstallCommand {
    private static final String[] ARGS_USER = new String[]{"lfs", "install"};
    private static final String[] ARGS_LOCAL = new String[]{"lfs", "install", "--local"};
    private Repository repository;

    public Void call() throws IOException, InvalidConfigurationException, InterruptedException {
        StoredConfig cfg = null;
        if (this.repository == null) {
            try {
                cfg = SystemReader.getInstance().getUserConfig();
            }
            catch (ConfigInvalidException e) {
                throw new InvalidConfigurationException(e.getMessage(), (Throwable)e);
            }
        } else {
            cfg = this.repository.getConfig();
        }
        cfg.setBoolean("filter", "lfs", "useJGitBuiltin", true);
        cfg.setBoolean("filter", "lfs", "required", true);
        cfg.save();
        ProcessBuilder builder = FS.DETECTED.runInShell("git", this.repository == null ? ARGS_USER : ARGS_LOCAL);
        if (this.repository != null) {
            builder.directory(this.repository.isBare() ? this.repository.getDirectory() : this.repository.getWorkTree());
        }
        FS.DETECTED.runProcess(builder, null, null, null);
        return null;
    }

    public LfsFactory.LfsInstallCommand setRepository(Repository repo) {
        this.repository = repo;
        return this;
    }
}

