/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.ClassMap;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.api.JUnitVersion;

final class JUnit3TestGenerator
extends AbstractTestGenerator {
    private static final String TEST = "junit.framework.Test";
    private static final String TEST_CASE = "junit.framework.TestCase";
    private static final String TEST_SUITE = "junit.framework.TestSuite";
    private static final String OVERRIDE = "java.lang.Override";
    private final boolean useAnnotations;
    private TypeElement testTypeElem;

    JUnit3TestGenerator(TestGeneratorSetup setup, String sourceLevel) {
        super(setup, JUnitVersion.JUNIT3);
        this.useAnnotations = JUnitTestUtil.areAnnotationsSupported(sourceLevel);
    }

    JUnit3TestGenerator(TestGeneratorSetup setup, List<ElementHandle<TypeElement>> srcTopClassHandles, List<String> suiteMembers, boolean isNewTestClass, String sourceLevel) {
        super(setup, srcTopClassHandles, suiteMembers, isNewTestClass, JUnitVersion.JUNIT3);
        this.useAnnotations = JUnitTestUtil.areAnnotationsSupported(sourceLevel);
    }

    @Override
    protected ClassTree composeNewTestClass(WorkingCopy workingCopy, String name, List<? extends Tree> members) {
        TreeMaker maker = workingCopy.getTreeMaker();
        ModifiersTree modifiers = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ExpressionTree extendsClause = this.getClassIdentifierTree(TEST_CASE, workingCopy);
        return maker.Class(modifiers, (CharSequence)name, Collections.emptyList(), (Tree)extendsClause, Collections.emptyList(), Collections.emptyList(), members);
    }

    @Override
    protected List<? extends Tree> generateInitMembers(WorkingCopy workingCopy) {
        if (!this.setup.isGenerateSetUp() && !this.setup.isGenerateTearDown()) {
            return Collections.emptyList();
        }
        TreeMaker maker = workingCopy.getTreeMaker();
        ArrayList<MethodTree> result = new ArrayList<MethodTree>(2);
        if (this.setup.isGenerateSetUp()) {
            result.add(this.generateInitMethod("setUp", maker, workingCopy));
        }
        if (this.setup.isGenerateTearDown()) {
            result.add(this.generateInitMethod("tearDown", maker, workingCopy));
        }
        return result;
    }

    @Override
    protected ClassTree generateMissingInitMembers(ClassTree tstClass, TreePath tstClassTreePath, WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateSetUp() || this.setup.isGenerateTearDown() || this.setup.isGenerateSuiteClasses())) {
            return tstClass;
        }
        ClassMap classMap = ClassMap.forClass(tstClass, tstClassTreePath, workingCopy.getTrees());
        if (!(this.setup.isGenerateSetUp() && !classMap.containsSetUp() || this.setup.isGenerateTearDown() && !classMap.containsTearDown() || this.setup.isGenerateSuiteClasses() && !classMap.containsNoArgMethod("suite"))) {
            return tstClass;
        }
        List<? extends Tree> tstMembersOrig = tstClass.getMembers();
        ArrayList<Tree> tstMembers = new ArrayList<Tree>(tstMembersOrig.size() + 2);
        tstMembers.addAll(tstMembersOrig);
        this.generateMissingInitMembers(tstMembers, classMap, workingCopy);
        this.generateTestClassSuiteMethod(tstClassTreePath, tstMembers, classMap, workingCopy);
        ClassTree newClass = workingCopy.getTreeMaker().Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstClass.getPermitsClause(), tstMembers);
        return newClass;
    }

    @Override
    protected boolean generateMissingInitMembers(List<Tree> tstMembers, ClassMap clsMap, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        boolean modified = false;
        if (this.setup.isGenerateSetUp() && !clsMap.containsSetUp()) {
            this.addInitMethod("setUp", clsMap.getTearDownIndex(), tstMembers, clsMap, treeMaker, workingCopy);
            modified = true;
        }
        if (this.setup.isGenerateTearDown() && !clsMap.containsTearDown()) {
            int setUpIndex = clsMap.getSetUpIndex();
            this.addInitMethod("tearDown", setUpIndex != -1 ? setUpIndex + 1 : -1, tstMembers, clsMap, treeMaker, workingCopy);
            modified = true;
        }
        return modified;
    }

    private void addInitMethod(String methodName, int targetIndex, List<Tree> clsMembers, ClassMap clsMap, TreeMaker treeMaker, WorkingCopy workingCopy) {
        MethodTree initMethod = this.generateInitMethod(methodName, treeMaker, workingCopy);
        if (targetIndex == -1) {
            targetIndex = this.getPlaceForFirstInitMethod(clsMap);
        }
        if (targetIndex != -1) {
            clsMembers.add(targetIndex, initMethod);
        } else {
            clsMembers.add(initMethod);
        }
        clsMap.addNoArgMethod(methodName, targetIndex);
    }

    protected MethodTree generateInitMethod(String methodName, TreeMaker maker, WorkingCopy workingCopy) {
        Set<Modifier> modifiers = Collections.singleton(Modifier.PROTECTED);
        ModifiersTree modifiersTree = this.useAnnotations ? this.createModifiersTree(OVERRIDE, modifiers, workingCopy) : maker.Modifiers(modifiers);
        MethodInvocationTree superMethodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)maker.Identifier((CharSequence)"super"), (CharSequence)methodName), Collections.emptyList());
        BlockTree methodBody = maker.Block(Collections.singletonList(maker.ExpressionStatement((ExpressionTree)superMethodCall)), false);
        MethodTree method = maker.Method(modifiersTree, (CharSequence)methodName, (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(maker.Identifier((CharSequence)"Exception")), methodBody, null);
        return method;
    }

    @Override
    protected void generateMissingPostInitMethods(TreePath tstClassTreePath, List<Tree> tstMembers, ClassMap clsMap, WorkingCopy workingCopy) {
        if (this.setup.isGenerateSuiteClasses()) {
            this.generateTestClassSuiteMethod(tstClassTreePath, tstMembers, clsMap, workingCopy);
        }
    }

    @Override
    protected MethodTree composeNewTestMethod(String testMethodName, BlockTree testMethodBody, List<ExpressionTree> throwsList, WorkingCopy workingCopy) {
        TreeMaker maker = workingCopy.getTreeMaker();
        return maker.Method(maker.Modifiers(JUnit3TestGenerator.createModifierSet(Modifier.PUBLIC)), (CharSequence)testMethodName, (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), throwsList, testMethodBody, null);
    }

    @Override
    protected ClassTree finishSuiteClass(ClassTree tstClass, TreePath tstClassTreePath, List<Tree> tstMembers, List<String> suiteMembers, boolean membersChanged, ClassMap classMap, WorkingCopy workingCopy) {
        MethodTree suiteMethod = this.generateSuiteMethod(tstClass.getSimpleName().toString(), suiteMembers, workingCopy);
        if (suiteMethod != null) {
            int suiteMethodIndex = classMap.findNoArgMethod("suite");
            if (suiteMethodIndex != -1) {
                tstMembers.set(suiteMethodIndex, suiteMethod);
            } else {
                int targetIndex = classMap.containsInitializers() ? classMap.getLastInitializerIndex() + 1 : (classMap.containsMethods() ? classMap.getFirstMethodIndex() : (classMap.containsNestedClasses() ? classMap.getFirstNestedClassIndex() : classMap.size()));
                if (targetIndex == classMap.size()) {
                    tstMembers.add(suiteMethod);
                } else {
                    tstMembers.add(targetIndex, suiteMethod);
                }
                classMap.addNoArgMethod("suite", targetIndex);
            }
            membersChanged = true;
        }
        if (!membersChanged) {
            return tstClass;
        }
        return workingCopy.getTreeMaker().Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstClass.getPermitsClause(), tstMembers);
    }

    private MethodTree generateSuiteMethod(String suiteName, List<String> members, WorkingCopy workingCopy) {
        Types types = workingCopy.getTypes();
        Elements elements = workingCopy.getElements();
        TreeMaker maker = workingCopy.getTreeMaker();
        ExpressionTree testSuiteIdentifier = this.getClassIdentifierTree(TEST_SUITE, workingCopy);
        TypeElement testTypeElem = this.getTestTypeElem(elements);
        if (testTypeElem == null) {
            return null;
        }
        TypeMirror testType = testTypeElem.asType();
        ArrayList<StatementTree> bodyContent = new ArrayList<StatementTree>(members.size() + 2);
        VariableTree suiteObjInit = maker.Variable(maker.Modifiers(JUnit3TestGenerator.noModifiers()), (CharSequence)"suite", (Tree)testSuiteIdentifier, (ExpressionTree)maker.NewClass(null, Collections.emptyList(), testSuiteIdentifier, Collections.singletonList(maker.Literal((Object)JUnitTestUtil.getSimpleName(suiteName))), null));
        bodyContent.add(suiteObjInit);
        for (String className : members) {
            TypeElement classElem = elements.getTypeElement(className);
            if (classElem == null || !this.containsSuiteMethod(classElem, elements, types, testType)) continue;
            MethodInvocationTree suiteMethodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect(maker.QualIdent((Element)classElem), (CharSequence)"suite"), Collections.emptyList());
            MethodInvocationTree methodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)maker.Identifier((CharSequence)"suite"), (CharSequence)"addTest"), Collections.singletonList(suiteMethodCall));
            bodyContent.add(maker.ExpressionStatement((ExpressionTree)methodCall));
        }
        bodyContent.add(maker.Return((ExpressionTree)maker.Identifier((CharSequence)"suite")));
        return maker.Method(maker.Modifiers(JUnit3TestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC)), (CharSequence)"suite", (Tree)maker.QualIdent((Element)testTypeElem), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), maker.Block(bodyContent, false), null);
    }

    private boolean containsSuiteMethod(TypeElement typeElement, Elements elements, Types types, TypeMirror testType) {
        List<ExecutableElement> allMethods = ElementFilter.methodsIn(elements.getAllMembers(typeElement));
        for (ExecutableElement method : allMethods) {
            if (!method.getSimpleName().contentEquals("suite") || !method.getParameters().isEmpty()) continue;
            return method.getModifiers().contains((Object)Modifier.STATIC) && types.isSameType(method.getReturnType(), testType);
        }
        return false;
    }

    private boolean generateTestClassSuiteMethod(TreePath tstClassTreePath, List<Tree> tstMembers, ClassMap clsMap, WorkingCopy workingCopy) {
        if (!this.setup.isGenerateSuiteClasses() || clsMap.containsNoArgMethod("suite")) {
            return false;
        }
        TreeMaker maker = workingCopy.getTreeMaker();
        Elements elements = workingCopy.getElements();
        Trees trees = workingCopy.getTrees();
        Element tstClassElem = trees.getElement(tstClassTreePath);
        assert (tstClassElem != null);
        ArrayList<StatementTree> bodyContent = new ArrayList<StatementTree>(4);
        VariableTree suiteVar = maker.Variable(maker.Modifiers(JUnit3TestGenerator.noModifiers()), (CharSequence)"suite", (Tree)this.getClassIdentifierTree(TEST_SUITE, workingCopy), (ExpressionTree)maker.NewClass(null, Collections.emptyList(), this.getClassIdentifierTree(TEST_SUITE, workingCopy), Collections.singletonList(maker.MemberSelect(maker.QualIdent(tstClassElem), (CharSequence)"class")), null));
        bodyContent.add(suiteVar);
        List<TypeElement> nestedClassElems = ElementFilter.typesIn(tstClassElem.getEnclosedElements());
        if (!nestedClassElems.isEmpty()) {
            for (TypeElement nestedClassElem : nestedClassElems) {
                if (!JUnitTestUtil.isClassTest((CompilationInfo)workingCopy, nestedClassElem)) continue;
                MethodInvocationTree arg = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect(maker.QualIdent((Element)nestedClassElem), (CharSequence)"suite"), Collections.emptyList());
                MethodInvocationTree methodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)maker.Identifier((CharSequence)"suite"), (CharSequence)"addTest"), Collections.singletonList(arg));
                bodyContent.add(maker.ExpressionStatement((ExpressionTree)methodCall));
            }
        }
        ReturnTree returnStmt = maker.Return((ExpressionTree)maker.Identifier((CharSequence)"suite"));
        bodyContent.add(returnStmt);
        MethodTree suiteMethod = maker.Method(maker.Modifiers(JUnit3TestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC)), (CharSequence)"suite", (Tree)this.getClassIdentifierTree(TEST, workingCopy), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), maker.Block(bodyContent, false), null);
        int targetIndex = clsMap.containsMethods() ? clsMap.getFirstMethodIndex() : (clsMap.containsNestedClasses() ? clsMap.getFirstNestedClassIndex() : clsMap.size());
        if (targetIndex == clsMap.size()) {
            tstMembers.add(suiteMethod);
        } else {
            tstMembers.add(targetIndex, suiteMethod);
        }
        clsMap.addNoArgMethod("suite", targetIndex);
        return true;
    }

    private TypeElement getTestTypeElem(Elements elements) {
        if (this.testTypeElem == null) {
            this.testTypeElem = JUnit3TestGenerator.getElemForClassName(TEST, elements);
        }
        return this.testTypeElem;
    }
}

