/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class JREProbe {
    private static final String NB_PROP_PROFILE = "netbeans.java.profile";
    private static final String NB_PROP_EXTENSIONS = "netbeans.java.extensions";
    private static final String NB_PROP_VM = "netbeans.jvm.type";
    private static final String NB_PROP_DEBUG = "netbeans.jvm.debug";
    private static final String NB_PROP_TARGET = "netbeans.jvm.target";
    private static final String JAVA_HOME = "java.home";
    private static final String COMPACT_1 = "compact1";
    private static final String COMPACT_2 = "compact2";
    private static final String COMPACT_3 = "compact3";
    private static final String COMPACT_2_CLASS = "java.rmi.Remote";
    private static final String COMPACT_3_CLASS = "java.lang.instrument.Instrumentation";
    private static final String DEFAULT_CLASS = "java.awt.Toolkit";
    private static final String BOM_KEY_TARGET = "target";
    private static final String BOM_KEY_VM = "vm";
    private static final String BOM_KEY_EXTENSION = "extension";
    private static final String BOM_KEY_DEBUG = "debug";

    public static void main(String[] args) {
        String installDir;
        Properties p = new Properties();
        p.putAll((Map<?, ?>)System.getProperties());
        String profile = JREProbe.getProfile();
        if (profile != null) {
            p.setProperty(NB_PROP_PROFILE, profile);
        }
        if ((installDir = p.getProperty(JAVA_HOME)) != null) {
            p.putAll((Map<?, ?>)JREProbe.getBOMData(new File(installDir)));
        }
        File f = new File(args[0]);
        try {
            FileOutputStream fos = new FileOutputStream(f);
            p.store(fos, null);
            fos.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private static String getProfile() {
        String profile = COMPACT_1;
        try {
            Class.forName(COMPACT_2_CLASS);
        }
        catch (ClassNotFoundException e) {
            return profile;
        }
        profile = COMPACT_2;
        try {
            Class.forName(COMPACT_3_CLASS);
        }
        catch (ClassNotFoundException e) {
            return profile;
        }
        profile = COMPACT_3;
        try {
            Class.forName(DEFAULT_CLASS);
        }
        catch (ClassNotFoundException e) {
            return profile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getBOMData(File installDir) {
        HashMap<String, String> props = new HashMap<String, String>();
        File bomFile = new File(installDir, "bom");
        if (bomFile.canRead()) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bomFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    StringTokenizer tk;
                    if ((line = line.trim()).startsWith("#") || (tk = new StringTokenizer(line, "=")).countTokens() != 2) continue;
                    String key = tk.nextToken().trim();
                    String value = tk.nextToken().trim();
                    if (BOM_KEY_TARGET.equals(key)) {
                        props.put(NB_PROP_TARGET, value);
                        continue;
                    }
                    if (BOM_KEY_VM.equals(key)) {
                        props.put(NB_PROP_VM, value);
                        continue;
                    }
                    if (BOM_KEY_EXTENSION.equals(key)) {
                        props.put(NB_PROP_EXTENSIONS, JREProbe.parseExtensions(value));
                        continue;
                    }
                    if (!BOM_KEY_DEBUG.equals(key)) continue;
                    props.put(NB_PROP_DEBUG, value);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props;
    }

    private static String parseExtensions(String value) {
        int start = 0;
        int end = value.length();
        if (value.charAt(start) == '[') {
            ++start;
        }
        if (value.charAt(end - 1) == ']') {
            --end;
        }
        return value.substring(start, end);
    }
}

