/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.modules.glassfish.tooling.admin.CommandException;
import org.netbeans.modules.glassfish.tooling.admin.ProcessIOContent;
import org.netbeans.modules.glassfish.tooling.admin.ProcessIOResult;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.CyclicStringBuffer;
import org.netbeans.modules.glassfish.tooling.utils.LinkedList;
import org.netbeans.modules.glassfish.tooling.utils.OsUtils;

public class ProcessIOParser {
    private static final Logger LOGGER = new Logger(ProcessIOParser.class);
    private static final short BUFF_SIZE = 128;
    private final Writer stdIn;
    private final Reader stdOut;
    private final Parser outParser;
    private final char[] outBuff;
    private short outLen;
    private boolean verifydone;

    public ProcessIOParser(Writer stdIn, Reader stdOut, ProcessIOContent ioContent) {
        this.stdIn = stdIn;
        this.stdOut = stdOut;
        this.outParser = new Parser(ioContent);
        this.outBuff = new char[128];
        this.outLen = 0;
        this.verifydone = false;
    }

    public ProcessIOResult verify() throws IOException {
        while (this.outLen >= 0) {
            this.outLen = (short)this.stdOut.read(this.outBuff);
            this.outParser.parse(this.outBuff, this.outLen);
        }
        this.outParser.finish();
        this.verifydone = true;
        return this.outParser.result();
    }

    public String getOutput() {
        String METHOD = "getOutput";
        if (!this.verifydone) {
            throw new CommandException(LOGGER.excMsg("getOutput", "illegalState"));
        }
        return this.outParser.getOutputString();
    }

    protected static class Parser {
        private final ProcessIOContent content;
        private ProcessIOContent.Token token;
        private ProcessIOResult result;
        private int promptLen;
        private final StringBuilder line;
        CyclicStringBuffer promptBuff;
        private State state;
        private final LinkedList<String> output;

        protected Parser(ProcessIOContent content) {
            this.content = content;
            this.line = new StringBuilder(128);
            this.state = State.START;
            this.token = this.content.firstToken();
            this.result = ProcessIOResult.UNKNOWN;
            String prompt = content.getCurrentPrompt();
            this.promptLen = prompt != null ? prompt.length() : 0;
            this.promptBuff = new CyclicStringBuffer(this.promptLen);
            this.output = new LinkedList();
        }

        protected void parse(char[] buff, short len) {
            for (int pos = 0; pos < len; ++pos) {
                this.state = this.action(buff[pos]);
            }
        }

        protected void finish() {
            this.endOfLine('\u0000');
        }

        protected ProcessIOResult result() {
            return this.result;
        }

        protected State action(char c) {
            Input cl = Input.value(c, this.content.getCurrentPrompt(), this.promptBuff);
            block0 : switch (this.state) {
                case START: {
                    switch (cl) {
                        case STRING: {
                            this.firstChar(c);
                            break;
                        }
                        case PROMPT: {
                            this.firstChar(c);
                        }
                        case LF: {
                            this.endOfLine(c);
                        }
                    }
                    break;
                }
                case LINE: {
                    switch (cl) {
                        case STRING: {
                            this.nextChar(c);
                            break;
                        }
                        case PROMPT: {
                            this.nextChar(c);
                        }
                        case LF: {
                            this.endOfLine(c);
                        }
                    }
                    break;
                }
                case CR: {
                    switch (cl) {
                        case STRING: {
                            this.nextCharWithCR(c);
                            break block0;
                        }
                        case PROMPT: {
                            this.nextCharWithCR(c);
                        }
                        case LF: {
                            this.endOfLine(c);
                        }
                    }
                }
            }
            return State.next(this.state, cl);
        }

        protected void firstChar(char c) {
            this.line.setLength(0);
            this.line.append(c);
        }

        protected void nextChar(char c) {
            this.line.append(c);
        }

        protected void nextCharWithCR(char c) {
            this.line.append('\r');
            this.line.append(c);
        }

        protected void endOfLine(char c) {
            if (this.line.length() > 0) {
                this.output.addLast(this.line.toString());
            }
            if (this.token != null) {
                ProcessIOResult matchResult = ProcessIOResult.UNKNOWN;
                for (int i = 0; i < this.line.length(); ++i) {
                    matchResult = this.token.match(this.line, i);
                    if (matchResult == ProcessIOResult.UNKNOWN) continue;
                    this.token = this.content.nextToken();
                    String prompt = this.content.getCurrentPrompt();
                    this.promptLen = prompt != null ? prompt.length() : 0;
                    this.promptBuff.resize(this.promptLen);
                    break;
                }
                switch (matchResult) {
                    case SUCCESS: {
                        if (this.result != ProcessIOResult.UNKNOWN) break;
                        this.result = matchResult;
                        break;
                    }
                    case ERROR: {
                        if (this.result == ProcessIOResult.ERROR) break;
                        this.result = matchResult;
                    }
                }
            }
            this.line.setLength(0);
        }

        protected String getOutputString() {
            int len = 0;
            boolean isElement = this.output.first();
            while (isElement) {
                len += this.output.getCurrent().length();
                isElement = this.output.next();
                if (!isElement) continue;
                len += OsUtils.LINES_SEPARATOR.length();
            }
            StringBuilder sb = new StringBuilder(len);
            isElement = this.output.first();
            while (isElement) {
                sb.append(this.output.getCurrent());
                isElement = this.output.next();
                if (!isElement) continue;
                sb.append(OsUtils.LINES_SEPARATOR);
            }
            return sb.toString();
        }

        protected static enum State {
            START,
            LINE,
            CR,
            ERROR;

            protected static final int length;
            protected static final State[][] transition;

            protected static State next(State s, Input i) {
                return transition[s.ordinal()][i.ordinal()];
            }

            static {
                length = State.values().length;
                transition = new State[][]{{LINE, START, CR, START}, {LINE, START, CR, START}, {LINE, START, CR, START}, {ERROR, ERROR, ERROR, ERROR}};
            }
        }

        protected static enum Input {
            STRING,
            PROMPT,
            CR,
            LF;

            protected static final int length;

            protected static Input value(char c, String prompt, CyclicStringBuffer promptBuff) {
                if (prompt != null && promptBuff.equals(prompt)) {
                    return PROMPT;
                }
                switch (c) {
                    case '\r': {
                        return CR;
                    }
                    case '\n': {
                        return LF;
                    }
                }
                return STRING;
            }

            static {
                length = Input.values().length;
            }
        }
    }
}

