/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Items;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.jvm.PoolWriter;
import com.sun.tools.javac.jvm.StringConcat;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.FilteredMemberList;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.ElementKind;

public class Gen
extends JCTree.Visitor {
    protected static final Context.Key<Gen> genKey = new Context.Key();
    private final Log log;
    private final Symtab syms;
    private final Check chk;
    private final Resolve rs;
    private final TreeMaker make;
    private final Names names;
    private final Target target;
    private final String accessDollar;
    private final Types types;
    private final Lower lower;
    private final Annotate annotate;
    private final StringConcat concat;
    private final Code.StackMapFormat stackMap;
    private final Type methodType;
    final PoolWriter poolWriter;
    private final boolean lineDebugInfo;
    private final boolean varDebugInfo;
    private final boolean genCrt;
    private final boolean debugCode;
    private boolean disableVirtualizedPrivateInvoke;
    private Code code;
    private Items items;
    private Env<AttrContext> attrEnv;
    private JCTree.JCCompilationUnit toplevel;
    private int nerrs = 0;
    EndPosTable endPosTable;
    boolean inCondSwitchExpression;
    Code.Chain switchExpressionTrueChain;
    Code.Chain switchExpressionFalseChain;
    List<Items.LocalItem> stackBeforeSwitchExpression;
    Items.LocalItem switchResult;
    PatternMatchingCatchConfiguration patternMatchingCatchConfiguration = new PatternMatchingCatchConfiguration(Collections.unmodifiableSet(new HashSet<JCTree.JCMethodInvocation>(Arrays.asList(new JCTree.JCMethodInvocation[0]))), null, null, null);
    Map<Type, Symbol> qualifiedSymbolCache;
    Env<GenContext> env;
    Type pt;
    Items.Item result;
    private ClassReferenceVisitor classReferenceVisitor = new ClassReferenceVisitor();

    public static Gen instance(Context context) {
        Gen instance = context.get(genKey);
        if (instance == null) {
            instance = new Gen(context);
        }
        return instance;
    }

    protected Gen(Context context) {
        context.put(genKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.chk = Check.instance(context);
        this.rs = Resolve.instance(context);
        this.make = TreeMaker.instance(context);
        this.target = Target.instance(context);
        this.types = Types.instance(context);
        this.concat = StringConcat.instance(context);
        this.methodType = new Type.MethodType(null, null, null, this.syms.methodClass);
        this.accessDollar = "access" + this.target.syntheticNameChar();
        this.lower = Lower.instance(context);
        Options options = Options.instance(context);
        this.lineDebugInfo = options.isUnset(Option.G_CUSTOM) || options.isSet(Option.G_CUSTOM, "lines");
        this.varDebugInfo = options.isUnset(Option.G_CUSTOM) ? options.isSet(Option.G) : options.isSet(Option.G_CUSTOM, "vars");
        this.genCrt = options.isSet(Option.XJCOV);
        this.debugCode = options.isSet("debug.code");
        this.disableVirtualizedPrivateInvoke = options.isSet("disableVirtualizedPrivateInvoke");
        this.poolWriter = new PoolWriter(this.types, this.names);
        this.stackMap = Code.StackMapFormat.JSR202;
        this.annotate = Annotate.instance(context);
        this.qualifiedSymbolCache = new HashMap<Type, Symbol>();
    }

    void loadIntConst(int n) {
        this.items.makeImmediateItem(this.syms.intType, n).load();
    }

    public static int zero(int tc) {
        switch (tc) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 14;
            }
        }
        throw new AssertionError((Object)"zero");
    }

    public static int one(int tc) {
        return Gen.zero(tc) + 1;
    }

    void emitMinusOne(int tc) {
        if (tc == 1) {
            this.items.makeImmediateItem(this.syms.longType, -1L).load();
        } else {
            this.code.emitop0(2);
        }
    }

    Symbol binaryQualifier(Symbol sym, Type site) {
        if (site.hasTag(TypeTag.ARRAY)) {
            if (sym == this.syms.lengthVar || sym.owner != this.syms.arrayClass) {
                return sym;
            }
            Symbol qualifier = this.qualifiedSymbolCache.get(site);
            if (qualifier == null) {
                qualifier = new Symbol.ClassSymbol(1L, site.tsym.name, site, this.syms.noSymbol);
                this.qualifiedSymbolCache.put(site, qualifier);
            }
            return sym.clone(qualifier);
        }
        if (sym.owner == site.tsym || (sym.flags() & 0x1008L) == 4104L) {
            return sym;
        }
        if (sym.owner == this.syms.objectType.tsym) {
            return sym;
        }
        return sym.clone(site.tsym);
    }

    int makeRef(JCDiagnostic.DiagnosticPosition pos, Type type) {
        return this.poolWriter.putClass(this.checkDimension(pos, type));
    }

    private Type checkDimension(JCDiagnostic.DiagnosticPosition pos, Type t) {
        this.checkDimensionInternal(pos, t);
        return t;
    }

    private void checkDimensionInternal(JCDiagnostic.DiagnosticPosition pos, Type t) {
        switch (t.getTag()) {
            case METHOD: {
                this.checkDimension(pos, t.getReturnType());
                List<Type> args = t.getParameterTypes();
                while (args.nonEmpty()) {
                    this.checkDimension(pos, (Type)args.head);
                    args = args.tail;
                }
                break;
            }
            case ARRAY: {
                if (this.types.dimensions(t) <= 255) break;
                this.log.error(pos, CompilerProperties.Errors.LimitDimensions);
                ++this.nerrs;
                break;
            }
        }
    }

    Items.LocalItem makeTemp(Type type) {
        Symbol.VarSymbol v = new Symbol.VarSymbol(4096L, this.names.empty, type, this.env.enclMethod.sym);
        this.code.newLocal(v);
        return this.items.makeLocalItem(v);
    }

    void callMethod(JCDiagnostic.DiagnosticPosition pos, Type site, Name name, List<Type> argtypes, boolean isStatic) {
        Symbol.MethodSymbol msym = this.rs.resolveInternalMethod(pos, this.attrEnv, site, name, argtypes, null);
        if (isStatic) {
            this.items.makeStaticItem(msym).invoke();
        } else {
            this.items.makeMemberItem(msym, name == this.names.init).invoke();
        }
    }

    private boolean isAccessSuper(JCTree.JCMethodDecl enclMethod) {
        return (enclMethod.mods.flags & 0x1000L) != 0L && this.isOddAccessName(enclMethod.name);
    }

    private boolean isOddAccessName(Name name) {
        String string = name.toString();
        return string.startsWith(this.accessDollar) && (string.charAt(string.length() - 1) & '\u0001') != 0;
    }

    void genFinalizer(Env<GenContext> env) {
        if (this.code.isAlive() && ((GenContext)env.info).finalize != null) {
            ((GenContext)env.info).finalize.gen();
        }
    }

    Env<GenContext> unwind(JCTree target, Env<GenContext> env) {
        Env<GenContext> env1 = env;
        while (true) {
            this.genFinalizer(env1);
            if (env1.tree == target) break;
            env1 = env1.next;
        }
        return env1;
    }

    void endFinalizerGap(Env<GenContext> env) {
        if (((GenContext)env.info).gaps != null && ((GenContext)env.info).gaps.length() % 2 == 1) {
            ((GenContext)env.info).gaps.append(this.code.curCP());
        }
    }

    void endFinalizerGaps(Env<GenContext> from, Env<GenContext> to) {
        Env<GenContext> last = null;
        while (last != to) {
            this.endFinalizerGap(from);
            last = from;
            from = from.next;
        }
    }

    boolean hasFinally(JCTree target, Env<GenContext> env) {
        while (env.tree != target) {
            if (env.tree.hasTag(JCTree.Tag.TRY) && ((GenContext)env.info).finalize.hasFinalizer()) {
                return true;
            }
            env = env.next;
        }
        return false;
    }

    List<JCTree> normalizeDefs(List<JCTree> defs, Symbol.ClassSymbol c) {
        Object block;
        ListBuffer<Object> initCode = new ListBuffer<Object>();
        ListBuffer<Attribute.TypeCompound> initTAs = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Object> clinitCode = new ListBuffer<Object>();
        ListBuffer<Attribute.TypeCompound> clinitTAs = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<JCTree> methodDefs = new ListBuffer<JCTree>();
        List<JCTree> l = defs;
        while (l.nonEmpty()) {
            JCTree def = (JCTree)l.head;
            switch (def.getTag()) {
                case BLOCK: {
                    block = (JCTree.JCBlock)def;
                    if ((((JCTree.JCBlock)block).flags & 8L) != 0L) {
                        clinitCode.append(block);
                        break;
                    }
                    if ((((JCTree.JCBlock)block).flags & 0x1000L) != 0L) break;
                    initCode.append(block);
                    break;
                }
                case METHODDEF: {
                    methodDefs.append(def);
                    break;
                }
                case VARDEF: {
                    JCTree.JCStatement init;
                    JCTree.JCVariableDecl vdef = (JCTree.JCVariableDecl)def;
                    Symbol.VarSymbol sym = vdef.sym;
                    this.checkDimension(vdef.pos(), sym.type);
                    if (vdef.init == null) break;
                    if ((sym.flags() & 8L) == 0L) {
                        init = this.make.at(vdef.pos()).Assignment(sym, vdef.init);
                        initCode.append(init);
                        this.endPosTable.replaceTree(vdef, init);
                        initTAs.addAll((Collection<Attribute.TypeCompound>)this.getAndRemoveNonFieldTAs(sym));
                        break;
                    }
                    if (sym.getConstValue() == null) {
                        init = this.make.at(vdef.pos).Assignment(sym, vdef.init);
                        clinitCode.append(init);
                        this.endPosTable.replaceTree(vdef, init);
                        clinitTAs.addAll((Collection<Attribute.TypeCompound>)this.getAndRemoveNonFieldTAs(sym));
                        break;
                    }
                    this.checkStringConstant(vdef.init.pos(), sym.getConstValue());
                    vdef.init.accept(this.classReferenceVisitor);
                    break;
                }
                default: {
                    Assert.error();
                }
            }
            l = l.tail;
        }
        if (initCode.length() != 0) {
            List<JCTree.JCStatement> inits = initCode.toList();
            initTAs.addAll((Collection<Attribute.TypeCompound>)c.getInitTypeAttributes());
            List<Attribute.TypeCompound> initTAlist = initTAs.toList();
            for (JCTree t : methodDefs) {
                this.normalizeMethod((JCTree.JCMethodDecl)t, inits, initTAlist);
            }
        }
        if (clinitCode.length() != 0) {
            Symbol.MethodSymbol clinit = new Symbol.MethodSymbol(8L | c.flags() & 0x800L, this.names.clinit, new Type.MethodType(List.nil(), this.syms.voidType, List.nil(), this.syms.methodClass), c);
            c.members().enter(clinit);
            List<JCTree.JCStatement> clinitStats = clinitCode.toList();
            block = this.make.at(((JCTree.JCStatement)clinitStats.head).pos()).Block(0L, clinitStats);
            ((JCTree.JCBlock)block).endpos = TreeInfo.endPos(clinitStats.last());
            methodDefs.append(this.make.MethodDef(clinit, (JCTree.JCBlock)block));
            if (!clinitTAs.isEmpty()) {
                clinit.appendUniqueTypeAttributes(clinitTAs.toList());
            }
            if (!c.getClassInitTypeAttributes().isEmpty()) {
                clinit.appendUniqueTypeAttributes(c.getClassInitTypeAttributes());
            }
        }
        return methodDefs.toList();
    }

    private List<Attribute.TypeCompound> getAndRemoveNonFieldTAs(Symbol.VarSymbol sym) {
        List<Attribute.TypeCompound> tas = sym.getRawTypeAttributes();
        ListBuffer<Attribute.TypeCompound> fieldTAs = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> nonfieldTAs = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound ta : tas) {
            Assert.check(ta.getPosition().type != TargetType.UNKNOWN);
            if (ta.getPosition().type == TargetType.FIELD) {
                fieldTAs.add(ta);
                continue;
            }
            nonfieldTAs.add(ta);
        }
        sym.setTypeAttributes(fieldTAs.toList());
        return nonfieldTAs.toList();
    }

    private void checkStringConstant(JCDiagnostic.DiagnosticPosition pos, Object constValue) {
        String str;
        if (this.nerrs != 0 || constValue == null || !(constValue instanceof String) || (str = (String)constValue).length() < 65535) {
            return;
        }
        this.log.error(pos, CompilerProperties.Errors.LimitString);
        ++this.nerrs;
    }

    void normalizeMethod(JCTree.JCMethodDecl md, List<JCTree.JCStatement> initCode, List<Attribute.TypeCompound> initTAs) {
        if (TreeInfo.isConstructor(md) && TreeInfo.hasConstructorCall((JCTree.JCMethodDecl)md, (Name)this.names._super)) {
            TreeInfo.mapSuperCalls((JCTree.JCBlock)md.body, supercall -> this.make.Block(0L, initCode.prepend((JCTree.JCStatement)supercall)));
            if (md.body.endpos == -1) {
                md.body.endpos = TreeInfo.endPos(md.body.stats.last());
            }
            md.sym.appendUniqueTypeAttributes(initTAs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genDef(JCTree tree, Env<GenContext> env) {
        Env<GenContext> prevEnv = this.env;
        try {
            this.env = env;
            tree.accept(this);
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
        }
        finally {
            this.env = prevEnv;
        }
    }

    public void genStat(JCTree tree, Env<GenContext> env, int crtFlags) {
        if (!this.genCrt) {
            this.genStat(tree, env);
            return;
        }
        int startpc = this.code.curCP();
        this.genStat(tree, env);
        if (tree.hasTag(JCTree.Tag.BLOCK)) {
            crtFlags |= 2;
        }
        this.code.crt.put(tree, crtFlags, startpc, this.code.curCP());
    }

    public void genStat(JCTree tree, Env<GenContext> env) {
        if (this.code.isAlive()) {
            this.code.statBegin(tree.pos);
            this.genDef(tree, env);
        } else if (((GenContext)env.info).isSwitch && tree.hasTag(JCTree.Tag.VARDEF)) {
            this.code.newLocal(((JCTree.JCVariableDecl)tree).sym);
        }
    }

    public void genStats(List<JCTree.JCStatement> trees, Env<GenContext> env, int crtFlags) {
        if (!this.genCrt) {
            this.genStats(trees, env);
            return;
        }
        if (trees.length() == 1) {
            this.genStat((JCTree)trees.head, env, crtFlags | 1);
        } else {
            int startpc = this.code.curCP();
            this.genStats(trees, env);
            this.code.crt.put(trees, crtFlags, startpc, this.code.curCP());
        }
    }

    public void genStats(List<? extends JCTree> trees, Env<GenContext> env) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.genStat((JCTree)l.head, env, 1);
            l = l.tail;
        }
    }

    public Items.CondItem genCond(JCTree tree, int crtFlags) {
        if (!this.genCrt) {
            return this.genCond(tree, false);
        }
        int startpc = this.code.curCP();
        Items.CondItem item = this.genCond(tree, (crtFlags & 8) != 0);
        this.code.crt.put(tree, crtFlags, startpc, this.code.curCP());
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Items.CondItem genCond(JCTree _tree, boolean markBranches) {
        JCTree inner_tree = TreeInfo.skipParens(_tree);
        if (inner_tree.hasTag(JCTree.Tag.CONDEXPR)) {
            JCTree.JCConditional tree = (JCTree.JCConditional)inner_tree;
            Items.CondItem cond = this.genCond((JCTree)tree.cond, 8);
            if (cond.isTrue()) {
                this.code.resolve(cond.trueJumps);
                Items.CondItem result = this.genCond((JCTree)tree.truepart, 16);
                if (markBranches) {
                    result.tree = tree.truepart;
                }
                return result;
            }
            if (cond.isFalse()) {
                this.code.resolve(cond.falseJumps);
                Items.CondItem result = this.genCond((JCTree)tree.falsepart, 16);
                if (markBranches) {
                    result.tree = tree.falsepart;
                }
                return result;
            }
            Code.Chain secondJumps = cond.jumpFalse();
            this.code.resolve(cond.trueJumps);
            Items.CondItem first = this.genCond((JCTree)tree.truepart, 16);
            if (markBranches) {
                first.tree = tree.truepart;
            }
            Code.Chain falseJumps = first.jumpFalse();
            this.code.resolve(first.trueJumps);
            Code.Chain trueJumps = this.code.branch(167);
            this.code.resolve(secondJumps);
            Items.CondItem second = this.genCond((JCTree)tree.falsepart, 16);
            Items.CondItem result = this.items.makeCondItem(second.opcode, Code.mergeChains(trueJumps, second.trueJumps), Code.mergeChains(falseJumps, second.falseJumps));
            if (markBranches) {
                result.tree = tree.falsepart;
            }
            return result;
        }
        if (inner_tree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
            this.code.resolvePending();
            boolean prevInCondSwitchExpression = this.inCondSwitchExpression;
            Code.Chain prevSwitchExpressionTrueChain = this.switchExpressionTrueChain;
            Code.Chain prevSwitchExpressionFalseChain = this.switchExpressionFalseChain;
            try {
                this.inCondSwitchExpression = true;
                this.switchExpressionTrueChain = null;
                this.switchExpressionFalseChain = null;
                try {
                    this.doHandleSwitchExpression((JCTree.JCSwitchExpression)inner_tree);
                }
                catch (Symbol.CompletionFailure ex) {
                    this.chk.completionError(_tree.pos(), ex);
                    this.code.state.stacksize = 1;
                }
                Items.CondItem result = this.items.makeCondItem(167, this.switchExpressionTrueChain, this.switchExpressionFalseChain);
                if (markBranches) {
                    result.tree = _tree;
                }
                Items.CondItem condItem = result;
                return condItem;
            }
            finally {
                this.inCondSwitchExpression = prevInCondSwitchExpression;
                this.switchExpressionTrueChain = prevSwitchExpressionTrueChain;
                this.switchExpressionFalseChain = prevSwitchExpressionFalseChain;
            }
        }
        if (inner_tree.hasTag(JCTree.Tag.LETEXPR) && ((JCTree.LetExpr)inner_tree).needsCond) {
            this.code.resolvePending();
            JCTree.LetExpr tree = (JCTree.LetExpr)inner_tree;
            int limit = this.code.nextreg;
            int prevLetExprStart = this.code.setLetExprStackPos(this.code.state.stacksize);
            try {
                this.genStats(tree.defs, this.env);
            }
            finally {
                this.code.setLetExprStackPos(prevLetExprStart);
            }
            Items.CondItem result = this.genCond((JCTree)tree.expr, markBranches);
            this.code.endScopes(limit);
            return result;
        }
        Items.CondItem result = this.genExpr(_tree, this.syms.booleanType).mkCond();
        if (markBranches) {
            result.tree = _tree;
        }
        return result;
    }

    public Code getCode() {
        return this.code;
    }

    public Items getItems() {
        return this.items;
    }

    public Env<AttrContext> getAttrEnv() {
        return this.attrEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Items.Item genExpr(JCTree tree, Type pt) {
        if (!this.code.isAlive()) {
            return this.items.makeStackItem(pt);
        }
        Type prevPt = this.pt;
        try {
            Object sym;
            if (tree.type.constValue() != null) {
                tree.accept(this.classReferenceVisitor);
                this.checkStringConstant(tree.pos(), tree.type.constValue());
                sym = TreeInfo.symbol(tree);
                this.result = sym != null && this.isConstantDynamic((Symbol)sym) ? this.items.makeDynamicItem((Symbol)sym) : this.items.makeImmediateItem(tree.type, tree.type.constValue());
            } else {
                this.pt = pt;
                tree.accept(this);
            }
            sym = this.result.coerce(pt);
            return sym;
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
            this.code.state.stacksize = 1;
            Items.Item item = this.items.makeStackItem(pt);
            return item;
        }
        finally {
            this.pt = prevPt;
        }
    }

    public boolean isConstantDynamic(Symbol sym) {
        Symbol.DynamicVarSymbol dynamicVarSymbol;
        return sym.kind == Kinds.Kind.VAR && sym instanceof Symbol.DynamicVarSymbol && (dynamicVarSymbol = (Symbol.DynamicVarSymbol)sym).isDynamic();
    }

    public void genArgs(List<JCTree.JCExpression> trees, List<Type> pts) {
        List<JCTree.JCExpression> l = trees;
        while (l.nonEmpty()) {
            this.genExpr((JCTree)l.head, (Type)pts.head).load();
            pts = pts.tail;
            l = l.tail;
        }
        Assert.check(pts.isEmpty());
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Env<GenContext> localEnv = this.env.dup(tree);
        localEnv.enclMethod = tree;
        this.pt = tree.sym.erasure(this.types).getReturnType();
        this.checkDimension(tree.pos(), tree.sym.erasure(this.types));
        this.genMethod(tree, localEnv, false);
    }

    void genMethod(JCTree.JCMethodDecl tree, Env<GenContext> env, boolean fatcode) {
        Symbol.MethodSymbol meth = tree.sym;
        int extras = 0;
        if (meth.isConstructor()) {
            ++extras;
            if (meth.enclClass().isInner() && !meth.enclClass().isStatic()) {
                ++extras;
            }
        } else if ((tree.mods.flags & 8L) == 0L) {
            ++extras;
        }
        if (Code.width(this.types.erasure(env.enclMethod.sym.type).getParameterTypes()) + extras > 255) {
            this.log.error(tree.pos(), CompilerProperties.Errors.LimitParameters);
            ++this.nerrs;
        } else if (tree.body != null) {
            int startpcCrt = this.initCode(tree, env, fatcode);
            try {
                this.genStat(tree.body, env);
            }
            catch (CodeSizeOverflow e) {
                startpcCrt = this.initCode(tree, env, fatcode);
                this.genStat(tree.body, env);
            }
            if (this.code.state.stacksize != 0) {
                this.log.error(tree.body.pos(), CompilerProperties.Errors.StackSimError(tree.sym));
                throw new AssertionError();
            }
            if (this.code.isAlive()) {
                this.code.statBegin(TreeInfo.endPos(tree.body));
                if (env.enclMethod == null || env.enclMethod.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                    this.code.emitop0(177);
                } else {
                    int startpc = this.code.entryPoint();
                    Items.CondItem c = this.items.makeCondItem(167);
                    this.code.resolve(c.jumpTrue(), startpc);
                }
            }
            if (this.genCrt) {
                this.code.crt.put(tree.body, 2, startpcCrt, this.code.curCP());
            }
            this.code.endScopes(0);
            if (this.code.checkLimits(tree.pos(), this.log)) {
                ++this.nerrs;
                return;
            }
            if (!fatcode && this.code.fatcode) {
                this.genMethod(tree, env, true);
            }
            if (this.stackMap == Code.StackMapFormat.JSR202) {
                this.code.lastFrame = null;
                this.code.frameBeforeLast = null;
            }
            this.code.compressCatchTable();
            this.code.fillExceptionParameterPositions();
        }
    }

    private int initCode(JCTree.JCMethodDecl tree, Env<GenContext> env, boolean fatcode) {
        Symbol.MethodSymbol meth = tree.sym;
        meth.code = this.code = new Code(meth, fatcode, this.lineDebugInfo ? this.toplevel.lineMap : null, this.varDebugInfo, this.stackMap, this.debugCode, this.genCrt ? new CRTable(tree, env.toplevel.endPositions) : null, this.syms, this.types, this.poolWriter);
        this.items = new Items(this.poolWriter, this.code, this.syms, this.types);
        if (this.code.debugCode) {
            System.err.println(String.valueOf(meth) + " for body " + String.valueOf(tree));
        }
        if ((tree.mods.flags & 8L) == 0L) {
            Type selfType = meth.owner.type;
            if (meth.isConstructor() && selfType != this.syms.objectType) {
                selfType = UninitializedType.uninitializedThis(selfType);
            }
            this.code.setDefined(this.code.newLocal(new Symbol.VarSymbol(16L, this.names._this, selfType, meth.owner)));
        }
        List<JCTree.JCVariableDecl> l = tree.params;
        while (l.nonEmpty()) {
            this.checkDimension(((JCTree.JCVariableDecl)l.head).pos(), ((JCTree.JCVariableDecl)l.head).sym.type);
            this.code.setDefined(this.code.newLocal(((JCTree.JCVariableDecl)l.head).sym));
            l = l.tail;
        }
        int startpcCrt = this.genCrt ? this.code.curCP() : 0;
        this.code.entryPoint();
        this.code.pendingStackMap = false;
        return startpcCrt;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        Symbol.VarSymbol v = tree.sym;
        if (tree.init != null) {
            this.checkStringConstant(tree.init.pos(), v.getConstValue());
            if (v.getConstValue() == null || this.varDebugInfo) {
                Assert.check(this.code.isStatementStart());
                this.code.newLocal(v);
                this.genExpr(tree.init, v.erasure(this.types)).load();
                this.items.makeLocalItem(v).store();
                Assert.check(this.code.isStatementStart());
            }
        } else {
            this.code.newLocal(v);
        }
        this.checkDimension(tree.pos(), v.type);
    }

    @Override
    public void visitSkip(JCTree.JCSkip tree) {
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        if (tree.patternMatchingCatch != null) {
            this.visitBlockWithPatterns(tree);
        } else {
            this.internalVisitBlock(tree);
        }
    }

    private void visitBlockWithPatterns(JCTree.JCBlock tree) {
        PatternMatchingCatchConfiguration prevConfiguration = this.patternMatchingCatchConfiguration;
        try {
            this.patternMatchingCatchConfiguration = new PatternMatchingCatchConfiguration(tree.patternMatchingCatch.calls2Handle(), new ListBuffer<int[]>(), tree.patternMatchingCatch.handler(), this.code.state.dup());
            this.internalVisitBlock(tree);
        }
        finally {
            this.generatePatternMatchingCatch(this.env);
            this.patternMatchingCatchConfiguration = prevConfiguration;
        }
    }

    private void generatePatternMatchingCatch(Env<GenContext> env) {
        if (this.patternMatchingCatchConfiguration.handler != null && !this.patternMatchingCatchConfiguration.ranges.isEmpty()) {
            Code.Chain skipCatch = this.code.branch(167);
            JCTree.JCCatch handler = this.patternMatchingCatchConfiguration.handler();
            this.code.entryPoint(this.patternMatchingCatchConfiguration.startState(), handler.param.sym.type);
            this.genPatternMatchingCatch(handler, env, this.patternMatchingCatchConfiguration.ranges.toList());
            this.code.resolve(skipCatch);
        }
    }

    private void internalVisitBlock(JCTree.JCBlock tree) {
        int limit = this.code.nextreg;
        Env<GenContext> localEnv = this.env.dup(tree, new GenContext());
        this.genStats(tree.stats, localEnv);
        if (!this.env.tree.hasTag(JCTree.Tag.METHODDEF)) {
            this.code.statBegin(tree.endpos);
            this.code.endScopes(limit);
            this.code.pendingStatPos = -1;
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        this.genLoop(tree, tree.body, tree.cond, List.nil(), false);
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.genLoop(tree, tree.body, tree.cond, List.nil(), true);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        int limit = this.code.nextreg;
        this.genStats(tree.init, this.env);
        this.genLoop(tree, tree.body, tree.cond, tree.step, true);
        this.code.endScopes(limit);
    }

    private void genLoop(JCTree.JCStatement loop, JCTree.JCStatement body, JCTree.JCExpression cond, List<JCTree.JCExpressionStatement> step, boolean testFirst) {
        Env<GenContext> loopEnv = this.env.dup(loop, new GenContext());
        int startpc = this.code.entryPoint();
        if (testFirst) {
            Items.CondItem c;
            if (cond != null) {
                this.code.statBegin(cond.pos);
                Assert.check(this.code.isStatementStart());
                c = this.genCond((JCTree)TreeInfo.skipParens(cond), 8);
            } else {
                c = this.items.makeCondItem(167);
            }
            Code.Chain loopDone = c.jumpFalse();
            this.code.resolve(c.trueJumps);
            Assert.check(this.code.isStatementStart());
            this.genStat(body, loopEnv, 17);
            this.code.resolve(((GenContext)loopEnv.info).cont);
            this.genStats(step, loopEnv);
            this.code.resolve(this.code.branch(167), startpc);
            this.code.resolve(loopDone);
        } else {
            this.genStat(body, loopEnv, 17);
            this.code.resolve(((GenContext)loopEnv.info).cont);
            this.genStats(step, loopEnv);
            if (this.code.isAlive()) {
                Items.CondItem c;
                if (cond != null) {
                    this.code.statBegin(cond.pos);
                    Assert.check(this.code.isStatementStart());
                    c = this.genCond((JCTree)TreeInfo.skipParens(cond), 8);
                } else {
                    c = this.items.makeCondItem(167);
                }
                this.code.resolve(c.jumpTrue(), startpc);
                Assert.check(this.code.isStatementStart());
                this.code.resolve(c.falseJumps);
            }
        }
        this.code.resolve(((GenContext)loopEnv.info).exit);
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        throw new AssertionError();
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        Env<GenContext> localEnv = this.env.dup(tree, new GenContext());
        this.genStat(tree.body, localEnv, 1);
        this.code.resolve(((GenContext)localEnv.info).exit);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.handleSwitch(tree, tree.selector, tree.cases, tree.patternSwitch);
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
        this.code.resolvePending();
        boolean prevInCondSwitchExpression = this.inCondSwitchExpression;
        try {
            this.inCondSwitchExpression = false;
            this.doHandleSwitchExpression(tree);
        }
        finally {
            this.inCondSwitchExpression = prevInCondSwitchExpression;
        }
        this.result = this.items.makeStackItem(this.pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleSwitchExpression(JCTree.JCSwitchExpression tree) {
        List<Items.LocalItem> prevStackBeforeSwitchExpression = this.stackBeforeSwitchExpression;
        Items.LocalItem prevSwitchResult = this.switchResult;
        int limit = this.code.nextreg;
        try {
            this.stackBeforeSwitchExpression = List.nil();
            this.switchResult = null;
            if (this.hasTry(tree)) {
                while (this.code.state.stacksize > 0) {
                    Type type = this.code.state.peek();
                    Name varName = this.names.fromString(this.target.syntheticNameChar() + "stack" + this.target.syntheticNameChar() + tree.pos + this.target.syntheticNameChar() + this.code.state.stacksize);
                    Symbol.VarSymbol var = new Symbol.VarSymbol(4096L, varName, type, this.env.enclMethod.sym);
                    Items items = this.items;
                    Objects.requireNonNull(items);
                    Items.LocalItem item = new Items.LocalItem(items, type, this.code.newLocal(var));
                    this.stackBeforeSwitchExpression = this.stackBeforeSwitchExpression.prepend(item);
                    item.store();
                }
                this.switchResult = this.makeTemp(tree.type);
            }
            int prevLetExprStart = this.code.setLetExprStackPos(this.code.state.stacksize);
            try {
                this.handleSwitch(tree, tree.selector, tree.cases, tree.patternSwitch);
            }
            finally {
                this.code.setLetExprStackPos(prevLetExprStart);
            }
        }
        finally {
            this.stackBeforeSwitchExpression = prevStackBeforeSwitchExpression;
            this.switchResult = prevSwitchResult;
            this.code.endScopes(limit);
        }
    }

    private boolean hasTry(JCTree.JCSwitchExpression tree) {
        class HasTryScanner
        extends TreeScanner {
            private boolean hasTry;

            HasTryScanner() {
            }

            @Override
            public void visitTry(JCTree.JCTry tree) {
                this.hasTry = true;
            }

            @Override
            public void visitSynchronized(JCTree.JCSynchronized tree) {
                this.hasTry = true;
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
            }
        }
        HasTryScanner hasTryScanner = new HasTryScanner();
        hasTryScanner.scan(tree);
        return hasTryScanner.hasTry;
    }

    private void handleSwitch(JCTree swtch, JCTree.JCExpression selector, List<JCTree.JCCase> cases, boolean patternSwitch) {
        int limit = this.code.nextreg;
        Assert.check(!selector.type.hasTag(TypeTag.CLASS));
        int switchStart = patternSwitch ? this.code.entryPoint() : -1;
        int startpcCrt = this.genCrt ? this.code.curCP() : 0;
        Assert.check(this.code.isStatementStart());
        Items.Item sel = this.genExpr(selector, this.syms.intType);
        if (cases.isEmpty()) {
            sel.load().drop();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(selector), 8, startpcCrt, this.code.curCP());
            }
        } else {
            int i;
            sel.load();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(selector), 8, startpcCrt, this.code.curCP());
            }
            Env<GenContext> switchEnv = this.env.dup(swtch, new GenContext());
            ((GenContext)switchEnv.info).isSwitch = true;
            int lo = Integer.MAX_VALUE;
            int hi = Integer.MIN_VALUE;
            int nlabels = 0;
            int[] labels = new int[cases.length()];
            int defaultIndex = -1;
            List<JCTree.JCCase> l = cases;
            for (int i2 = 0; i2 < labels.length; ++i2) {
                Object a = ((JCTree.JCCase)l.head).labels.head;
                if (a instanceof JCTree.JCConstantCaseLabel) {
                    int val;
                    JCTree.JCConstantCaseLabel constLabel = (JCTree.JCConstantCaseLabel)a;
                    Assert.check(((JCTree.JCCase)l.head).labels.size() == 1);
                    labels[i2] = val = ((Number)constLabel.expr.type.constValue()).intValue();
                    if (val < lo) {
                        lo = val;
                    }
                    if (hi < val) {
                        hi = val;
                    }
                    ++nlabels;
                } else {
                    Assert.check(defaultIndex == -1);
                    defaultIndex = i2;
                }
                l = l.tail;
            }
            long table_space_cost = 4L + ((long)hi - (long)lo + 1L);
            long table_time_cost = 3L;
            long lookup_space_cost = 3L + 2L * (long)nlabels;
            long lookup_time_cost = nlabels;
            int opcode = nlabels > 0 && table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost ? 170 : 171;
            int startpc = this.code.curCP();
            this.code.emitop0(opcode);
            this.code.align(4);
            int tableBase = this.code.curCP();
            int[] offsets = null;
            this.code.emit4(-1);
            if (opcode == 170) {
                this.code.emit4(lo);
                this.code.emit4(hi);
                for (long i3 = (long)lo; i3 <= (long)hi; ++i3) {
                    this.code.emit4(-1);
                }
            } else {
                this.code.emit4(nlabels);
                for (int i4 = 0; i4 < nlabels; ++i4) {
                    this.code.emit4(-1);
                    this.code.emit4(-1);
                }
                offsets = new int[labels.length];
            }
            Code.State stateSwitch = this.code.state.dup();
            this.code.markDead();
            l = cases;
            for (i = 0; i < labels.length; ++i) {
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                l = l.tail;
                int pc = this.code.entryPoint(stateSwitch);
                if (i != defaultIndex) {
                    if (opcode == 170) {
                        this.code.put4(tableBase + 4 * (labels[i] - lo + 3), pc - startpc);
                    } else {
                        offsets[i] = pc - startpc;
                    }
                } else {
                    this.code.put4(tableBase, pc - startpc);
                }
                this.genStats(c.stats, switchEnv, 16);
            }
            if (((GenContext)switchEnv.info).cont != null) {
                Assert.check(patternSwitch);
                this.code.resolve(((GenContext)switchEnv.info).cont, switchStart);
            }
            this.code.resolve(((GenContext)switchEnv.info).exit);
            if (this.code.get4(tableBase) == -1) {
                this.code.put4(tableBase, this.code.entryPoint(stateSwitch) - startpc);
            }
            if (opcode == 170) {
                int defaultOffset = this.code.get4(tableBase);
                for (long i5 = (long)lo; i5 <= (long)hi; ++i5) {
                    int t = (int)((long)tableBase + 4L * (i5 - (long)lo + 3L));
                    if (this.code.get4(t) != -1) continue;
                    this.code.put4(t, defaultOffset);
                }
            } else {
                if (defaultIndex >= 0) {
                    for (i = defaultIndex; i < labels.length - 1; ++i) {
                        labels[i] = labels[i + 1];
                        offsets[i] = offsets[i + 1];
                    }
                }
                if (nlabels > 0) {
                    Gen.qsort2(labels, offsets, 0, nlabels - 1);
                }
                for (i = 0; i < nlabels; ++i) {
                    int caseidx = tableBase + 8 * (i + 1);
                    this.code.put4(caseidx, labels[i]);
                    this.code.put4(caseidx + 4, offsets[i]);
                }
            }
            if (swtch instanceof JCTree.JCSwitchExpression) {
                this.code.statBegin(TreeInfo.endPos(swtch));
            }
        }
        this.code.endScopes(limit);
    }

    static void qsort2(int[] keys, int[] values, int lo, int hi) {
        int i = lo;
        int j = hi;
        int pivot = keys[(i + j) / 2];
        while (true) {
            if (keys[i] < pivot) {
                ++i;
                continue;
            }
            while (pivot < keys[j]) {
                --j;
            }
            if (i <= j) {
                int temp1 = keys[i];
                keys[i] = keys[j];
                keys[j] = temp1;
                int temp2 = values[i];
                values[i] = values[j];
                values[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            Gen.qsort2(keys, values, lo, j);
        }
        if (i < hi) {
            Gen.qsort2(keys, values, i, hi);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        int limit = this.code.nextreg;
        final Items.LocalItem lockVar = this.makeTemp(this.syms.objectType);
        Assert.check(this.code.isStatementStart());
        this.genExpr(tree.lock, tree.lock.type).load().duplicate();
        lockVar.store();
        this.code.emitop0(194);
        this.code.state.lock(lockVar.reg);
        final Env<GenContext> syncEnv = this.env.dup(tree, new GenContext());
        ((GenContext)syncEnv.info).finalize = new GenFinalizer(){

            @Override
            void gen() {
                this.genLast();
                Assert.check(((GenContext)syncEnv.info).gaps.length() % 2 == 0);
                ((GenContext)syncEnv.info).gaps.append(Gen.this.code.curCP());
            }

            @Override
            void genLast() {
                if (Gen.this.code.isAlive()) {
                    lockVar.load();
                    Gen.this.code.emitop0(195);
                    Gen.this.code.state.unlock(lockVar.reg);
                }
            }
        };
        ((GenContext)syncEnv.info).gaps = new ListBuffer();
        this.genTry(tree.body, List.nil(), syncEnv);
        this.code.endScopes(limit);
    }

    @Override
    public void visitTry(final JCTree.JCTry tree) {
        final Env<GenContext> tryEnv = this.env.dup(tree, new GenContext());
        final Env<GenContext> oldEnv = this.env;
        ((GenContext)tryEnv.info).finalize = new GenFinalizer(){

            @Override
            void gen() {
                Assert.check(((GenContext)tryEnv.info).gaps.length() % 2 == 0);
                ((GenContext)tryEnv.info).gaps.append(Gen.this.code.curCP());
                this.genLast();
            }

            @Override
            void genLast() {
                if (tree.finalizer != null) {
                    Gen.this.genStat(tree.finalizer, oldEnv, 2);
                }
            }

            @Override
            boolean hasFinalizer() {
                return tree.finalizer != null;
            }

            @Override
            void afterBody() {
                if (tree.finalizer != null && (tree.finalizer.flags & 0x20000L) != 0L) {
                    ((GenContext)tryEnv.info).finalize = null;
                }
            }
        };
        ((GenContext)tryEnv.info).gaps = new ListBuffer();
        this.genTry(tree.body, tree.catchers, tryEnv);
    }

    void genTry(JCTree body, List<JCTree.JCCatch> catchers, Env<GenContext> env) {
        boolean hasFinalizer;
        int limit = this.code.nextreg;
        int startpc = this.code.curCP();
        Code.State stateTry = this.code.state.dup();
        this.genStat(body, env, 2);
        int endpc = this.code.curCP();
        List<Integer> gaps = ((GenContext)env.info).gaps.toList();
        this.code.statBegin(TreeInfo.endPos(body));
        this.genFinalizer(env);
        this.code.statBegin(TreeInfo.endPos(env.tree));
        boolean actualTry = env.tree.hasTag(JCTree.Tag.TRY);
        Code.Chain exitChain = startpc == endpc && actualTry ? this.code.branch(168) : this.code.branch(167);
        this.endFinalizerGap(env);
        ((GenContext)env.info).finalize.afterBody();
        boolean bl = hasFinalizer = ((GenContext)env.info).finalize != null && ((GenContext)env.info).finalize.hasFinalizer();
        if (startpc != endpc) {
            List<JCTree.JCCatch> l = catchers;
            while (l.nonEmpty()) {
                this.code.entryPoint(stateTry, ((JCTree.JCCatch)l.head).param.sym.type);
                this.genCatch((JCTree.JCCatch)l.head, env, startpc, endpc, gaps);
                this.genFinalizer(env);
                if (hasFinalizer || l.tail.nonEmpty()) {
                    this.code.statBegin(TreeInfo.endPos(env.tree));
                    exitChain = Code.mergeChains(exitChain, this.code.branch(167));
                }
                this.endFinalizerGap(env);
                l = l.tail;
            }
        }
        if (hasFinalizer && (startpc != endpc || !actualTry)) {
            this.code.newRegSegment();
            int catchallpc = this.code.entryPoint(stateTry, this.syms.throwableType);
            int startseg = startpc;
            while (((GenContext)env.info).gaps.nonEmpty()) {
                int endseg = ((GenContext)env.info).gaps.next();
                this.registerCatch(body.pos(), startseg, endseg, catchallpc, 0);
                startseg = ((GenContext)env.info).gaps.next();
            }
            this.code.statBegin(TreeInfo.finalizerPos(env.tree, TreeInfo.PosKind.FIRST_STAT_POS));
            this.code.markStatBegin();
            Items.LocalItem excVar = this.makeTemp(this.syms.throwableType);
            ((Items.Item)excVar).store();
            this.genFinalizer(env);
            this.code.resolvePending();
            this.code.statBegin(TreeInfo.finalizerPos(env.tree, TreeInfo.PosKind.END_POS));
            this.code.markStatBegin();
            ((Items.Item)excVar).load();
            this.registerCatch(body.pos(), startseg, ((GenContext)env.info).gaps.next(), catchallpc, 0);
            this.code.emitop0(191);
            this.code.markDead();
            if (((GenContext)env.info).cont != null) {
                this.code.resolve(((GenContext)env.info).cont);
                this.code.statBegin(TreeInfo.finalizerPos(env.tree, TreeInfo.PosKind.FIRST_STAT_POS));
                this.code.markStatBegin();
                Items.LocalItem retVar = this.makeTemp(this.syms.throwableType);
                retVar.store();
                ((GenContext)env.info).finalize.genLast();
                this.code.emitop1w(169, retVar.reg);
                this.code.markDead();
            }
        }
        this.code.resolve(exitChain);
        this.code.endScopes(limit);
    }

    void genCatch(JCTree.JCCatch tree, Env<GenContext> env, int startpc, int endpc, List<Integer> gaps) {
        if (startpc != endpc) {
            int catchType;
            JCTree.JCExpression subCatch;
            List<Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>> catchTypeExprs = this.catchTypesWithAnnotations(tree);
            while (gaps.nonEmpty()) {
                for (Pair<List<Attribute.TypeCompound>, JCTree.JCExpression> subCatch1 : catchTypeExprs) {
                    subCatch = (JCTree.JCExpression)subCatch1.snd;
                    catchType = this.makeRef(tree.pos(), subCatch.type);
                    int end = (Integer)gaps.head;
                    this.registerCatch(tree.pos(), startpc, end, this.code.curCP(), catchType);
                    for (Attribute.TypeCompound tc : (List)subCatch1.fst) {
                        tc.position.setCatchInfo(catchType, startpc);
                    }
                }
                gaps = gaps.tail;
                startpc = (Integer)gaps.head;
                gaps = gaps.tail;
            }
            if (startpc < endpc) {
                for (Pair<List<Attribute.TypeCompound>, JCTree.JCExpression> subCatch1 : catchTypeExprs) {
                    subCatch = (JCTree.JCExpression)subCatch1.snd;
                    catchType = this.makeRef(tree.pos(), subCatch.type);
                    this.registerCatch(tree.pos(), startpc, endpc, this.code.curCP(), catchType);
                    for (Attribute.TypeCompound tc : (List)subCatch1.fst) {
                        tc.position.setCatchInfo(catchType, startpc);
                    }
                }
            }
            this.genCatchBlock(tree, env);
        }
    }

    void genPatternMatchingCatch(JCTree.JCCatch tree, Env<GenContext> env, List<int[]> ranges) {
        for (int[] range : ranges) {
            JCTree.JCExpression subCatch = tree.param.vartype;
            int catchType = this.makeRef(tree.pos(), subCatch.type);
            this.registerCatch(tree.pos(), range[0], range[1], this.code.curCP(), catchType);
        }
        this.genCatchBlock(tree, env);
    }

    void genCatchBlock(JCTree.JCCatch tree, Env<GenContext> env) {
        Symbol.VarSymbol exparam = tree.param.sym;
        this.code.statBegin(tree.pos);
        this.code.markStatBegin();
        int limit = this.code.nextreg;
        this.code.newLocal(exparam);
        this.items.makeLocalItem(exparam).store();
        this.code.statBegin(TreeInfo.firstStatPos(tree.body));
        this.genStat(tree.body, env, 2);
        this.code.endScopes(limit);
        this.code.statBegin(TreeInfo.endPos(tree.body));
    }

    List<Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>> catchTypesWithAnnotations(JCTree.JCCatch tree) {
        return TreeInfo.isMultiCatch(tree) ? this.catchTypesWithAnnotationsFromMulticatch((JCTree.JCTypeUnion)tree.param.vartype, tree.param.sym.getRawTypeAttributes()) : List.of(new Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>(tree.param.sym.getRawTypeAttributes(), tree.param.vartype));
    }

    List<Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>> catchTypesWithAnnotationsFromMulticatch(JCTree.JCTypeUnion tree, List<Attribute.TypeCompound> first) {
        List<JCTree.JCExpression> alts = tree.alternatives;
        List<Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>> res = List.of(new Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>(first, (JCTree.JCExpression)alts.head));
        alts = alts.tail;
        while (alts != null && alts.head != null) {
            JCTree.JCExpression alt = (JCTree.JCExpression)alts.head;
            if (alt instanceof JCTree.JCAnnotatedType) {
                JCTree.JCAnnotatedType annotatedType = (JCTree.JCAnnotatedType)alt;
                res = res.prepend(new Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>(this.annotate.fromAnnotations(annotatedType.annotations), alt));
            } else {
                res = res.prepend(new Pair(List.nil(), alt));
            }
            alts = alts.tail;
        }
        return res.reverse();
    }

    void registerCatch(JCDiagnostic.DiagnosticPosition pos, int startpc, int endpc, int handler_pc, int catch_type) {
        char startpc1 = (char)startpc;
        char endpc1 = (char)endpc;
        char handler_pc1 = (char)handler_pc;
        if (startpc1 == startpc && endpc1 == endpc && handler_pc1 == handler_pc) {
            this.code.addCatch(startpc1, endpc1, handler_pc1, (char)catch_type);
        } else {
            this.log.error(pos, CompilerProperties.Errors.LimitCodeTooLargeForTryStmt);
            ++this.nerrs;
        }
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        int limit = this.code.nextreg;
        Code.Chain thenExit = null;
        Assert.check(this.code.isStatementStart());
        Items.CondItem c = this.genCond((JCTree)TreeInfo.skipParens(tree.cond), 8);
        Code.Chain elseChain = c.jumpFalse();
        Assert.check(this.code.isStatementStart());
        if (!c.isFalse()) {
            this.code.resolve(c.trueJumps);
            this.genStat(tree.thenpart, this.env, 17);
            thenExit = this.code.branch(167);
        }
        if (elseChain != null) {
            this.code.resolve(elseChain);
            if (tree.elsepart != null) {
                this.genStat(tree.elsepart, this.env, 17);
            }
        }
        this.code.resolve(thenExit);
        this.code.endScopes(limit);
        Assert.check(this.code.isStatementStart());
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        JCTree.JCExpression e = tree.expr;
        switch (e.getTag()) {
            case POSTINC: {
                ((JCTree.JCUnary)e).setTag(JCTree.Tag.PREINC);
                break;
            }
            case POSTDEC: {
                ((JCTree.JCUnary)e).setTag(JCTree.Tag.PREDEC);
            }
        }
        Assert.check(this.code.isStatementStart());
        this.genExpr(tree.expr, tree.expr.type).drop();
        Assert.check(this.code.isStatementStart());
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        Assert.check(this.code.isStatementStart());
        Env<GenContext> targetEnv = this.unwindBreak(tree.target);
        ((GenContext)targetEnv.info).addExit(this.code.branch(167));
        this.endFinalizerGaps(this.env, targetEnv);
    }

    @Override
    public void visitYield(JCTree.JCYield tree) {
        Env<GenContext> targetEnv;
        Assert.check(this.code.isStatementStart());
        if (this.inCondSwitchExpression) {
            Items.CondItem value = this.genCond((JCTree)tree.value, 16);
            Code.Chain falseJumps = value.jumpFalse();
            this.code.resolve(value.trueJumps);
            Env<GenContext> localEnv = this.unwindBreak(tree.target);
            this.reloadStackBeforeSwitchExpr();
            Code.Chain trueJumps = this.code.branch(167);
            this.endFinalizerGaps(this.env, localEnv);
            this.code.resolve(falseJumps);
            targetEnv = this.unwindBreak(tree.target);
            this.reloadStackBeforeSwitchExpr();
            falseJumps = this.code.branch(167);
            this.switchExpressionTrueChain = this.switchExpressionTrueChain == null ? trueJumps : Code.mergeChains(this.switchExpressionTrueChain, trueJumps);
            this.switchExpressionFalseChain = this.switchExpressionFalseChain == null ? falseJumps : Code.mergeChains(this.switchExpressionFalseChain, falseJumps);
        } else {
            this.genExpr(tree.value, this.pt).load();
            if (this.switchResult != null) {
                this.switchResult.store();
            }
            targetEnv = this.unwindBreak(tree.target);
            if (this.code.isAlive()) {
                this.reloadStackBeforeSwitchExpr();
                if (this.switchResult != null) {
                    this.switchResult.load();
                }
                ((GenContext)targetEnv.info).addExit(this.code.branch(167));
                this.code.markDead();
            }
        }
        this.endFinalizerGaps(this.env, targetEnv);
    }

    private Env<GenContext> unwindBreak(JCTree target) {
        int tmpPos = this.code.pendingStatPos;
        Env<GenContext> targetEnv = this.unwind(target, this.env);
        this.code.pendingStatPos = tmpPos;
        return targetEnv;
    }

    private void reloadStackBeforeSwitchExpr() {
        for (Items.LocalItem li : this.stackBeforeSwitchExpression) {
            li.load();
        }
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        int tmpPos = this.code.pendingStatPos;
        Env<GenContext> targetEnv = this.unwind(tree.target, this.env);
        this.code.pendingStatPos = tmpPos;
        Assert.check(this.code.isStatementStart());
        ((GenContext)targetEnv.info).addCont(this.code.branch(167));
        this.endFinalizerGaps(this.env, targetEnv);
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        Env<GenContext> targetEnv;
        int limit = this.code.nextreg;
        int tmpPos = this.code.pendingStatPos;
        if (tree.expr != null) {
            Assert.check(this.code.isStatementStart());
            Items.Item r = this.genExpr(tree.expr, this.pt).load();
            if (this.hasFinally(this.env.enclMethod, this.env)) {
                r = this.makeTemp(this.pt);
                r.store();
            }
            targetEnv = this.unwind(this.env.enclMethod, this.env);
            this.code.pendingStatPos = tmpPos;
            r.load();
            this.code.emitop0(172 + Code.truncate(Code.typecode(this.pt)));
        } else {
            targetEnv = this.unwind(this.env.enclMethod, this.env);
            this.code.pendingStatPos = tmpPos;
            this.code.emitop0(177);
        }
        this.endFinalizerGaps(this.env, targetEnv);
        this.code.endScopes(limit);
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        Assert.check(this.code.isStatementStart());
        this.genExpr(tree.expr, tree.expr.type).load();
        this.code.emitop0(191);
        Assert.check(this.code.isStatementStart());
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        this.setTypeAnnotationPositions(tree.pos);
        Items.Item m = this.genExpr(tree.meth, this.methodType);
        Symbol.MethodSymbol msym = (Symbol.MethodSymbol)TreeInfo.symbol(tree.meth);
        this.genArgs(tree.args, msym.externalType(this.types).getParameterTypes());
        if (!msym.isDynamic()) {
            this.code.statBegin(tree.pos);
        }
        if (this.patternMatchingCatchConfiguration.invocations().contains(tree)) {
            int start = this.code.curCP();
            this.result = m.invoke();
            this.patternMatchingCatchConfiguration.ranges().add(new int[]{start, this.code.curCP()});
        } else if (msym.isConstructor() && TreeInfo.isConstructorCall((JCTree.JCMethodInvocation)tree)) {
            this.generatePatternMatchingCatch(this.env);
            this.result = m.invoke();
            this.patternMatchingCatchConfiguration = this.patternMatchingCatchConfiguration.restart(this.code.state.dup());
        } else {
            this.result = m.invoke();
        }
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        int startpc;
        Code.Chain thenExit = null;
        this.code.statBegin(tree.cond.pos);
        Items.CondItem c = this.genCond((JCTree)tree.cond, 8);
        Code.Chain elseChain = c.jumpFalse();
        if (!c.isFalse()) {
            this.code.resolve(c.trueJumps);
            startpc = this.genCrt ? this.code.curCP() : 0;
            this.code.statBegin(tree.truepart.pos);
            this.genExpr(tree.truepart, this.pt).load();
            if (this.genCrt) {
                this.code.crt.put(tree.truepart, 16, startpc, this.code.curCP());
            }
            thenExit = this.code.branch(167);
        }
        if (elseChain != null) {
            this.code.resolve(elseChain);
            startpc = this.genCrt ? this.code.curCP() : 0;
            this.code.statBegin(tree.falsepart.pos);
            this.genExpr(tree.falsepart, this.pt).load();
            if (this.genCrt) {
                this.code.crt.put(tree.falsepart, 16, startpc, this.code.curCP());
            }
        }
        this.code.resolve(thenExit);
        this.result = this.items.makeStackItem(this.pt);
    }

    private void setTypeAnnotationPositions(int treePos) {
        Symbol.MethodSymbol meth = this.code.meth;
        boolean initOrClinit = this.code.meth.getKind() == ElementKind.CONSTRUCTOR || this.code.meth.getKind() == ElementKind.STATIC_INIT;
        for (Attribute.TypeCompound ta : meth.getRawTypeAttributes()) {
            if (ta.hasUnknownPosition()) {
                ta.tryFixPosition();
            }
            if (!ta.position.matchesPos(treePos)) continue;
            ta.position.updatePosOffset(this.code.cp);
        }
        if (!initOrClinit) {
            return;
        }
        for (Attribute.TypeCompound ta : meth.owner.getRawTypeAttributes()) {
            if (ta.hasUnknownPosition()) {
                ta.tryFixPosition();
            }
            if (!ta.position.matchesPos(treePos)) continue;
            ta.position.updatePosOffset(this.code.cp);
        }
        Symbol.ClassSymbol clazz = meth.enclClass();
        for (Symbol s : new FilteredMemberList(clazz.members())) {
            if (!s.getKind().isField()) continue;
            for (Attribute.TypeCompound ta : s.getRawTypeAttributes()) {
                if (ta.hasUnknownPosition()) {
                    ta.tryFixPosition();
                }
                if (!ta.position.matchesPos(treePos)) continue;
                ta.position.updatePosOffset(this.code.cp);
            }
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        Assert.check(tree.encl == null && tree.def == null);
        this.setTypeAnnotationPositions(tree.pos);
        this.code.emitop2(187, this.checkDimension(tree.pos(), tree.type), PoolWriter::putClass);
        this.code.emitop0(89);
        this.genArgs(tree.args, tree.constructor.externalType(this.types).getParameterTypes());
        this.items.makeMemberItem(tree.constructor, true).invoke();
        this.result = this.items.makeStackItem(tree.type);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        this.setTypeAnnotationPositions(tree.pos);
        if (tree.elems != null) {
            Type elemtype = this.types.elemtype(tree.type);
            this.loadIntConst(tree.elems.length());
            Items.Item arr = this.makeNewArray(tree.pos(), tree.type, 1);
            int i = 0;
            List<JCTree.JCExpression> l = tree.elems;
            while (l.nonEmpty()) {
                arr.duplicate();
                this.loadIntConst(i);
                ++i;
                this.genExpr((JCTree)l.head, elemtype).load();
                this.items.makeIndexedItem(elemtype).store();
                l = l.tail;
            }
            this.result = arr;
        } else {
            List<JCTree.JCExpression> l = tree.dims;
            while (l.nonEmpty()) {
                this.genExpr((JCTree)l.head, this.syms.intType).load();
                l = l.tail;
            }
            this.result = this.makeNewArray(tree.pos(), tree.type, tree.dims.length());
        }
    }

    Items.Item makeNewArray(JCDiagnostic.DiagnosticPosition pos, Type type, int ndims) {
        int elemcode;
        Type elemtype = this.types.elemtype(type);
        if (this.types.dimensions(type) > 255) {
            this.log.error(pos, CompilerProperties.Errors.LimitDimensions);
            ++this.nerrs;
        }
        if ((elemcode = Code.arraycode(elemtype)) == 0 || elemcode == 1 && ndims == 1) {
            this.code.emitAnewarray(this.makeRef(pos, elemtype), type);
        } else if (elemcode == 1) {
            this.code.emitMultianewarray(ndims, this.makeRef(pos, type), type);
        } else {
            this.code.emitNewarray(elemcode, type);
        }
        return this.items.makeStackItem(type);
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        this.result = this.genExpr(tree.expr, tree.expr.type);
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        Items.Item l = this.genExpr(tree.lhs, tree.lhs.type);
        this.genExpr(tree.rhs, tree.lhs.type).load();
        if (tree.rhs.type.hasTag(TypeTag.BOT)) {
            this.code.state.forceStackTop(tree.lhs.type);
        }
        this.result = this.items.makeAssignItem(l);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        Items.Item l;
        Symbol.OperatorSymbol operator = tree.operator;
        if (operator.opcode == 256) {
            l = this.concat.makeConcat(tree);
        } else {
            l = this.genExpr(tree.lhs, tree.lhs.type);
            if ((tree.hasTag(JCTree.Tag.PLUS_ASG) || tree.hasTag(JCTree.Tag.MINUS_ASG)) && l instanceof Items.LocalItem) {
                Items.LocalItem localItem = (Items.LocalItem)l;
                if (tree.lhs.type.getTag().isSubRangeOf(TypeTag.INT) && tree.rhs.type.getTag().isSubRangeOf(TypeTag.INT) && tree.rhs.type.constValue() != null) {
                    int ival = ((Number)tree.rhs.type.constValue()).intValue();
                    if (tree.hasTag(JCTree.Tag.MINUS_ASG)) {
                        ival = -ival;
                    }
                    localItem.incr(ival);
                    this.result = l;
                    return;
                }
            }
            l.duplicate();
            l.coerce((Type)operator.type.getParameterTypes().head).load();
            this.completeBinop(tree.lhs, tree.rhs, operator).coerce(tree.lhs.type);
        }
        this.result = this.items.makeAssignItem(l);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        Symbol.OperatorSymbol operator = tree.operator;
        if (tree.hasTag(JCTree.Tag.NOT)) {
            Items.CondItem od = this.genCond((JCTree)tree.arg, false);
            this.result = od.negate();
        } else {
            Items.Item od = this.genExpr(tree.arg, (Type)operator.type.getParameterTypes().head);
            switch (tree.getTag()) {
                case POS: {
                    this.result = od.load();
                    break;
                }
                case NEG: {
                    this.result = od.load();
                    this.code.emitop0(operator.opcode);
                    break;
                }
                case COMPL: {
                    this.result = od.load();
                    this.emitMinusOne(od.typecode);
                    this.code.emitop0(operator.opcode);
                    break;
                }
                case PREINC: 
                case PREDEC: {
                    od.duplicate();
                    if (od instanceof Items.LocalItem) {
                        Items.LocalItem localItem = (Items.LocalItem)od;
                        if (operator.opcode == 96 || operator.opcode == 100) {
                            localItem.incr(tree.hasTag(JCTree.Tag.PREINC) ? 1 : -1);
                            this.result = od;
                            break;
                        }
                    }
                    od.load();
                    this.code.emitop0(Gen.one(od.typecode));
                    this.code.emitop0(operator.opcode);
                    if (od.typecode != 0 && Code.truncate(od.typecode) == 0) {
                        this.code.emitop0(145 + od.typecode - 5);
                    }
                    this.result = this.items.makeAssignItem(od);
                    break;
                }
                case POSTINC: 
                case POSTDEC: {
                    od.duplicate();
                    if (od instanceof Items.LocalItem) {
                        Items.LocalItem localItem = (Items.LocalItem)od;
                        if (operator.opcode == 96 || operator.opcode == 100) {
                            Items.Item res = od.load();
                            localItem.incr(tree.hasTag(JCTree.Tag.POSTINC) ? 1 : -1);
                            this.result = res;
                            break;
                        }
                    }
                    Items.Item res = od.load();
                    od.stash(od.typecode);
                    this.code.emitop0(Gen.one(od.typecode));
                    this.code.emitop0(operator.opcode);
                    if (od.typecode != 0 && Code.truncate(od.typecode) == 0) {
                        this.code.emitop0(145 + od.typecode - 5);
                    }
                    od.store();
                    this.result = res;
                    break;
                }
                case NULLCHK: {
                    this.result = od.load();
                    this.code.emitop0(89);
                    this.genNullCheck(tree);
                    break;
                }
                default: {
                    Assert.error();
                }
            }
        }
    }

    private void genNullCheck(JCTree tree) {
        this.code.statBegin(tree.pos);
        this.callMethod(tree.pos(), this.syms.objectsType, this.names.requireNonNull, List.of(this.syms.objectType), true);
        this.code.emitop0(87);
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        Symbol.OperatorSymbol operator = tree.operator;
        if (operator.opcode == 256) {
            this.result = this.concat.makeConcat(tree);
        } else if (tree.hasTag(JCTree.Tag.AND)) {
            Items.CondItem lcond = this.genCond((JCTree)tree.lhs, 8);
            if (!lcond.isFalse()) {
                Code.Chain falseJumps = lcond.jumpFalse();
                this.code.resolve(lcond.trueJumps);
                Items.CondItem rcond = this.genCond((JCTree)tree.rhs, 16);
                this.result = this.items.makeCondItem(rcond.opcode, rcond.trueJumps, Code.mergeChains(falseJumps, rcond.falseJumps));
            } else {
                this.result = lcond;
            }
        } else if (tree.hasTag(JCTree.Tag.OR)) {
            Items.CondItem lcond = this.genCond((JCTree)tree.lhs, 8);
            if (!lcond.isTrue()) {
                Code.Chain trueJumps = lcond.jumpTrue();
                this.code.resolve(lcond.falseJumps);
                Items.CondItem rcond = this.genCond((JCTree)tree.rhs, 16);
                this.result = this.items.makeCondItem(rcond.opcode, Code.mergeChains(trueJumps, rcond.trueJumps), rcond.falseJumps);
            } else {
                this.result = lcond;
            }
        } else {
            Items.Item od = this.genExpr(tree.lhs, (Type)operator.type.getParameterTypes().head);
            od.load();
            this.result = this.completeBinop(tree.lhs, tree.rhs, operator);
        }
    }

    Items.Item completeBinop(JCTree lhs, JCTree rhs, Symbol.OperatorSymbol operator) {
        Number number;
        Object object;
        Type.MethodType optype = (Type.MethodType)operator.type;
        int opcode = operator.opcode;
        if (opcode >= 159 && opcode <= 164 && (object = rhs.type.constValue()) instanceof Number && (number = (Number)object).intValue() == 0) {
            opcode += -6;
        } else if (opcode >= 165 && opcode <= 166 && TreeInfo.isNull(rhs)) {
            opcode += 33;
        } else {
            Type rtype = (Type)operator.erasure((Types)this.types).getParameterTypes().tail.head;
            if (opcode >= 270 && opcode <= 275) {
                opcode += -150;
                rtype = this.syms.intType;
            }
            this.genExpr(rhs, rtype).load();
            if (opcode >= 512) {
                this.code.emitop0(opcode >> 9);
                opcode &= 0xFF;
            }
        }
        if (opcode >= 153 && opcode <= 166 || opcode == 198 || opcode == 199) {
            return this.items.makeCondItem(opcode);
        }
        this.code.emitop0(opcode);
        return this.items.makeStackItem(optype.restype);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.result = this.genExpr(tree.expr, tree.clazz.type).load();
        this.setTypeAnnotationPositions(tree.pos);
        if (!tree.clazz.type.isPrimitive() && !this.types.isSameType(tree.expr.type, tree.clazz.type) && this.types.asSuper(tree.expr.type, tree.clazz.type.tsym) == null) {
            this.code.emitop2(192, this.checkDimension(tree.pos(), tree.clazz.type), PoolWriter::putClass);
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        throw new AssertionError((Object)this.getClass().getName());
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.genExpr(tree.expr, tree.expr.type).load();
        this.setTypeAnnotationPositions(tree.pos);
        this.code.emitop2(193, this.makeRef(tree.pos(), tree.pattern.type));
        this.result = this.items.makeStackItem(this.syms.booleanType);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.genExpr(tree.indexed, tree.indexed.type).load();
        this.genExpr(tree.index, this.syms.intType).load();
        this.result = this.items.makeIndexedItem(tree.type);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        Symbol sym = tree.sym;
        if (tree.name == this.names._this || tree.name == this.names._super) {
            Items.Item res;
            Items.Item item = res = tree.name == this.names._this ? this.items.makeThisItem() : this.items.makeSuperItem();
            if (sym.kind == Kinds.Kind.MTH) {
                res.load();
                res = this.items.makeMemberItem(sym, true);
            }
            this.result = res;
        } else if (this.isInvokeDynamic(sym) || this.isConstantDynamic(sym)) {
            if (this.isConstantDynamic(sym)) {
                this.setTypeAnnotationPositions(tree.pos);
            }
            this.result = this.items.makeDynamicItem(sym);
        } else if (sym.kind == Kinds.Kind.VAR && (sym.owner.kind == Kinds.Kind.MTH || sym.owner.kind == Kinds.Kind.VAR)) {
            this.result = this.items.makeLocalItem((Symbol.VarSymbol)sym);
        } else if ((sym.flags() & 8L) != 0L) {
            if (!this.isAccessSuper(this.env.enclMethod)) {
                sym = this.binaryQualifier(sym, this.env.enclClass.type);
            }
            this.result = this.items.makeStaticItem(sym);
        } else {
            this.items.makeThisItem().load();
            sym = this.binaryQualifier(sym, this.env.enclClass.type);
            this.result = this.items.makeMemberItem(sym, this.nonVirtualForPrivateAccess(sym));
        }
    }

    private boolean nonVirtualForPrivateAccess(Symbol sym) {
        boolean useVirtual = this.target.hasVirtualPrivateInvoke() && !this.disableVirtualizedPrivateInvoke;
        return !useVirtual && (sym.flags() & 2L) != 0L;
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        Items.Item base;
        Symbol sym = tree.sym;
        if (tree.name == this.names._class) {
            this.code.emitLdc((PoolConstant.LoadableConstant)((Object)this.checkDimension(tree.pos(), tree.selected.type)));
            this.result = this.items.makeStackItem(this.pt);
            return;
        }
        Symbol ssym = TreeInfo.symbol(tree.selected);
        boolean selectSuper = ssym != null && (ssym.kind == Kinds.Kind.TYP || ssym.name == this.names._super);
        boolean accessSuper = this.isAccessSuper(this.env.enclMethod);
        Items.Item item = base = selectSuper ? this.items.makeSuperItem() : this.genExpr(tree.selected, tree.selected.type);
        if (sym.kind == Kinds.Kind.VAR && ((Symbol.VarSymbol)sym).getConstValue() != null) {
            if ((sym.flags() & 8L) != 0L) {
                if (!(selectSuper || ssym != null && ssym.kind == Kinds.Kind.TYP)) {
                    base = base.load();
                }
                base.drop();
            } else {
                base.load();
                this.genNullCheck(tree.selected);
            }
            this.result = this.items.makeImmediateItem(sym.type, ((Symbol.VarSymbol)sym).getConstValue());
        } else {
            if (this.isInvokeDynamic(sym)) {
                this.result = this.items.makeDynamicItem(sym);
                return;
            }
            if (((sym = this.binaryQualifier(sym, tree.selected.type)).flags() & 8L) != 0L) {
                if (!(selectSuper || ssym != null && ssym.kind == Kinds.Kind.TYP)) {
                    base = base.load();
                }
                base.drop();
                this.result = this.items.makeStaticItem(sym);
            } else {
                base.load();
                if (sym == this.syms.lengthVar) {
                    this.code.emitop0(190);
                    this.result = this.items.makeStackItem(this.syms.intType);
                } else {
                    this.result = this.items.makeMemberItem(sym, this.nonVirtualForPrivateAccess(sym) || selectSuper || accessSuper);
                }
            }
        }
    }

    public boolean isInvokeDynamic(Symbol sym) {
        return sym.kind == Kinds.Kind.MTH && ((Symbol.MethodSymbol)sym).isDynamic();
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        if (tree.type.hasTag(TypeTag.BOT)) {
            this.code.emitop0(1);
            this.result = this.items.makeStackItem(tree.type);
        } else {
            this.result = this.items.makeImmediateItem(tree.type, tree.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        this.code.resolvePending();
        int limit = this.code.nextreg;
        int prevLetExprStart = this.code.setLetExprStackPos(this.code.state.stacksize);
        try {
            this.genStats(tree.defs, this.env);
        }
        finally {
            this.code.setLetExprStackPos(prevLetExprStart);
        }
        this.result = this.genExpr(tree.expr, tree.expr.type).load();
        this.code.endScopes(limit);
    }

    private void generateReferencesToPrunedTree(Symbol.ClassSymbol classSymbol) {
        List<JCTree> prunedInfo = this.lower.prunedTree.get(classSymbol);
        if (prunedInfo != null) {
            for (JCTree prunedTree : prunedInfo) {
                prunedTree.accept(this.classReferenceVisitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean genClass(Env<AttrContext> env, JCTree.JCClassDecl cdef) {
        try {
            this.attrEnv = env;
            Symbol.ClassSymbol c = cdef.sym;
            this.toplevel = env.toplevel;
            this.endPosTable = this.toplevel.endPositions;
            cdef.defs = this.normalizeDefs(cdef.defs, c);
            this.generateReferencesToPrunedTree(c);
            Env<GenContext> localEnv = new Env<GenContext>(cdef, new GenContext());
            localEnv.toplevel = env.toplevel;
            localEnv.enclClass = cdef;
            List<JCTree> l = cdef.defs;
            while (l.nonEmpty()) {
                this.genDef((JCTree)l.head, localEnv);
                l = l.tail;
            }
            if (this.poolWriter.size() > 65535) {
                this.log.error(cdef.pos(), CompilerProperties.Errors.LimitPool);
                ++this.nerrs;
            }
            if (this.nerrs != 0) {
                l = cdef.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF)) {
                        ((JCTree.JCMethodDecl)l.head).sym.code = null;
                    }
                    l = l.tail;
                }
            }
            cdef.defs = List.nil();
            boolean bl = this.nerrs == 0;
            return bl;
        }
        finally {
            this.attrEnv = null;
            this.env = null;
            this.toplevel = null;
            this.endPosTable = null;
            this.nerrs = 0;
            this.qualifiedSymbolCache.clear();
        }
    }

    record PatternMatchingCatchConfiguration(Set<JCTree.JCMethodInvocation> invocations, ListBuffer<int[]> ranges, JCTree.JCCatch handler, Code.State startState) {
        public PatternMatchingCatchConfiguration restart(Code.State newState) {
            return new PatternMatchingCatchConfiguration(this.invocations(), new ListBuffer<int[]>(), this.handler(), newState);
        }
    }

    class ClassReferenceVisitor
    extends JCTree.Visitor {
        ClassReferenceVisitor() {
        }

        @Override
        public void visitTree(JCTree tree) {
        }

        @Override
        public void visitBinary(JCTree.JCBinary tree) {
            tree.lhs.accept(this);
            tree.rhs.accept(this);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            if (tree.selected.type.hasTag(TypeTag.CLASS)) {
                Gen.this.makeRef(tree.selected.pos(), tree.selected.type);
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            Symbol symbol = tree.sym.owner;
            if (symbol instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                Gen.this.poolWriter.putClass(classSymbol);
            }
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            tree.cond.accept(this);
            tree.truepart.accept(this);
            tree.falsepart.accept(this);
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            tree.arg.accept(this);
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            tree.expr.accept(this);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            tree.expr.accept(this);
        }
    }

    final class GenContext {
        final int limit;
        Code.Chain exit = null;
        Code.Chain cont = null;
        GenFinalizer finalize = null;
        boolean isSwitch = false;
        ListBuffer<Integer> gaps = null;

        GenContext() {
            Code code = Gen.this.code;
            this.limit = code == null ? 0 : code.nextreg;
        }

        void addExit(Code.Chain c) {
            if (c != null) {
                c.state.defined.excludeFrom(this.limit);
            }
            this.exit = Code.mergeChains(c, this.exit);
        }

        void addCont(Code.Chain c) {
            if (c != null) {
                c.state.defined.excludeFrom(this.limit);
            }
            this.cont = Code.mergeChains(c, this.cont);
        }
    }

    abstract class GenFinalizer {
        GenFinalizer() {
        }

        abstract void gen();

        abstract void genLast();

        boolean hasFinalizer() {
            return true;
        }

        void afterBody() {
        }
    }

    public static class CodeSizeOverflow
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
    }
}

