/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.nette.tester.options.TesterOptions;
import org.netbeans.modules.php.nette.tester.options.TesterOptionsValidator;
import org.netbeans.modules.php.nette.tester.ui.options.TesterOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class TesterOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "nette-tester";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/nette-tester";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/nette-tester";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private TesterOptionsPanel testerOptionsPanel = null;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPanel().setTesterPath(this.getTesterOptions().getTesterPath());
            this.getPanel().setPhpIniPath(this.getTesterOptions().getPhpIniPath());
            this.getPanel().setBinaryExecutable(this.getTesterOptions().getBinaryExecutable());
        }
        this.changed = false;
    }

    public void applyChanges() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TesterOptionsPanelController.this.getTesterOptions().setTesterPath(TesterOptionsPanelController.this.getPanel().getTesterPath());
                TesterOptionsPanelController.this.getTesterOptions().setPhpIniPath(TesterOptionsPanelController.this.getPanel().getPhpIniPath());
                TesterOptionsPanelController.this.getTesterOptions().setBinaryExecutable(TesterOptionsPanelController.this.getPanel().getBinaryExecutable());
                TesterOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPanel().setTesterPath(this.getTesterOptions().getTesterPath());
            this.getPanel().setPhpIniPath(this.getTesterOptions().getPhpIniPath());
            this.getPanel().setBinaryExecutable(this.getTesterOptions().getBinaryExecutable());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        TesterOptionsPanel panel = this.getPanel();
        ValidationResult result = new TesterOptionsValidator().validate(panel.getTesterPath(), panel.getPhpIniPath()).getResult();
        if (result.hasErrors()) {
            panel.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getTesterOptions().getTesterPath();
        String current = this.getPanel().getTesterPath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getTesterOptions().getPhpIniPath();
        current = this.getPanel().getPhpIniPath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getTesterOptions().getBinaryExecutable();
        current = this.getPanel().getBinaryExecutable();
        if (current != null) {
            current = current.trim();
        }
        return saved == null ? current != null && !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.nette.tester.ui.options.TesterOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private TesterOptionsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.testerOptionsPanel == null) {
            this.testerOptionsPanel = new TesterOptionsPanel();
            this.testerOptionsPanel.addChangeListener(this);
        }
        return this.testerOptionsPanel;
    }

    private TesterOptions getTesterOptions() {
        return TesterOptions.getInstance();
    }
}

