/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.javascript2.editor.FSCompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Utilities;

public class FileUtils {
    private static final String SLASH = "/";
    private static final String FILE = "file";
    private static final Logger LOG = Logger.getLogger(FileUtils.class.getName());

    public static FileObject findFileObject(FileObject fromFO, String path, boolean filesOnly) {
        FileObject parent = fromFO.getParent();
        Project project = FileOwnerQuery.getOwner((FileObject)fromFO);
        String projectDirectoryPath = "";
        if (project != null) {
            FileObject projectDirectory = project.getProjectDirectory();
            projectDirectoryPath = projectDirectory.getPath();
        }
        if (parent != null && !path.isEmpty()) {
            while (parent != null && parent.getPath().contains(projectDirectoryPath)) {
                FileObject targetFO = parent.getFileObject(path);
                if (targetFO != null && (!filesOnly || filesOnly && !targetFO.isFolder())) {
                    return targetFO;
                }
                targetFO = parent.getFileObject(path + ".js");
                if (targetFO != null) {
                    return targetFO;
                }
                parent = parent.getParent();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CompletionProposal> computeRelativeItems(Collection<? extends FileObject> relativeTo, String prefix, int anchor, boolean addExtensions, boolean addRelativePrefix, FileObjectFilter filter) throws IOException {
        String filePrefix;
        String pathPrefix;
        assert (relativeTo != null);
        LinkedList<CompletionProposal> result = new LinkedList<CompletionProposal>();
        int lastSlash = prefix.lastIndexOf(47);
        if (lastSlash != -1) {
            pathPrefix = prefix.substring(0, lastSlash);
            filePrefix = prefix.substring(lastSlash + 1);
        } else {
            pathPrefix = null;
            filePrefix = prefix;
        }
        HashSet<Object> directories = new HashSet<Object>();
        File prefixFile = null;
        if (pathPrefix != null && !pathPrefix.startsWith(".")) {
            prefixFile = pathPrefix.length() == 0 && prefix.startsWith(SLASH) ? new File(SLASH) : new File(pathPrefix);
        }
        if (prefixFile != null && prefixFile.exists()) {
            File normalizeFile = FileUtil.normalizeFile((File)prefixFile);
            FileObject fileObject = FileUtil.toFileObject((File)normalizeFile);
            if (fileObject != null) {
                directories.add(fileObject);
            }
        } else {
            for (FileObject fileObject : relativeTo) {
                void var13_14;
                if (pathPrefix != null) {
                    File toFile = FileUtil.toFile((FileObject)fileObject);
                    if (toFile != null) {
                        URI resolve;
                        try {
                            resolve = BaseUtilities.normalizeURI((URI)Utilities.toURI((File)toFile).resolve(pathPrefix));
                        }
                        catch (IllegalArgumentException ex) {
                            resolve = null;
                        }
                        if (resolve != null && (resolve.getScheme() == null || FILE.equals(resolve.getScheme()))) {
                            try {
                                File normalizedFile = FileUtil.normalizeFile((File)Utilities.toFile((URI)resolve));
                                FileObject fileObject2 = FileUtil.toFileObject((File)normalizedFile);
                            }
                            catch (IllegalArgumentException e) {
                                LOG.log(Level.FINE, "could not convert " + resolve + " to File", resolve);
                            }
                        }
                    } else {
                        FileObject fileObject3 = fileObject.getFileObject(pathPrefix);
                    }
                }
                if (var13_14 == null) continue;
                if (!var13_14.isFolder()) {
                    if (var13_14.getParent() == null) continue;
                    directories.add(var13_14.getParent());
                    continue;
                }
                directories.add(var13_14);
            }
        }
        for (FileObject fileObject : directories) {
            FileObject[] children = fileObject.getChildren();
            for (int cntr = 0; cntr < children.length; ++cntr) {
                FileObject current = children[cntr];
                if (!VisibilityQuery.getDefault().isVisible(current) || !current.getNameExt().toLowerCase().startsWith(filePrefix.toLowerCase()) || !filter.accept(current)) continue;
                int newAnchor = anchor - prefix.length();
                result.add(new FSCompletionItem(current, (String)(pathPrefix != null ? pathPrefix + SLASH : (filePrefix.isEmpty() && addRelativePrefix ? "./" : "")), addExtensions, newAnchor));
            }
        }
        return result;
    }

    public static interface FileObjectFilter {
        public boolean accept(FileObject var1);
    }
}

