/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.ClassTypeList;
import org.netbeans.modules.debugger.jpda.DeadlockDetectorImpl;
import org.netbeans.modules.debugger.jpda.DebuggerConsoleIO;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.JSR45DebuggerEngineProvider;
import org.netbeans.modules.debugger.jpda.JavaEngineProvider;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.ThreadsCollectorImpl;
import org.netbeans.modules.debugger.jpda.actions.ActionErrorMessageCallback;
import org.netbeans.modules.debugger.jpda.actions.ActionMessageCallback;
import org.netbeans.modules.debugger.jpda.actions.ActionStatusDisplayCallback;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsEngineListener;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorExpression;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;
import org.netbeans.modules.debugger.jpda.expr.formatters.Formatters;
import org.netbeans.modules.debugger.jpda.expr.formatters.FormattersLoopControl;
import org.netbeans.modules.debugger.jpda.expr.formatters.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IntegerValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocalVariableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.ClassVariableImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ObjectTranslation;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;
import org.netbeans.modules.debugger.jpda.models.VariableMirrorTranslator;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class JPDADebuggerImpl
extends JPDADebugger {
    private static final Logger logger = Logger.getLogger(JPDADebuggerImpl.class.getName());
    private static final boolean SINGLE_THREAD_STEPPING = !Boolean.getBoolean("netbeans.debugger.multiThreadStepping");
    private VirtualMachine virtualMachine = null;
    private final Object virtualMachineLock = new Object();
    private Throwable throwable;
    private int state = 0;
    private final Object stateLock = new Object();
    private Operator operator;
    private PropertyChangeSupport pcs;
    public PropertyChangeSupport varChangeSupport = new PropertyChangeSupport((Object)this);
    private JPDAThreadImpl currentThread;
    private CallStackFrame currentCallStackFrame;
    private final Object currentThreadAndFrameLock = new Object();
    private volatile JPDAThreadImpl currentSuspendedNoFireThread;
    private int suspend = SINGLE_THREAD_STEPPING ? 1 : 2;
    public final ReentrantReadWriteLock accessLock = new DebuggerReentrantReadWriteLock(true);
    private final Object LOCK2 = new Object();
    private boolean starting;
    private AbstractDICookie attachingCookie;
    private JavaEngineProvider javaEngineProvider;
    private Set<String> languages;
    private ContextProvider lookupProvider;
    private ObjectTranslation threadsTranslation;
    private ObjectTranslation localsTranslation;
    private ExpressionPool expressionPool;
    private ThreadsCache threadsCache;
    private DeadlockDetector deadlockDetector;
    private ThreadsCollectorImpl threadsCollector;
    private final Object threadsCollectorLock = new Object();
    private final Map<Long, String> markedObjects = new LinkedHashMap<Long, String>();
    private final Map<String, ObjectVariable> markedObjectLabels = new LinkedHashMap<String, ObjectVariable>();
    private final Map<ClassType, List> allInterfacesMap = new WeakHashMap<ClassType, List>();
    private static final int RP_THROUGHPUT = 10;
    private final RequestProcessor rpCreateThreads = new RequestProcessor(JPDADebuggerImpl.class.getName() + "_newJPDAThreads", 10);
    private StackFrame altCSF = null;
    private boolean doContinue = true;
    private Boolean singleThreadStepResumeDecision = null;
    private Boolean stepInterruptByBptResumeDecision = null;
    private boolean breakpointsActive = true;
    private final DebuggerConsoleIO io;
    private PeriodicThreadsDump ptd;
    private boolean vmSuspended = false;
    private Boolean canBeModified;
    private final Object canBeModifiedLock = new Object();
    private SmartSteppingFilter smartSteppingFilter;
    CompoundSmartSteppingListener compoundSmartSteppingListener;
    InvalidExpressionException methodCallsUnsupportedExc;
    private Method stringLengthMethod;
    private Method stringSubstringMethod;
    private final Object stringMethodsLock = new Object();
    private boolean finishing;
    private Set<JPDAThreadGroup> interestedThreadGroups = Collections.newSetFromMap(new WeakHashMap());
    private SourcePath engineContext;
    private CallStackFrame preferredTopFrame;
    private Set<JSR45DebuggerEngineProvider> jsr45EngineProviders;
    private static final String COMPUTING_INTERFACES = "computing";

    public JPDADebuggerImpl(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        int stepResume = p.getInt("StepResume", SINGLE_THREAD_STEPPING ? 1 : 0);
        this.suspend = stepResume == 1 ? 1 : 2;
        this.pcs = new PropertyChangeSupport((Object)this);
        List l = lookupProvider.lookup(null, DebuggerEngineProvider.class);
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            if (!(l.get(i) instanceof JavaEngineProvider)) continue;
            this.javaEngineProvider = (JavaEngineProvider)((Object)l.get(i));
        }
        if (this.javaEngineProvider == null) {
            throw new IllegalArgumentException("JavaEngineProvider have to be used to start JPDADebugger!");
        }
        this.languages = new HashSet<String>();
        this.languages.add("Java");
        this.threadsTranslation = ObjectTranslation.createThreadTranslation(this);
        this.localsTranslation = ObjectTranslation.createLocalsTranslation(this);
        this.expressionPool = new ExpressionPool();
        this.io = new DebuggerConsoleIO(this, lookupProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuspend() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspend(int s) {
        int old;
        Object object = this.stateLock;
        synchronized (object) {
            if (s == this.suspend) {
                return;
            }
            old = this.suspend;
            this.suspend = s;
        }
        this.firePropertyChange("suspend", old, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPDAThread getCurrentThread() {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            return this.currentThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallStackFrame getCurrentCallStackFrame() {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            return this.currentCallStackFrame;
        }
    }

    public Variable evaluate(String expression) throws InvalidExpressionException {
        return this.evaluate(expression, null, null);
    }

    public Variable evaluate(String expression, ObjectVariable var) throws InvalidExpressionException {
        return this.evaluate(expression, null, var);
    }

    public Variable evaluate(String expression, CallStackFrame csf) throws InvalidExpressionException {
        return this.evaluate(expression, csf, null);
    }

    public Variable evaluate(String expression, CallStackFrame csf, ObjectVariable var) throws InvalidExpressionException {
        return this.evaluateGeneric(new EvaluatorExpression(expression), csf, var);
    }

    public void waitRunning() throws DebuggerStartException {
        this.waitRunning(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitRunning(long timeout) throws DebuggerStartException {
        Object object = this.LOCK2;
        synchronized (object) {
            int state = this.getState();
            if (state == 4) {
                if (this.throwable != null) {
                    throw new DebuggerStartException(this.throwable);
                }
                return true;
            }
            if (!this.starting && state > 1 || this.throwable != null) {
                return true;
            }
            try {
                logger.log(Level.FINE, "JPDADebuggerImpl.waitRunning(): starting = {0}, state = {1}, exception = {2}", new Object[]{this.starting, state, this.throwable});
                this.LOCK2.wait(timeout);
                if ((this.starting || state == 1) && this.throwable == null) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                throw new DebuggerStartException((Throwable)e);
            }
            if (this.throwable != null) {
                throw new DebuggerStartException(this.throwable);
            }
            return true;
        }
    }

    public DebuggerConsoleIO getConsoleIO() {
        return this.io;
    }

    public boolean canPopFrames() {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        return VirtualMachineWrapper.canPopFrames0(vm);
    }

    public boolean canFixClasses() {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        return VirtualMachineWrapper.canRedefineClasses0(vm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fixClasses(Map<String, byte[]> classes) {
        PropertyChangeEvent evt;
        block19: {
            evt = null;
            this.accessLock.writeLock().lock();
            try {
                CallStackFrame frame;
                CallStackFrame[] frames;
                JPDAThread t;
                block21: {
                    block20: {
                        HashMap<ReferenceType, byte[]> map = new HashMap<ReferenceType, byte[]>();
                        Iterator<Map.Entry<String, byte[]>> e = classes.entrySet().iterator();
                        VirtualMachine vm = this.getVirtualMachine();
                        if (vm == null) {
                            this.accessLock.writeLock().unlock();
                            return;
                        }
                        try {
                            while (e.hasNext()) {
                                Map.Entry<String, byte[]> classEntry = e.next();
                                String className = classEntry.getKey();
                                byte[] bytes = classEntry.getValue();
                                List<ReferenceType> classRefs = VirtualMachineWrapper.classesByName(vm, className);
                                int jj = classRefs.size();
                                for (int j = 0; j < jj; ++j) {
                                    map.put(classRefs.get(j), bytes);
                                }
                            }
                            VirtualMachineWrapper.redefineClasses(vm, map);
                        }
                        catch (InternalExceptionWrapper classEntry) {
                        }
                        catch (VMDisconnectedExceptionWrapper classEntry) {
                            // empty catch block
                        }
                        this.fixBreakpoints();
                        this.firePropertyChange("classesFixed", null, null);
                        t = this.getCurrentThread();
                        if (t == null || !t.isSuspended()) break block19;
                        if (t.getStackDepth() >= 2) break block20;
                        this.accessLock.writeLock().unlock();
                        return;
                    }
                    frames = t.getCallStack(0, 1);
                    if (frames.length != 0) break block21;
                    this.accessLock.writeLock().unlock();
                    return;
                }
                try {
                    frame = frames[0];
                }
                catch (AbsentInformationException ex) {
                    this.accessLock.writeLock().unlock();
                    return;
                }
                try {
                    if (frame.isObsolete() && ((CallStackFrameImpl)frame).canPop()) {
                        frame.popFrame();
                        this.setState(2);
                        evt = this.updateCurrentCallStackFrameNoFire(t);
                        this.setState(3);
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.accessLock.writeLock().unlock();
            }
        }
        if (evt == null) return;
        this.firePropertyChange(evt);
    }

    public void fixBreakpoints() {
        EditorContextBridge.getContext().disposeTimeStamp((Object)this);
        EditorContextBridge.getContext().createTimeStamp((Object)this);
        Session s = this.getSession();
        DebuggerEngine de = s.getEngineForLanguage("Java");
        if (de == null) {
            de = s.getCurrentEngine();
        }
        if (de != null) {
            BreakpointsEngineListener bel = null;
            List lazyListeners = de.lookup(null, LazyActionsManagerListener.class);
            for (int li = 0; li < lazyListeners.size(); ++li) {
                Object service = lazyListeners.get(li);
                if (!(service instanceof BreakpointsEngineListener)) continue;
                bel = (BreakpointsEngineListener)service;
                break;
            }
            if (bel != null) {
                bel.fixBreakpointImpls();
            }
        }
        this.expressionPool.clear();
    }

    public boolean getBreakpointsActive() {
        return this.breakpointsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreakpointsActive(boolean active) {
        JPDADebuggerImpl jPDADebuggerImpl = this;
        synchronized (jPDADebuggerImpl) {
            if (this.breakpointsActive == active) {
                return;
            }
            this.breakpointsActive = active;
        }
        this.firePropertyChange("breakpointsActive", !active, active);
    }

    public Session getSession() {
        return (Session)this.lookupProvider.lookupFirst(null, Session.class);
    }

    public RequestProcessor getRequestProcessor() {
        return this.javaEngineProvider.getRequestProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeModified() {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        Object object = this.canBeModifiedLock;
        synchronized (object) {
            if (this.canBeModified == null) {
                this.canBeModified = vm.canBeModified();
            }
            return this.canBeModified;
        }
    }

    public SmartSteppingFilter getSmartSteppingFilter() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilter;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    SmartSteppingCallback.StopOrStep stopHere(JPDAThread t, SmartSteppingFilter filter) {
        CallStackFrame topFrame = null;
        try {
            CallStackFrame[] topFrameArr = t.getCallStack(0, 1);
            if (topFrameArr.length > 0) {
                topFrame = topFrameArr[0];
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        if (topFrame != null) {
            return this.getCompoundSmartSteppingListener().stopAt(this.lookupProvider, topFrame, filter);
        }
        return this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, t, filter) ? SmartSteppingCallback.StopOrStep.stop() : SmartSteppingCallback.StopOrStep.skip();
    }

    public void fireBreakpointEvent(JPDABreakpoint breakpoint, JPDABreakpointEvent event) {
        super.fireBreakpointEvent(breakpoint, event);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(ThreadReference thread, StackFrame frame) {
        PropertyChangeEvent evt = null;
        this.accessLock.readLock().lock();
        try {
            JPDAThreadImpl threadImpl = this.getThread(thread);
            this.setState(2);
            try {
                threadImpl.popFrames(frame);
                evt = this.updateCurrentCallStackFrameNoFire(threadImpl);
            }
            catch (IncompatibleThreadStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.setState(3);
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        if (evt != null) {
            this.firePropertyChange(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Throwable t) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JPDADebuggerImpl.setException(" + t + ")");
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.throwable = t;
            this.starting = false;
            this.LOCK2.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentThread(JPDAThread thread) {
        PropertyChangeEvent event;
        JPDAThreadImpl oldT;
        CallStackFrame topFrame = this.getTopFrame(thread);
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            oldT = this.currentThread;
            this.currentThread = (JPDAThreadImpl)thread;
            event = this.updateCurrentCallStackFrameNoFire(topFrame);
        }
        this.checkJSR45Languages(thread);
        if (thread != oldT) {
            this.firePropertyChange("currentThread", oldT, thread);
        }
        if (event != null) {
            this.firePropertyChange(event);
        }
        this.setState(thread.isSuspended() ? 3 : 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeEvent setCurrentThreadNoFire(JPDAThread thread) {
        PropertyChangeEvent evt2;
        JPDAThreadImpl oldT;
        PropertyChangeEvent evt = null;
        CallStackFrame topFrame = this.getTopFrame(thread);
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            oldT = this.currentThread;
            this.currentThread = (JPDAThreadImpl)thread;
            evt2 = this.updateCurrentCallStackFrameNoFire(topFrame);
        }
        if (thread != oldT) {
            evt = new PropertyChangeEvent((Object)this, "currentThread", oldT, thread);
        }
        if (evt == null) {
            evt = evt2;
        } else if (evt2 != null) {
            evt.setPropagationId(evt2);
        }
        return evt;
    }

    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        CallStackFrame old = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (old == callStackFrame) {
            return;
        }
        if (callStackFrame != null) {
            this.checkJSR45Languages(callStackFrame);
        }
        this.firePropertyChange("currentCallStackFrame", old, callStackFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallStackFrame setCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame old;
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (callStackFrame == this.currentCallStackFrame) {
                return callStackFrame;
            }
            old = this.currentCallStackFrame;
            this.currentCallStackFrame = callStackFrame;
        }
        return old;
    }

    public Value evaluateIn(String expression) throws InvalidExpressionException {
        return this.evaluateIn(new EvaluatorExpression(expression), null);
    }

    public Value evaluateIn(EvaluatorExpression expression, CallStackFrame csf) throws InvalidExpressionException {
        return this.evaluateIn(expression, csf, null);
    }

    public Value evaluateIn(EvaluatorExpression expression, CallStackFrame csf, ObjectVariable var) throws InvalidExpressionException {
        Variable variable = this.evaluateGeneric(expression, csf, var);
        if (variable instanceof JDIVariable) {
            return ((JDIVariable)variable).getJDIValue();
        }
        return null;
    }

    public void setAltCSF(StackFrame sf) {
        this.altCSF = sf;
    }

    public StackFrame getAltCSF() {
        return this.altCSF;
    }

    public Value evaluateIn(EvaluatorExpression expression) throws InvalidExpressionException {
        return this.evaluateIn(expression, null, null);
    }

    /*
     * Exception decompiling
     */
    private Variable evaluateGeneric(EvaluatorExpression expression, CallStackFrame c, ObjectVariable var) throws InvalidExpressionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Value invokeMethod(ObjectReference reference, Method method, Value[] arguments) throws InvalidExpressionException {
        return this.invokeMethod(null, reference, null, method, arguments, 0, null);
    }

    public Value invokeMethod(ObjectReference reference, Method method, Value[] arguments, int maxLength) throws InvalidExpressionException {
        return this.invokeMethod(null, reference, null, method, arguments, maxLength, null);
    }

    public Value invokeMethod(JPDAThreadImpl thread, ObjectReference reference, Method method, Value[] arguments) throws InvalidExpressionException {
        return this.invokeMethod(thread, reference, method, arguments, null);
    }

    public Value invokeMethod(JPDAThreadImpl thread, ObjectReference reference, Method method, Value[] arguments, InvocationExceptionTranslated existingInvocationException) throws InvalidExpressionException {
        return this.invokeMethod(thread, reference, null, method, arguments, 0, existingInvocationException);
    }

    public Value invokeMethod(JPDAThreadImpl thread, ClassType classType, Method method, Value[] arguments) throws InvalidExpressionException {
        return this.invokeMethod(thread, null, classType, method, arguments, 0, null);
    }

    /*
     * Exception decompiling
     */
    private Value invokeMethod(JPDAThreadImpl thread, ObjectReference reference, ClassType classType, Method method, Value[] arguments, int maxLength, InvocationExceptionTranslated existingInvocationException) throws InvalidExpressionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value cutLength(StringReference sr, int maxLength, ThreadReference tr) throws InvalidExpressionException {
        block14: {
            try {
                Method subStringMethod;
                Method stringLengthMethod;
                Object object = this.stringMethodsLock;
                synchronized (object) {
                    stringLengthMethod = this.stringLengthMethod;
                    if (stringLengthMethod == null) {
                        this.stringLengthMethod = stringLengthMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(sr), "length", "()I");
                    }
                }
                List<Value> emptyArgs = Collections.emptyList();
                IntegerValue lengthValue = (IntegerValue)TreeEvaluator.invokeVirtual(sr, stringLengthMethod, tr, emptyArgs, this);
                if (IntegerValueWrapper.value(lengthValue) <= maxLength) break block14;
                Object object2 = this.stringMethodsLock;
                synchronized (object2) {
                    subStringMethod = this.stringSubstringMethod;
                    if (subStringMethod == null) {
                        this.stringSubstringMethod = subStringMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(sr), "substring", "(II)Ljava/lang/String;");
                    }
                }
                if (subStringMethod != null) {
                    sr = (StringReference)TreeEvaluator.invokeVirtual(sr, subStringMethod, tr, Arrays.asList(VirtualMachineWrapper.mirrorOf(MirrorWrapper.virtualMachine(sr), 0), VirtualMachineWrapper.mirrorOf(MirrorWrapper.virtualMachine(sr), maxLength)), this);
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                // empty catch block
            }
        }
        return sr;
    }

    public static String getGenericSignature(TypeComponent component) {
        try {
            return TypeComponentWrapper.genericSignature(component);
        }
        catch (InternalExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return null;
    }

    public static String getGenericSignature(LocalVariable component) {
        try {
            return LocalVariableWrapper.genericSignature(component);
        }
        catch (InternalExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine getVirtualMachine() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.virtualMachine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operator getOperator() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.operator;
        }
    }

    public void setStarting() {
        this.setState(1);
    }

    public synchronized void setAttaching(AbstractDICookie cookie) {
        this.attachingCookie = cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(VirtualMachine vm, Operator o) {
        ThreadsCache tc;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Start - JPDADebuggerImpl.setRunning ()");
            JPDAUtils.printFeatures(logger, vm);
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.starting = true;
        }
        object = this.virtualMachineLock;
        synchronized (object) {
            this.virtualMachine = vm;
            this.operator = o;
        }
        if (logger.isLoggable(Level.FINEST)) {
            this.ptd = new PeriodicThreadsDump(vm);
        }
        object = this.canBeModifiedLock;
        synchronized (object) {
            this.canBeModified = null;
        }
        EditorContextBridge.getContext().createTimeStamp((Object)this);
        Object object2 = this.threadsCollectorLock;
        synchronized (object2) {
            tc = this.threadsCache;
        }
        if (tc != null) {
            tc.setVirtualMachine(vm);
        }
        this.setState(2);
        object2 = this.virtualMachineLock;
        synchronized (object2) {
            vm = this.virtualMachine;
        }
        if (vm != null) {
            this.notifyToBeResumedAll();
            this.accessLock.writeLock().lock();
            try {
                VirtualMachineWrapper.resume(vm);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            finally {
                this.accessLock.writeLock().unlock();
            }
        }
        logger.fine("   JPDADebuggerImpl.setRunning () finished, VM resumed.");
        object2 = this.LOCK2;
        synchronized (object2) {
            this.starting = false;
            this.LOCK2.notifyAll();
        }
    }

    public void setStoppedState(ThreadReference thread, boolean stoppedAll) {
        this.setStoppedState(thread, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStoppedState(ThreadReference thread, boolean stoppedAll, boolean forceThreadSwitch) {
        JPDAThreadImpl t;
        PropertyChangeEvent evt;
        block12: {
            evt = null;
            this.accessLock.readLock().lock();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("setStoppedState(" + thread + ", " + stoppedAll + ", " + forceThreadSwitch + ")");
            }
            t = this.getThread(thread);
            if (forceThreadSwitch) break block12;
            JPDAThread c = this.getCurrentThread();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Have c = " + (c == null ? null : ((JPDAThreadImpl)c).getThreadStateLog()));
                logger.finer("Have t = " + (t == null ? null : t.getThreadStateLog()));
            }
            if (c == null || c == t || stoppedAll && !((JPDAThreadImpl)c).isSuspendedOnAnEvent() || !c.isSuspended()) break block12;
            evt = this.updateCurrentCallStackFrameNoFire(c);
            this.accessLock.readLock().unlock();
            if (evt == null) return;
            do {
                this.firePropertyChange(evt);
            } while ((evt = (PropertyChangeEvent)evt.getPropagationId()) != null);
            return;
        }
        try {
            logger.fine("  changing the current thread.");
            this.checkJSR45Languages(t);
            evt = this.setCurrentThreadNoFire(t);
            PropertyChangeEvent evt2 = this.setStateNoFire(3);
            if (evt == null) {
                evt = evt2;
            } else if (evt2 != null) {
                PropertyChangeEvent evt3 = evt;
                while (evt3.getPropagationId() != null) {
                    evt3 = (PropertyChangeEvent)evt3.getPropagationId();
                }
                evt3.setPropagationId(evt2);
            }
            this.accessLock.readLock().unlock();
            if (evt == null) return;
        }
        catch (Throwable throwable) {
            this.accessLock.readLock().unlock();
            if (evt == null) throw throwable;
            do {
                this.firePropertyChange(evt);
            } while ((evt = (PropertyChangeEvent)evt.getPropagationId()) != null);
            throw throwable;
        }
        do {
            this.firePropertyChange(evt);
        } while ((evt = (PropertyChangeEvent)evt.getPropagationId()) != null);
        return;
    }

    public void setRunningState() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedStateNoContinue(ThreadReference thread) {
        PropertyChangeEvent evt;
        this.accessLock.readLock().lock();
        try {
            evt = this.setStateNoFire(2);
            JPDAThreadImpl t = this.getThread(thread);
            this.checkJSR45Languages(t);
            PropertyChangeEvent evt2 = this.setCurrentThreadNoFire(t);
            if (evt == null) {
                evt = evt2;
            } else if (evt2 != null) {
                evt.setPropagationId(evt2);
            }
            evt2 = this.setStateNoFire(3);
            if (evt == null) {
                evt = evt2;
            } else if (evt2 != null) {
                PropertyChangeEvent evt3 = evt;
                while (evt3.getPropagationId() != null) {
                    evt3 = (PropertyChangeEvent)evt3.getPropagationId();
                }
                evt3.setPropagationId(evt2);
            }
            this.doContinue = false;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        if (evt != null) {
            do {
                this.firePropertyChange(evt);
            } while ((evt = (PropertyChangeEvent)evt.getPropagationId()) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            block36: {
                DebuggerEngine.Destructor d;
                VirtualMachine vm;
                JPDADebuggerImpl jPDADebuggerImpl = this;
                synchronized (jPDADebuggerImpl) {
                    block35: {
                        if (!this.finishing) break block35;
                        return;
                    }
                    this.finishing = true;
                }
                logger.fine("StartActionProvider.finish ()");
                if (this.getState() == 4) {
                    return;
                }
                AbstractDICookie di = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
                Operator o = this.getOperator();
                if (o != null) {
                    o.stop();
                }
                this.stopAttachListening();
                try {
                    boolean startedUp = this.waitRunning(500L);
                    if (!startedUp) {
                        this.stopAttachListening();
                    }
                }
                catch (DebuggerStartException startedUp) {
                    // empty catch block
                }
                Object object = this.virtualMachineLock;
                synchronized (object) {
                    vm = this.virtualMachine;
                    this.virtualMachine = null;
                }
                if (this.ptd != null) {
                    this.ptd.finish();
                }
                this.setState(4);
                if (this.jsr45EngineProviders != null) {
                    for (JSR45DebuggerEngineProvider provider : this.jsr45EngineProviders) {
                        DebuggerEngine.Destructor d2 = provider.getDesctuctor();
                        if (d2 == null) continue;
                        d2.killEngine();
                    }
                    this.jsr45EngineProviders = null;
                }
                if ((d = this.javaEngineProvider.getDestructor()) != null) {
                    d.killEngine();
                }
                if (vm != null) {
                    try {
                        if (di instanceof AttachingDICookie) {
                            JPDAThreadImpl t;
                            Object object2 = this.currentThreadAndFrameLock;
                            synchronized (object2) {
                                t = this.currentThread;
                            }
                            if (t != null && t.isMethodInvoking()) {
                                try {
                                    t.waitUntilMethodInvokeDone(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            logger.fine(" StartActionProvider.finish() VM dispose");
                            VirtualMachineWrapper.dispose(vm);
                            break block36;
                        }
                        logger.fine(" StartActionProvider.finish() VM exit");
                        VirtualMachineWrapper.exit(vm, 0);
                    }
                    catch (InternalExceptionWrapper e) {
                        logger.log(Level.FINE, " StartActionProvider.finish() VM exception {0}", e);
                    }
                    catch (VMDisconnectedExceptionWrapper e) {
                        logger.log(Level.FINE, " StartActionProvider.finish() VM exception {0}", e);
                    }
                }
            }
            logger.fine(" StartActionProvider.finish() end.");
            Object object = this.LOCK2;
            synchronized (object) {
                this.starting = false;
                this.LOCK2.notifyAll();
            }
            EditorContextBridge.getContext().disposeTimeStamp((Object)this);
        }
        finally {
            this.finishing = false;
        }
    }

    private synchronized void stopAttachListening() {
        if (this.attachingCookie != null && this.attachingCookie instanceof ListeningDICookie) {
            ListeningDICookie listeningCookie = (ListeningDICookie)this.attachingCookie;
            try {
                listeningCookie.getListeningConnector().stopListening(listeningCookie.getArgs());
            }
            catch (IOException iOException) {
            }
            catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public boolean isVMSuspended() {
        return this.vmSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        VirtualMachine vm;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            vm = this.virtualMachine;
        }
        this.accessLock.writeLock().lock();
        try {
            if (vm != null) {
                logger.fine("VM suspend");
                try {
                    VirtualMachineWrapper.suspend(vm);
                    this.vmSuspended = true;
                    List<ThreadReference> threads = VirtualMachineWrapper.allThreads(vm);
                    for (ThreadReference t : threads) {
                        try {
                            while (ThreadReferenceWrapper.suspendCount(t) > 1) {
                                ThreadReferenceWrapper.resume(t);
                            }
                            if (!ThreadReferenceWrapper.name(t).contains("org.netbeans.modules.debugger.jpda")) continue;
                            ThreadReferenceWrapper.resume(t);
                        }
                        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                        }
                        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {}
                    }
                }
                catch (VMDisconnectedExceptionWrapper e) {
                    this.accessLock.writeLock().unlock();
                    return;
                }
                catch (InternalExceptionWrapper e) {
                    this.accessLock.writeLock().unlock();
                    return;
                }
            }
            this.setState(3);
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        this.notifySuspendAll(true, true);
    }

    public List<PropertyChangeEvent> notifySuspendAll(boolean doFire, boolean explicitelyPaused) {
        return this.notifySuspendAll(doFire, explicitelyPaused, null);
    }

    public List<PropertyChangeEvent> notifySuspendAll(boolean doFire, boolean explicitelyPaused, Set<ThreadReference> ignoredThreads) {
        Collection threads = this.threadsTranslation.getTranslated();
        ArrayList<PropertyChangeEvent> events = new ArrayList<PropertyChangeEvent>(threads.size());
        for (Object threadOrGroup : threads) {
            boolean invalid;
            if (!(threadOrGroup instanceof JPDAThreadImpl) || ignoredThreads != null && ignoredThreads.contains(((JPDAThreadImpl)threadOrGroup).getThreadReference())) continue;
            int status = ((JPDAThreadImpl)threadOrGroup).getState();
            boolean bl = invalid = status == 5 || status == -1 || status == 0;
            if (!invalid) {
                try {
                    PropertyChangeEvent event = ((JPDAThreadImpl)threadOrGroup).notifySuspended(doFire, explicitelyPaused);
                    if (event == null) continue;
                    events.add(event);
                }
                catch (ObjectCollectedException ocex) {
                    invalid = true;
                }
                continue;
            }
            if (status != -1 && status != 0) continue;
            this.threadsTranslation.remove(((JPDAThreadImpl)threadOrGroup).getThreadReference());
        }
        return events;
    }

    public void notifySuspendAllNoFire() {
        this.notifySuspendAllNoFire(null, null);
    }

    public void notifySuspendAllNoFire(Set<ThreadReference> ignoredThreads, ThreadReference eventThread) {
        Collection threads = this.threadsTranslation.getTranslated();
        for (Object threadOrGroup : threads) {
            boolean invalid;
            if (!(threadOrGroup instanceof JPDAThreadImpl)) continue;
            JPDAThreadImpl thread = (JPDAThreadImpl)threadOrGroup;
            ThreadReference tr = thread.getThreadReference();
            if (ignoredThreads != null && ignoredThreads.contains(tr)) continue;
            int status = thread.getState();
            boolean bl = invalid = status == 5 || status == -1 || status == 0;
            if (!invalid) {
                try {
                    thread.notifySuspendedNoFire(tr == eventThread, false);
                }
                catch (ObjectCollectedException ocex) {
                    invalid = true;
                }
                continue;
            }
            if (status != -1 && status != 0) continue;
            this.threadsTranslation.remove(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        VirtualMachine vm;
        try {
            this.getOperator().waitForParallelEventsToProcess();
        }
        catch (InterruptedException iex) {
            return;
        }
        this.accessLock.readLock().lock();
        try {
            if (!this.doContinue) {
                this.doContinue = true;
                return;
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        Object object = this.virtualMachineLock;
        synchronized (object) {
            vm = this.virtualMachine;
        }
        if (vm != null) {
            logger.fine("VM resume");
            List<JPDAThread> allThreads = this.getAllThreads(true);
            this.accessLock.writeLock().lock();
            logger.finer("Debugger WRITE lock taken.");
            PropertyChangeEvent stateChangeEvent = this.setStateNoFire(2);
            ArrayList<JPDAThreadImpl> threadsToResume = null;
            try {
                boolean modifiableAllThreads = false;
                int n = allThreads.size();
                for (int i = 0; i < n; ++i) {
                    JPDAThread t = allThreads.get(i);
                    int status = t.getState();
                    if (status != 0 && status != -1 && (!t.getName().contains("org.netbeans.modules.debugger.jpda") || t.isSuspended())) continue;
                    if (!modifiableAllThreads) {
                        allThreads = new ArrayList<JPDAThread>(allThreads);
                        modifiableAllThreads = true;
                    }
                    allThreads.remove(i);
                    --n;
                    --i;
                }
                threadsToResume = new ArrayList<JPDAThreadImpl>();
                for (JPDAThread t : allThreads) {
                    if (!t.isSuspended() && ((JPDAThreadImpl)t).getThreadReference().suspendCount() <= 0) continue;
                    threadsToResume.add((JPDAThreadImpl)t);
                }
                for (int i = 0; i < threadsToResume.size(); ++i) {
                    JPDAThreadImpl t = (JPDAThreadImpl)threadsToResume.get(i);
                    boolean can = t.cleanBeforeResume();
                    if (can) continue;
                    threadsToResume.remove(i);
                    --i;
                }
                if (this.vmSuspended || allThreads.size() == threadsToResume.size()) {
                    for (JPDAThreadImpl t : threadsToResume) {
                        t.setAsResumed(false);
                        t.reduceThreadSuspendCount();
                    }
                    this.reduceThreadSuspendCountOfAllBut(vm, threadsToResume);
                    VirtualMachineWrapper.resume(vm);
                    this.vmSuspended = false;
                    logger.finer("All VM threads resumed.");
                } else {
                    logger.finer("Resuming selected suspended threads.");
                    for (JPDAThreadImpl t : threadsToResume) {
                        t.setAsResumed(false);
                        t.resumeAfterClean();
                    }
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                logger.finer("Debugger WRITE lock released.");
                if (stateChangeEvent != null) {
                    this.firePropertyChange(stateChangeEvent);
                }
                if (threadsToResume != null) {
                    for (JPDAThreadImpl t : threadsToResume) {
                        try {
                            t.fireAfterResume();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable th) {
                            Exceptions.printStackTrace((Throwable)th);
                        }
                    }
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                logger.finer("Debugger WRITE lock released.");
                if (stateChangeEvent != null) {
                    this.firePropertyChange(stateChangeEvent);
                }
                if (threadsToResume != null) {
                    for (JPDAThreadImpl t : threadsToResume) {
                        try {
                            t.fireAfterResume();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable th) {
                            Exceptions.printStackTrace((Throwable)th);
                        }
                    }
                }
            }
            finally {
                this.accessLock.writeLock().unlock();
                logger.finer("Debugger WRITE lock released.");
                if (stateChangeEvent != null) {
                    this.firePropertyChange(stateChangeEvent);
                }
                if (threadsToResume != null) {
                    for (JPDAThreadImpl t : threadsToResume) {
                        try {
                            t.fireAfterResume();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable th) {
                            Exceptions.printStackTrace((Throwable)th);
                        }
                    }
                }
            }
        }
    }

    private void reduceThreadSuspendCountOfAllBut(VirtualMachine vm, List<JPDAThreadImpl> threadsToIgnore) {
        List<ThreadReference> allThreads = VirtualMachineWrapper.allThreads0(vm);
        if (allThreads.size() == threadsToIgnore.size()) {
            return;
        }
        HashSet<Long> ignoredIDs = new HashSet<Long>(threadsToIgnore.size());
        for (JPDAThreadImpl jPDAThreadImpl : threadsToIgnore) {
            ignoredIDs.add(jPDAThreadImpl.getThreadReference().uniqueID());
        }
        for (ThreadReference threadReference : allThreads) {
            if (ignoredIDs.contains(threadReference.uniqueID())) continue;
            try {
                for (int count = ThreadReferenceWrapper.suspendCount(threadReference); count > 1; --count) {
                    ThreadReferenceWrapper.resume(threadReference);
                }
            }
            catch (IllegalThreadStateExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
        }
    }

    public boolean currentThreadToBeResumed() {
        this.accessLock.readLock().lock();
        try {
            if (!this.doContinue) {
                this.doContinue = true;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        this.setState(2);
        return true;
    }

    public void resumeCurrentThread() {
        this.accessLock.readLock().lock();
        try {
            if (!this.doContinue) {
                this.doContinue = true;
                return;
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        this.setState(2);
        this.currentThread.resume();
    }

    public void notifyToBeResumedAll() {
        List<JPDAThreadImpl> threads = this.threadsTranslation.getTranslated(o -> o instanceof JPDAThreadImpl ? (JPDAThreadImpl)o : null);
        int n = threads.size();
        if (n > 0) {
            this.processInParallel(n, i -> {
                boolean invalid;
                JPDAThreadImpl thread = (JPDAThreadImpl)threads.get((int)i);
                int status = thread.getState();
                boolean bl = invalid = status == 5 || status == -1 || status == 0;
                if (!invalid) {
                    thread.notifyToBeResumed();
                } else if (status == -1 || status == 0) {
                    this.threadsTranslation.remove(thread.getThreadReference());
                }
            });
        }
    }

    public void notifyToBeResumedAllNoFire() {
        this.notifyToBeResumedAllNoFire(null);
    }

    public void notifyToBeResumedAllNoFire(Set<ThreadReference> ignoredThreads) {
        List<JPDAThreadImpl> threads = this.threadsTranslation.getTranslated(o -> o instanceof JPDAThreadImpl && (ignoredThreads == null || !ignoredThreads.contains(o)) ? (JPDAThreadImpl)o : null);
        for (JPDAThreadImpl thread : threads) {
            boolean invalid;
            int status = thread.getState();
            boolean bl = invalid = status == 5 || status == -1 || status == 0;
            if (!invalid) {
                thread.notifyToBeResumedNoFire();
                continue;
            }
            if (status != -1 && status != 0) continue;
            this.threadsTranslation.remove(thread.getThreadReference());
        }
    }

    public void setCurrentSuspendedNoFireThread(JPDAThreadImpl thread) {
        this.currentSuspendedNoFireThread = thread;
    }

    public void interestedInThreadGroup(JPDAThreadGroup tg) {
        this.interestedThreadGroups.add(tg);
    }

    public boolean isInterestedInThreadGroups() {
        return !this.interestedThreadGroups.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCache getThreadsCache() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCache == null) {
                this.threadsCache = new ThreadsCache(this);
                this.threadsCache.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        JPDADebuggerImpl.this.rpCreateThreads.post(() -> {
                            JPDAThreadImpl thread;
                            String propertyName = evt.getPropertyName();
                            if ("threadStarted".equals(propertyName) && !(thread = JPDADebuggerImpl.this.getThread((ThreadReference)evt.getNewValue())).getName().contains("org.netbeans.modules.debugger.jpda")) {
                                JPDADebuggerImpl.this.firePropertyChange("threadStarted", null, thread);
                            }
                            if ("threadDied".equals(propertyName) && !(thread = JPDADebuggerImpl.this.getThread((ThreadReference)evt.getOldValue())).getName().contains("org.netbeans.modules.debugger.jpda")) {
                                JPDADebuggerImpl.this.firePropertyChange("threadDied", thread, null);
                            }
                            if ("groupAdded".equals(propertyName)) {
                                JPDADebuggerImpl.this.firePropertyChange("threadGroupAdded", null, JPDADebuggerImpl.this.getThreadGroup((ThreadGroupReference)evt.getNewValue()));
                            }
                        });
                    }
                });
            }
            return this.threadsCache;
        }
    }

    List<JPDAThread> getAllThreads() {
        return this.getAllThreads(false);
    }

    List<JPDAThread> getAllThreads(boolean findNewBornThreads) {
        ThreadsCache tc = this.getThreadsCache();
        if (tc == null) {
            return Collections.emptyList();
        }
        List<ThreadReference> threadList = tc.getAllThreads();
        if (findNewBornThreads) {
            HashSet<Long> threadIDs = new HashSet<Long>(threadList.size());
            for (ThreadReference t : threadList) {
                threadIDs.add(t.uniqueID());
            }
            List<ThreadReference> allThreads = VirtualMachineWrapper.allThreads0(this.virtualMachine);
            boolean added = false;
            for (ThreadReference t : allThreads) {
                if (threadIDs.contains(t.uniqueID())) continue;
                if (!added) {
                    threadList = new ArrayList<ThreadReference>(threadList);
                    added = true;
                }
                threadList.add(t);
            }
        }
        int n = threadList.size();
        List<ThreadReference> tl = threadList;
        JPDAThread[] threads = new JPDAThread[n];
        if (n > 0) {
            this.processInParallel(n, i -> {
                JPDAThreadImpl thread = this.getThread((ThreadReference)tl.get((int)i));
                threads[i.intValue()] = !thread.getName().contains("org.netbeans.modules.debugger.jpda") ? thread : null;
            });
            ArrayList<JPDAThread> threadsFiltered = new ArrayList<JPDAThread>(n);
            for (JPDAThread t : threads) {
                if (t == null) continue;
                threadsFiltered.add(t);
            }
            return Collections.unmodifiableList(threadsFiltered);
        }
        return Collections.emptyList();
    }

    private void processInParallel(final int n, final Consumer<Integer> task) {
        int ch;
        int chunks = Math.min(10, n);
        final int chn = n / chunks + (n % chunks > 0 ? 1 : 0);
        RequestProcessor.Task[] tasks = new RequestProcessor.Task[chunks];
        for (ch = 0; ch < chunks; ++ch) {
            class TranslateThreads
            implements Runnable {
                private final int ch;

                TranslateThreads(int ch) {
                    this.ch = ch;
                }

                @Override
                public void run() {
                    int i0;
                    for (int i = i0 = this.ch * chn; i < i0 + chn && i < n; ++i) {
                        task.accept(i);
                    }
                }
            }
            tasks[ch] = this.rpCreateThreads.post((Runnable)new TranslateThreads(ch));
        }
        for (ch = 0; ch < chunks; ++ch) {
            tasks[ch].waitFinished();
        }
    }

    public JPDAThreadGroup[] getTopLevelThreadGroups() {
        ThreadsCache tc = this.getThreadsCache();
        if (tc == null) {
            return new JPDAThreadGroup[0];
        }
        List<ThreadGroupReference> groupList = tc.getTopLevelThreadGroups();
        JPDAThreadGroup[] groups = new JPDAThreadGroup[groupList.size()];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = this.getThreadGroup(groupList.get(i));
        }
        return groups;
    }

    public JPDAThreadImpl getThread(ThreadReference tr) {
        return (JPDAThreadImpl)this.threadsTranslation.translate(tr);
    }

    public JPDAThreadImpl getExistingThread(ThreadReference tr) {
        return (JPDAThreadImpl)this.threadsTranslation.translateExisting(tr);
    }

    public JPDAThreadGroup getThreadGroup(ThreadGroupReference tgr) {
        return (JPDAThreadGroup)this.threadsTranslation.translate(tgr);
    }

    public Variable getLocalVariable(JPDAThread thread, LocalVariable lv, Value v) {
        return (Variable)this.localsTranslation.translateOnThread(thread, lv, v);
    }

    public JPDAClassType getClassType(ReferenceType cr) {
        return (JPDAClassType)this.localsTranslation.translate(cr);
    }

    public Variable getVariable(Value value) {
        if (value instanceof ClassObjectReference) {
            return new ClassVariableImpl(this, (ClassObjectReference)value, null);
        }
        return this.createVariable(value);
    }

    private Variable createVariable(Value v) {
        if (v instanceof ObjectReference || v == null) {
            return new AbstractObjectVariable(this, (ObjectReference)v, null);
        }
        return new AbstractVariable(this, v, null);
    }

    public Variable createMirrorVar(Object obj, boolean isPrimitive) throws InvalidObjectException {
        Variable v;
        if (obj == null) {
            return null;
        }
        try {
            v = this.getVariable(VariableMirrorTranslator.createValueFromMirror(obj, !isPrimitive, this));
        }
        catch (IllegalArgumentExceptionWrapper ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (InternalExceptionWrapper ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (InvalidTypeException ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (ClassNotLoadedException ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        if (v == null) {
            throw new InvalidObjectException("No target value from " + obj);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markObject(ObjectVariable var, String label) {
        Map<Long, String> map = this.markedObjects;
        synchronized (map) {
            long uid = var.getUniqueID();
            String oldLabel = this.markedObjects.remove(uid);
            if (oldLabel != null) {
                this.markedObjectLabels.remove(oldLabel);
            }
            if (label != null) {
                this.markedObjects.put(uid, label);
                ObjectVariable markedVar = this.markedObjectLabels.get(label);
                if (markedVar != null) {
                    this.markedObjects.remove(markedVar.getUniqueID());
                }
                this.markedObjectLabels.put(label, var);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(ObjectVariable var) {
        if (var instanceof Refreshable && !((Refreshable)var).isCurrent()) {
            return null;
        }
        Map<Long, String> map = this.markedObjects;
        synchronized (map) {
            return this.markedObjects.get(var.getUniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVariable getLabeledVariable(String label) {
        Map<Long, String> map = this.markedObjects;
        synchronized (map) {
            return this.markedObjectLabels.get(label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ObjectVariable> getAllLabels() {
        Map<Long, String> map = this.markedObjects;
        synchronized (map) {
            return new HashMap<String, ObjectVariable>(this.markedObjectLabels);
        }
    }

    public ExpressionPool getExpressionPool() {
        return this.expressionPool;
    }

    synchronized void setSingleThreadStepResumeDecision(Boolean decision) {
        this.singleThreadStepResumeDecision = decision;
    }

    synchronized Boolean getSingleThreadStepResumeDecision() {
        return this.singleThreadStepResumeDecision;
    }

    public synchronized void setStepInterruptByBptResumeDecision(Boolean decision) {
        this.stepInterruptByBptResumeDecision = decision;
    }

    public synchronized Boolean getStepInterruptByBptResumeDecision() {
        return this.stepInterruptByBptResumeDecision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeEvent setStateNoFire(int state) {
        int o;
        Object object = this.stateLock;
        synchronized (object) {
            if (state == this.state) {
                return null;
            }
            o = this.state;
            this.state = state;
        }
        System.setProperty("org.openide.awt.SwingBrowserImpl.do-not-block-awt", String.valueOf(state != 4));
        return new PropertyChangeEvent((Object)this, "state", o, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        PropertyChangeEvent evt;
        if (state == 2) {
            CallStackFrame old;
            Object object = this.currentThreadAndFrameLock;
            synchronized (object) {
                old = this.currentCallStackFrame;
                this.currentCallStackFrame = null;
            }
            this.firePropertyChange("currentCallStackFrame", old, null);
        }
        if ((evt = this.setStateNoFire(state)) != null) {
            this.firePropertyChange(evt);
        }
    }

    private void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    public synchronized SourcePath getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)this.lookupProvider.lookupFirst(null, SourcePath.class);
        }
        return this.engineContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadReference getEvaluationThread() {
        List<ThreadReference> l;
        VirtualMachine vm;
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (this.currentThread != null) {
                return this.currentThread.getThreadReference();
            }
        }
        Object object2 = this.virtualMachineLock;
        synchronized (object2) {
            vm = this.virtualMachine;
        }
        if (vm == null) {
            return null;
        }
        try {
            l = VirtualMachineWrapper.allThreads(vm);
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        if (l.size() < 1) {
            return null;
        }
        int k = l.size();
        ThreadReference thread = null;
        for (int i = 0; i < k; ++i) {
            ThreadReference t = l.get(i);
            try {
                if (!ThreadReferenceWrapper.isSuspended(t)) continue;
                thread = t;
                if (!ThreadReferenceWrapper.name(t).equals("Finalizer")) continue;
                return t;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                continue;
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                continue;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
        }
        return thread;
    }

    private PropertyChangeEvent updateCurrentCallStackFrameNoFire(JPDAThread thread) {
        CallStackFrame newSF;
        if (thread == null || thread.getStackDepth() < 1) {
            newSF = null;
        } else {
            try {
                CallStackFrame[] csfs = thread.getCallStack(0, 1);
                newSF = csfs.length > 0 ? csfs[0] : null;
            }
            catch (AbsentInformationException e) {
                newSF = null;
            }
        }
        CallStackFrame oldSF = this.setCurrentCallStackFrameNoFire(newSF);
        if (oldSF == newSF) {
            return null;
        }
        return new PropertyChangeEvent((Object)this, "currentCallStackFrame", oldSF, newSF);
    }

    public void setPreferredTopFrame(CallStackFrame preferredTopFrame) {
        this.preferredTopFrame = preferredTopFrame;
    }

    private CallStackFrame getTopFrame(JPDAThread thread) {
        CallStackFrame callStackFrame;
        if (this.preferredTopFrame != null) {
            CallStackFrame callStackFrame2 = this.preferredTopFrame;
            this.preferredTopFrame = null;
            return callStackFrame2;
        }
        if (thread == null || thread.getStackDepth() < 1) {
            callStackFrame = null;
        } else {
            try {
                CallStackFrame[] csfs = thread.getCallStack(0, 1);
                callStackFrame = csfs.length > 0 ? csfs[0] : null;
            }
            catch (AbsentInformationException e) {
                callStackFrame = null;
            }
        }
        return callStackFrame;
    }

    private PropertyChangeEvent updateCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame old = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (old == callStackFrame) {
            return null;
        }
        return new PropertyChangeEvent((Object)this, "currentCallStackFrame", old, callStackFrame);
    }

    private void checkJSR45Languages(JPDAThread t) {
        if (t.getStackDepth() > 0) {
            try {
                CallStackFrame[] frames = t.getCallStack(0, 1);
                if (frames.length < 1) {
                    return;
                }
                this.checkJSR45Languages(frames[0]);
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
    }

    private void checkJSR45Languages(CallStackFrame f) {
        List l = f.getAvailableStrata();
        String stratum = f.getDefaultStratum();
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            if (this.languages.contains(l.get(i))) continue;
            String language = (String)l.get(i);
            DebuggerManager.getDebuggerManager().startDebugging(this.createJSR45DI(language));
            this.languages.add(language);
        }
        if (stratum != null) {
            this.javaEngineProvider.getSession().setCurrentLanguage(stratum);
        }
    }

    private DebuggerInfo createJSR45DI(String language) {
        if (this.jsr45EngineProviders == null) {
            this.jsr45EngineProviders = new HashSet<JSR45DebuggerEngineProvider>(1);
        }
        JSR45DebuggerEngineProvider provider = new JSR45DebuggerEngineProvider(language, this.getRequestProcessor());
        this.jsr45EngineProviders.add(provider);
        return DebuggerInfo.create((String)("netbeans-jpda-JSR45DICookie-" + language), (Object[])new Object[]{new DelegatingSessionProvider(){

            public Session getSession(DebuggerInfo debuggerInfo) {
                return JPDADebuggerImpl.this.javaEngineProvider.getSession();
            }
        }, provider});
    }

    public JPDAStep createJPDAStep(int size, int depth) {
        Session session = (Session)this.lookupProvider.lookupFirst(null, Session.class);
        return new JPDAStepImpl(this, session, size, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAClassType> getAllClasses() {
        List<Object> classes;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            classes = this.virtualMachine == null ? Collections.emptyList() : VirtualMachineWrapper.allClasses0(this.virtualMachine);
        }
        return new ClassTypeList(this, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAClassType> getClassesByName(String name) {
        List<Object> classes;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            classes = this.virtualMachine == null ? Collections.emptyList() : VirtualMachineWrapper.classesByName0(this.virtualMachine, name);
        }
        return new ClassTypeList(this, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getInstanceCounts(List<JPDAClassType> classTypes) throws UnsupportedOperationException {
        List<ReferenceType> types;
        VirtualMachine vm;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            vm = this.virtualMachine;
        }
        if (vm == null) {
            return new long[classTypes.size()];
        }
        if (classTypes instanceof ClassTypeList) {
            ClassTypeList cl = (ClassTypeList)classTypes;
            types = cl.getTypes();
        } else {
            types = new ArrayList<ReferenceType>(classTypes.size());
            for (JPDAClassType clazz : classTypes) {
                types.add(((JPDAClassTypeImpl)clazz).getType());
            }
        }
        try {
            return VirtualMachineWrapper.instanceCounts(vm, types);
        }
        catch (InternalExceptionWrapper e) {
            return new long[classTypes.size()];
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return new long[classTypes.size()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGetInstanceInfo() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.virtualMachine != null && this.virtualMachine.canGetInstanceInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCollectorImpl getThreadsCollector() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCollector == null) {
                this.threadsCollector = new ThreadsCollectorImpl(this);
            }
            return this.threadsCollector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeadlockDetector getDeadlockDetector() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.deadlockDetector == null) {
                this.deadlockDetector = new DeadlockDetectorImpl(this);
            }
            return this.deadlockDetector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAClassType> getAllInterfaces(ClassType ct) {
        try {
            ArrayList<String> allInterfaces;
            boolean toCompute = false;
            Object object = this.allInterfacesMap;
            synchronized (object) {
                allInterfaces = this.allInterfacesMap.get(ct);
                if (allInterfaces == null) {
                    allInterfaces = new ArrayList<String>();
                    allInterfaces.add(COMPUTING_INTERFACES);
                    this.allInterfacesMap.put(ct, allInterfaces);
                    toCompute = true;
                }
            }
            if (toCompute) {
                List<InterfaceType> interfaces = null;
                try {
                    interfaces = ClassTypeWrapper.allInterfaces0(ct);
                }
                finally {
                    Object object2;
                    if (interfaces == null) {
                        object2 = this.allInterfacesMap;
                        synchronized (object2) {
                            this.allInterfacesMap.remove(ct);
                        }
                    }
                    object2 = allInterfaces;
                    synchronized (object2) {
                        allInterfaces.clear();
                        if (interfaces != null) {
                            for (InterfaceType it : interfaces) {
                                allInterfaces.add((String)this.getClassType(it));
                            }
                        }
                        allInterfaces.notifyAll();
                    }
                }
            }
            object = allInterfaces;
            synchronized (object) {
                if (allInterfaces.contains(COMPUTING_INTERFACES)) {
                    try {
                        allInterfaces.wait();
                    }
                    catch (InterruptedException ex) {
                        return null;
                    }
                }
            }
            if (allInterfaces.contains(COMPUTING_INTERFACES)) {
                assert (!allInterfaces.contains(COMPUTING_INTERFACES));
                return null;
            }
            return Collections.unmodifiableList(allInterfaces);
        }
        catch (ClassNotPreparedExceptionWrapper cnpex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAllInterfaces(ClassType ct) {
        List allInterfaces;
        Object object = this.allInterfacesMap;
        synchronized (object) {
            allInterfaces = this.allInterfacesMap.get(ct);
        }
        if (allInterfaces == null) {
            return false;
        }
        object = allInterfaces;
        synchronized (object) {
            if (allInterfaces.contains(COMPUTING_INTERFACES)) {
                return false;
            }
        }
        return true;
    }

    public Variable getFormattedValue(ObjectVariable ov) {
        return this.getFormattedValue(ov, new FormattersLoopControl());
    }

    private Variable getFormattedValue(ObjectVariable ov, FormattersLoopControl formattersLoopControl) {
        String code;
        JPDAClassType ct = ov.getClassType();
        if (ct == null) {
            return ov;
        }
        VariablesFormatter f = Formatters.getFormatterForType(ct, formattersLoopControl.getFormatters());
        if (f != null && formattersLoopControl.canUse(f, ct.getName(), null) && (code = f.getValueFormatCode()) != null && code.length() > 0) {
            try {
                Variable ret = ((AbstractObjectVariable)ov).evaluate(code);
                if (ret == null) {
                    return null;
                }
                if (ret instanceof ObjectVariable) {
                    return this.getFormattedValue((ObjectVariable)ret, formattersLoopControl);
                }
                return ret;
            }
            catch (InvalidExpressionException invalidExpressionException) {
                // empty catch block
            }
        }
        return ov;
    }

    public void actionMessageCallback(Object action, String message) {
        List amcList = this.lookupProvider.lookup(null, ActionMessageCallback.class);
        for (ActionMessageCallback amc : amcList) {
            amc.messageCallback(action, message);
        }
    }

    public void actionErrorMessageCallback(Object action, String message) {
        List amcList = this.lookupProvider.lookup(null, ActionErrorMessageCallback.class);
        for (ActionErrorMessageCallback amc : amcList) {
            amc.errorMessageCallback(action, message);
        }
    }

    public void actionStatusDisplayCallback(Object action, String status) {
        List asdcList = this.lookupProvider.lookup(null, ActionStatusDisplayCallback.class);
        for (ActionStatusDisplayCallback asdc : asdcList) {
            asdc.statusDisplayCallback(action, status);
        }
    }

    private static class DebuggerReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        private ReentrantReadWriteLock.ReadLock readerLock = new DebuggerReadLock(this);
        private ReentrantReadWriteLock.WriteLock writerLock = new DebuggerWriteLock(this);

        public DebuggerReentrantReadWriteLock(boolean fair) {
            super(fair);
        }

        @Override
        public ReentrantReadWriteLock.ReadLock readLock() {
            return this.readerLock;
        }

        @Override
        public ReentrantReadWriteLock.WriteLock writeLock() {
            return this.writerLock;
        }

        private static class DebuggerReadLock
        extends ReentrantReadWriteLock.ReadLock {
            protected DebuggerReadLock(ReentrantReadWriteLock lock) {
                super(lock);
            }

            @Override
            public void lock() {
                assert (!Mutex.EVENT.isReadAccess()) : "Debugger lock taken in AWT Event Queue!";
                super.lock();
            }
        }

        private static class DebuggerWriteLock
        extends ReentrantReadWriteLock.WriteLock {
            protected DebuggerWriteLock(ReentrantReadWriteLock lock) {
                super(lock);
            }

            @Override
            public void lock() {
                assert (!Mutex.EVENT.isReadAccess()) : "Debugger lock taken in AWT Event Queue!";
                super.lock();
            }
        }
    }

    private static class PeriodicThreadsDump
    implements Runnable {
        private static final int INTERVAL = 5000;
        private RequestProcessor rp = new RequestProcessor(PeriodicThreadsDump.class.getName());
        private VirtualMachine vm;
        private volatile boolean finish = false;

        public PeriodicThreadsDump(VirtualMachine vm) {
            this.vm = vm;
            this.rp.post((Runnable)this, 5000);
        }

        public void finish() {
            this.finish = true;
        }

        @Override
        public void run() {
            List<ThreadReference> allThreads = this.vm.allThreads();
            System.err.println("All Threads:");
            for (ThreadReference tr : allThreads) {
                String name = tr.name();
                boolean suspended = tr.isSuspended();
                int suspendCount = tr.suspendCount();
                int status = tr.status();
                System.err.println(name + "\t SUSP = " + suspended + ", COUNT = " + suspendCount + ", STATUS = " + status);
            }
            System.err.println("");
            if (!this.finish) {
                this.rp.post((Runnable)this, 5000);
            }
        }
    }
}

