/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Roles {
    public static void doRoles(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT ROLEID, GRANTEE, GRANTOR, WITHADMINOPTION FROM SYS.SYSROLES WHERE ISDEF = 'Y'");
        DB_Roles.generateRoleDefinitions(rs);
        rs.close();
        rs = stmt.executeQuery("SELECT ROLEID, GRANTEE, GRANTOR, WITHADMINOPTION FROM SYS.SYSROLES WHERE ISDEF = 'N'");
        DB_Roles.generateRoleGrants(rs);
        rs.close();
        stmt.close();
    }

    private static void generateRoleDefinitions(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_Role_definitions_header");
                Logs.reportString("----------------------------------------------\n");
            }
            String roleName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            Logs.writeToNewDDL(DB_Roles.roleDefinitionStatement(rs, roleName));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static String roleDefinitionStatement(ResultSet rs, String roleName) throws SQLException {
        StringBuffer createStmt = new StringBuffer("CREATE ROLE ");
        createStmt.append(roleName);
        return createStmt.toString();
    }

    private static void generateRoleGrants(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            if (firstTime) {
                firstTime = false;
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_Role_grants_header");
                Logs.reportString("----------------------------------------------\n");
            }
            String roleName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String grantee = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            String grantor = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(3)));
            boolean isWithAdminOption = rs.getString(4).equals("Y");
            Logs.writeToNewDDL(DB_Roles.roleGrantStatement(rs, roleName, grantee, isWithAdminOption));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
        }
    }

    private static String roleGrantStatement(ResultSet rs, String roleName, String grantee, boolean isWithAdminOption) throws SQLException {
        StringBuffer createStmt = new StringBuffer("GRANT ");
        createStmt.append(roleName);
        createStmt.append(" TO ");
        createStmt.append(grantee);
        if (isWithAdminOption) {
            createStmt.append(" WITH ADMIN OPTION");
        }
        return createStmt.toString();
    }
}

