/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.shared.common.error.StandardException;

class SetRoleConstantAction
implements ConstantAction {
    private final String roleName;
    private final int type;

    SetRoleConstantAction(String roleName, int type) {
        this.roleName = roleName;
        this.type = type;
    }

    public String toString() {
        return "SET ROLE " + (this.type == 1 && this.roleName == null ? "?" : this.roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String thisRoleName = this.roleName;
        String currentAuthId = lcc.getCurrentUserId(activation);
        String dbo = lcc.getDataDictionary().getAuthorizationDatabaseOwner();
        TransactionController tc = lcc.getTransactionExecute();
        if (!tc.isIdle()) {
            throw StandardException.newException((String)"25001.S.1", (Object[])new Object[0]);
        }
        if (this.type == 1) {
            ParameterValueSet pvs = activation.getParameterValueSet();
            DataValueDescriptor dvs = pvs.getParameter(0);
            String roleId = dvs.getString();
            if (roleId == null) {
                throw StandardException.newException((String)"XCXA0.S", (Object[])new Object[0]);
            }
            thisRoleName = IdUtil.parseRoleId(roleId);
        }
        RoleGrantDescriptor rdDef = null;
        try {
            String oldRole = lcc.getCurrentRoleId(activation);
            if (oldRole != null && !oldRole.equals(thisRoleName) && (rdDef = dd.getRoleDefinitionDescriptor(oldRole)) != null) {
                dd.getDependencyManager().invalidateFor(rdDef, 48, lcc);
            }
            if (thisRoleName != null) {
                rdDef = dd.getRoleDefinitionDescriptor(thisRoleName);
                if (rdDef == null) {
                    throw StandardException.newException((String)"0P000", (Object[])new Object[]{thisRoleName});
                }
                if (!lcc.roleIsSettable(activation, thisRoleName)) {
                    throw StandardException.newException((String)"0P000.S.1", (Object[])new Object[]{thisRoleName});
                }
            }
        }
        finally {
            lcc.userCommit();
        }
        lcc.setCurrentRole(activation, rdDef != null ? thisRoleName : null);
    }
}

