/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

public class DUPL
extends Protocol {
    @Property(description="Number of copies of each incoming message (0=no copies)")
    protected int incoming_copies = 1;
    @Property(description="Number of copies of each outgoing message (0=no copies)")
    protected int outgoing_copies = 1;
    @Property(description="Whether or not to copy unicast messages")
    protected boolean copy_unicast_msgs = true;
    @Property(description="Whether or not to copy multicast messages")
    protected boolean copy_multicast_msgs = true;

    public DUPL() {
    }

    public DUPL(boolean copy_multicast_msgs, boolean copy_unicast_msgs, int incoming_copies, int outgoing_copies) {
        this.copy_multicast_msgs = copy_multicast_msgs;
        this.copy_unicast_msgs = copy_unicast_msgs;
        this.incoming_copies = incoming_copies;
        this.outgoing_copies = outgoing_copies;
    }

    public int getIncomingCopies() {
        return this.incoming_copies;
    }

    public DUPL setIncomingCopies(int incoming_copies) {
        this.incoming_copies = incoming_copies;
        return this;
    }

    public int getOutgoingCopies() {
        return this.outgoing_copies;
    }

    public DUPL setOutgoingCopies(int outgoing_copies) {
        this.outgoing_copies = outgoing_copies;
        return this;
    }

    public boolean isCopyUnicastMsgs() {
        return this.copy_unicast_msgs;
    }

    public DUPL setCopyUnicastMsgs(boolean copy_unicast_msgs) {
        this.copy_unicast_msgs = copy_unicast_msgs;
        return this;
    }

    public boolean isCopyMulticastMsgs() {
        return this.copy_multicast_msgs;
    }

    public DUPL setCopyMulticastMsgs(boolean copy_multicast_msgs) {
        this.copy_multicast_msgs = copy_multicast_msgs;
        return this;
    }

    @Override
    public Object down(Message msg) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.outgoing_copies > 0;
        if (!copy) {
            return this.down_prot.down(msg);
        }
        this.copy(msg, this.outgoing_copies, Direction.DOWN);
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.incoming_copies > 0;
        if (!copy) {
            return this.up_prot.up(msg);
        }
        this.copy(msg, this.incoming_copies, Direction.UP);
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.incoming_copies > 0;
        if (copy) {
            ArrayList<Message> copies = new ArrayList<Message>();
            for (Message msg : batch) {
                boolean multicast;
                Address dest = msg.getDest();
                boolean bl2 = multicast = dest == null;
                if ((!multicast || !this.copy_multicast_msgs) && (multicast || !this.copy_unicast_msgs)) continue;
                for (int i = 0; i < this.incoming_copies; ++i) {
                    copies.add(msg.copy(true, true));
                }
            }
            copies.forEach(batch::add);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    private void copy(Message msg, int num_copies, Direction direction) {
        boolean multicast;
        Address dest = msg.getDest();
        boolean bl = multicast = dest == null;
        if (multicast && this.copy_multicast_msgs || !multicast && this.copy_unicast_msgs) {
            block4: for (int i = 0; i < num_copies; ++i) {
                Message copy = msg.copy(true, true);
                switch (direction) {
                    case UP: {
                        this.up_prot.up(copy);
                        continue block4;
                    }
                    case DOWN: {
                        this.down_prot.down(copy);
                    }
                }
            }
        }
    }

    protected static enum Direction {
        UP,
        DOWN;

    }
}

