/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment.integration;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticDescriptor;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class HibernateOrmIntegrationStaticConfiguredBuildItem
extends MultiBuildItem {
    private final String integrationName;
    private final String persistenceUnitName;
    private HibernateOrmIntegrationStaticInitListener initListener;
    private boolean xmlMappingRequired = false;

    public HibernateOrmIntegrationStaticConfiguredBuildItem(String integrationName, String persistenceUnitName) {
        if (integrationName == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.integrationName = integrationName;
        if (persistenceUnitName == null) {
            throw new IllegalArgumentException("persistenceUnitName cannot be null");
        }
        this.persistenceUnitName = persistenceUnitName;
    }

    public String toString() {
        return HibernateOrmIntegrationStaticConfiguredBuildItem.class.getSimpleName() + " [" + this.integrationName + "]";
    }

    public HibernateOrmIntegrationStaticConfiguredBuildItem setInitListener(HibernateOrmIntegrationStaticInitListener initListener) {
        this.initListener = initListener;
        return this;
    }

    public HibernateOrmIntegrationStaticConfiguredBuildItem setXmlMappingRequired(boolean xmlMappingRequired) {
        this.xmlMappingRequired = xmlMappingRequired;
        return this;
    }

    private HibernateOrmIntegrationStaticDescriptor toDescriptor() {
        return new HibernateOrmIntegrationStaticDescriptor(this.integrationName, Optional.ofNullable(this.initListener), this.xmlMappingRequired);
    }

    public static Map<String, List<HibernateOrmIntegrationStaticDescriptor>> collectDescriptors(List<HibernateOrmIntegrationStaticConfiguredBuildItem> items) {
        HashMap<String, List<HibernateOrmIntegrationStaticDescriptor>> result = new HashMap<String, List<HibernateOrmIntegrationStaticDescriptor>>();
        for (HibernateOrmIntegrationStaticConfiguredBuildItem item : items) {
            result.computeIfAbsent(item.persistenceUnitName, ignored -> new ArrayList()).add(item.toDescriptor());
        }
        return result;
    }
}

