/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;

public final class IndexOfSortedSetFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, SortedSetBucket.IndexValue> {
    public static final AdvancedExternalizer<IndexOfSortedSetFunction> EXTERNALIZER = new Externalizer();
    private final V member;
    private final boolean isRev;

    public IndexOfSortedSetFunction(V member, boolean isRev) {
        this.member = member;
        this.isRev = isRev;
    }

    public SortedSetBucket.IndexValue apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((SortedSetBucket)existing.get()).indexOf(this.member, this.isRev);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<IndexOfSortedSetFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends IndexOfSortedSetFunction>> getTypeClasses() {
            return Collections.singleton(IndexOfSortedSetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_INDEX_OF_FUNCTION;
        }

        public void writeObject(ObjectOutput output, IndexOfSortedSetFunction object) throws IOException {
            output.writeObject(object.member);
            output.writeBoolean(object.isRev);
        }

        public IndexOfSortedSetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new IndexOfSortedSetFunction(input.readObject(), input.readBoolean());
        }
    }
}

