/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.w3c.dom.Node;

public abstract class AbstractStyleDatabase
implements StyleDatabase,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_GENERIC_FONT_FAMILY = "serif";
    private static final TypedValue DEFAULT_INITIAL_COLOR = (TypedValue)new ValueFactory().parseProperty("#000000");
    private CSSTypedValue initialColor = DEFAULT_INITIAL_COLOR;

    @Override
    public CSSTypedValue getInitialColor() {
        return this.initialColor;
    }

    @Override
    public void setInitialColor(String initialColor) {
        this.initialColor = (TypedValue)new ValueFactory().parseProperty(initialColor);
        ((ColorValue)this.initialColor).setSystemDefault();
    }

    @Override
    public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily(DEFAULT_GENERIC_FONT_FAMILY);
    }

    @Override
    public String getUsedFontFamily(CSSComputedProperties computedStyle) {
        String requestedFamily = this.scanFontFamilyValue(computedStyle);
        if (requestedFamily == null) {
            requestedFamily = this.getDefaultGenericFontFamily();
        }
        return requestedFamily;
    }

    private String scanFontFamilyValue(CSSComputedProperties style) {
        CSSComputedProperties ancStyle;
        CSSValue value = style.getPropertyCSSValue("font-family");
        String requestedFamily = null;
        if (value != null) {
            if (value.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList fontList = (ValueList)value;
                for (StyleValue item : fontList) {
                    requestedFamily = this.stringValueOrNull(item);
                    if (requestedFamily == null || !this.isFontFamilyAvailable(requestedFamily, style)) continue;
                    return requestedFamily;
                }
            } else {
                requestedFamily = this.stringValueOrNull(value);
                if (requestedFamily != null && this.isFontFamilyAvailable(requestedFamily, style)) {
                    return requestedFamily;
                }
            }
        }
        if ((ancStyle = style.getParentComputedStyle()) != null) {
            requestedFamily = this.scanFontFamilyValue(ancStyle);
        }
        return requestedFamily;
    }

    private String stringValueOrNull(CSSValue value) {
        CSSTypedValue primi;
        CSSValue.Type ptype;
        String s = value.getCssValueType() == CSSValue.CssType.TYPED && ((ptype = (primi = (CSSTypedValue)value).getPrimitiveType()) == CSSValue.Type.STRING || ptype == CSSValue.Type.IDENT) ? primi.getStringValue() : null;
        return s;
    }

    protected boolean isFontFamilyAvailable(String requestedFamily, CSSComputedProperties style) {
        if (this.isFontFamilyAvailable(requestedFamily = requestedFamily.toLowerCase(Locale.ROOT))) {
            return true;
        }
        return this.isFontFaceName(requestedFamily);
    }

    @Override
    public void loadFontFaceRule(CSSFontFaceRule rule) {
        String familyName = rule.getStyle().getPropertyValue("font-family");
        if (familyName == null) {
            rule.getStyleDeclarationErrorHandler().missingRequiredProperty(familyName);
            return;
        }
        if (!this.isFontFaceName(familyName = familyName.toLowerCase(Locale.ROOT))) {
            CSSStyleDeclaration decl = rule.getStyle();
            CSSValue value = decl.getPropertyCSSValue("src");
            if (value.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList list = (ValueList)value;
                if (list.isCommaSeparated()) {
                    for (StyleValue item : list) {
                        if (!(item.getCssValueType() == CSSValue.CssType.LIST ? this.loadFont(familyName, (ValueList)item, rule) : this.loadFont(familyName, (TypedValue)item, null, rule))) continue;
                        return;
                    }
                } else if (this.loadFont(familyName, list, rule)) {
                    return;
                }
            } else if (this.loadFont(familyName, (TypedValue)value, null, rule)) {
                return;
            }
        }
    }

    private boolean loadFont(String familyName, ValueList value, CSSFontFaceRule rule) {
        if (!value.isCommaSeparated()) {
            ValueList list = value;
            TypedValue uri = null;
            String fontFormat = null;
            for (StyleValue item : list) {
                if (item.getCssValueType() == CSSValue.CssType.TYPED) {
                    StyleValue arg;
                    LinkedCSSValueList args;
                    TypedValue primi = (TypedValue)item;
                    CSSValue.Type pType = primi.getPrimitiveType();
                    if (pType == CSSValue.Type.URI || pType == CSSValue.Type.STRING || pType == CSSValue.Type.SRC) {
                        if (uri == null) {
                            uri = primi;
                            continue;
                        }
                    } else if (pType == CSSValue.Type.FUNCTION && "format".equalsIgnoreCase(primi.getStringValue()) && (args = ((FunctionValue)primi).getArguments()).size() == 1 && (arg = args.item(0)).getCssValueType() == CSSValue.CssType.TYPED && ((pType = (primi = (TypedValue)arg).getPrimitiveType()) == CSSValue.Type.STRING || pType == CSSValue.Type.IDENT)) {
                        fontFormat = primi.getStringValue();
                        continue;
                    }
                }
                this.errorSrc(item, rule);
                return false;
            }
            if (uri != null) {
                return this.loadFont(familyName, uri, fontFormat, rule);
            }
            this.errorSrc(value, rule);
            return false;
        }
        this.errorSrc(value, rule);
        return false;
    }

    private void errorSrc(StyleValue value, CSSDeclarationRule rule) {
        CSSPropertyValueException ex = new CSSPropertyValueException("Expected primitive value.");
        ex.setValueText(value.getCssText());
        rule.getStyleDeclarationErrorHandler().wrongValue("src", ex);
    }

    private boolean loadFont(String familyName, TypedValue value, String format, CSSFontFaceRule rule) {
        CSSValue.Type pType = value.getPrimitiveType();
        if (pType == CSSValue.Type.URI) {
            String uri = value.getStringValue();
            return this.loadFont(familyName, format, rule, uri);
        }
        if (pType == CSSValue.Type.SRC) {
            StyleValue first;
            FunctionValue function = (FunctionValue)value;
            if (function.getArguments().size() >= 1 && (first = (StyleValue)function.getArguments().getFirst()).getPrimitiveType() == CSSValue.Type.STRING) {
                String uri = ((CSSTypedValue)((Object)first)).getStringValue();
                return this.loadFont(familyName, format, rule, uri);
            }
        } else if (pType == CSSValue.Type.FUNCTION) {
            StyleValue arg;
            String fname = value.getStringValue();
            FunctionValue function = (FunctionValue)value;
            if ("local".equalsIgnoreCase(fname) && function.getArguments().size() == 1 && (arg = (StyleValue)function.getArguments().get(0)).getPrimitiveType() == CSSValue.Type.STRING) {
                return this.isFontFamilyAvailable(value.getStringValue());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFont(String familyName, String format, CSSFontFaceRule rule, String uri) {
        URL url;
        Node node = rule.getParentStyleSheet().getOwnerNode();
        CSSDocument doc = node.getNodeType() != 9 ? (CSSDocument)node.getOwnerDocument() : (CSSDocument)node;
        try {
            url = doc.getURL(uri);
        }
        catch (MalformedURLException e) {
            doc.getErrorHandler().ioError(uri, e);
            return false;
        }
        if (!doc.isAuthorizedOrigin(url)) {
            doc.getErrorHandler().policyError(node, "Unauthorized URL: " + url.toExternalForm());
            return false;
        }
        InputStream is = null;
        try {
            FontFormat fontFormat = null;
            URLConnection conn = doc.openConnection(url);
            conn.setConnectTimeout(10000);
            conn.connect();
            String conType = conn.getContentType();
            if (conType != null) {
                int scidx = conType.indexOf(59);
                if (scidx != -1) {
                    conType = conType.substring(0, scidx);
                }
                conType = conType.toLowerCase(Locale.ROOT);
                fontFormat = this.fontFormatFromContentType(conType);
            }
            if (fontFormat == null && format != null) {
                fontFormat = this.fontFormatFromRule(format.toLowerCase(Locale.ROOT));
            }
            is = conn.getInputStream();
            this.loadFontFace(familyName, fontFormat, is, rule);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            doc.getErrorHandler().ioError(url.toExternalForm(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    protected FontFormat fontFormatFromContentType(String conType) {
        FontFormat fontFormat = "application/font-ttf".equals(conType) || "application/x-font-ttf".equals(conType) || "application/font-sfnt".equals(conType) || "font/ttf".equals(conType) ? FontFormat.TRUETYPE : ("application/font-woff".equals(conType) || "application/x-font-woff".equals(conType) || "font/woff".equals(conType) ? FontFormat.WOFF : ("application/font-woff2".equals(conType) || "font/woff2".equals(conType) ? FontFormat.WOFF2 : ("application/font-opentype".equals(conType) || "application/x-font-opentype".equals(conType) || "application/vnd.ms-opentype".equals(conType) || "font/otf".equals(conType) || "font/opentype".equals(conType) ? FontFormat.OPENTYPE : ("application/vnd.ms-fontobject".equals(conType) || "font/eot".equals(conType) ? FontFormat.EMBEDDED_OPENTYPE : ("image/svg+xml".equals(conType) ? FontFormat.SVG : null)))));
        return fontFormat;
    }

    protected FontFormat fontFormatFromRule(String format) {
        FontFormat fontFormat = "truetype".equals(format) ? FontFormat.TRUETYPE : ("woff".equals(format) ? FontFormat.WOFF : ("woff2".equals(format) ? FontFormat.WOFF2 : ("opentype".equals(format) ? FontFormat.OPENTYPE : ("embedded-opentype".equals(format) ? FontFormat.EMBEDDED_OPENTYPE : ("opentype".equals(format) ? FontFormat.OPENTYPE : ("svg".equals(format) ? FontFormat.SVG : null))))));
        return fontFormat;
    }

    protected boolean loadFontFace(String familyName, FontFormat fontFormat, InputStream is, CSSFontFaceRule rule) throws IOException {
        return false;
    }

    protected abstract boolean isFontFamilyAvailable(String var1);

    static {
        ((ColorValue)DEFAULT_INITIAL_COLOR).setSystemDefault();
    }

    public static enum FontFormat {
        TRUETYPE,
        OPENTYPE,
        EMBEDDED_OPENTYPE,
        SVG,
        WOFF,
        WOFF2;

    }
}

