/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldifinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldifinput.LDIFInput;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputData;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputField;
import org.pentaho.di.trans.steps.ldifinput.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fileName;
    private String[] fileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private LDIFInputField[] inputFields;
    private boolean addtoresultfilename;
    private String multiValuedSeparator;
    private boolean includeContentType;
    private String contentTypeField;
    private boolean filefield;
    private String dynamicFilenameField;

    public LDIFInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LDIFInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean includeContentType() {
        return this.includeContentType;
    }

    public void setIncludeContentType(boolean includeContentType) {
        this.includeContentType = includeContentType;
    }

    public void setMultiValuedSeparator(String multiValuedSeparator) {
        this.multiValuedSeparator = multiValuedSeparator;
    }

    public String getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    public void setAddToResultFilename(boolean addtoresultfilename) {
        this.addtoresultfilename = addtoresultfilename;
    }

    public boolean AddToResultFilename() {
        return this.addtoresultfilename;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getContentTypeField() {
        return this.contentTypeField;
    }

    public void setContentTypeField(String contentTypeField) {
        this.contentTypeField = contentTypeField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        LDIFInputMeta retval = (LDIFInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
        }
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LDIFInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dynamicFilenameField", (String)this.dynamicFilenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"contenttype", (boolean)this.includeContentType));
        retval.append("    " + XMLHandler.addTagValue((String)"contenttype_field", (String)this.contentTypeField));
        retval.append("    " + XMLHandler.addTagValue((String)"addtoresultfilename", (boolean)this.addtoresultfilename));
        retval.append("    " + XMLHandler.addTagValue((String)"multiValuedSeparator", (String)this.multiValuedSeparator));
        retval.append("    <file>" + Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      " + XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
        }
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            LDIFInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.filefield = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filefield"));
            this.dynamicFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"dynamicFilenameField");
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.includeContentType = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"contenttype"));
            this.contentTypeField = XMLHandler.getTagValue((Node)stepnode, (String)"contenttype_field");
            this.addtoresultfilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addtoresultfilename"));
            this.multiValuedSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"multiValuedSeparator");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
            }
            for (i = 0; i < nrFields; ++i) {
                LDIFInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new LDIFInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.inputFields = new LDIFInputField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.filefield = false;
        this.dynamicFilenameField = "";
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.includeContentType = false;
        this.contentTypeField = "";
        this.multiValuedSeparator = ",";
        this.addtoresultfilename = false;
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LDIFInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            LDIFInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            ValueMeta v2 = new ValueMeta(space.environmentSubstitute(field.getName()), type);
            v2.setLength(field.getLength(), field.getPrecision());
            v2.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v2);
        }
        if (this.includeFilename) {
            v = new ValueMeta(space.environmentSubstitute(this.filenameField), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeContentType) {
            v = new ValueMeta(space.environmentSubstitute(this.contentTypeField), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.filefield = rep.getStepAttributeBoolean(id_step, "filefield");
            this.dynamicFilenameField = rep.getStepAttributeString(id_step, "dynamicFilenameField");
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.addtoresultfilename = rep.getStepAttributeBoolean(id_step, "addtoresultfilename");
            this.multiValuedSeparator = rep.getStepAttributeString(id_step, "multiValuedSeparator");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.includeContentType = rep.getStepAttributeBoolean(id_step, "contenttype");
            this.contentTypeField = rep.getStepAttributeString(id_step, "contenttype_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
            }
            for (i = 0; i < nrFields; ++i) {
                LDIFInputField field = new LDIFInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setAttribut(rep.getStepAttributeString(id_step, i, "field_attribut"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(LDIFInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("LDIFInputMeta.Exception.ErrorReadingRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.filefield);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicFilenameField", this.dynamicFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "contenttype", this.includeContentType);
            rep.saveStepAttribute(id_transformation, id_step, "contenttype_field", this.contentTypeField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "addtoresultfilename", this.addtoresultfilename);
            rep.saveStepAttribute(id_transformation, id_step, "multiValuedSeparator", this.multiValuedSeparator);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_mask", this.fileMask[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                LDIFInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_attribut", field.getAttribut());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_repeat", field.isRepeated());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("LDIFInputMeta.Exception.ErrorSavingToRepository", "" + id_step), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        String[] required = new String[this.fileName.length];
        boolean[] subdirs = new boolean[this.fileName.length];
        for (int i = 0; i < required.length; ++i) {
            required[i] = "N";
            subdirs[i] = false;
        }
        return FileInputList.createFileList((VariableSpace)space, (String[])space.environmentSubstitute(this.fileName), (String[])space.environmentSubstitute(this.fileMask), (String[])required, (boolean[])subdirs);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, Messages.getString("LDIFInputMeta.CheckResult.NoInputExpected"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("LDIFInputMeta.CheckResult.NoInput"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileInputList = this.getFiles(transMeta);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, Messages.getString("LDIFInputMeta.CheckResult.NoFiles"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("LDIFInputMeta.CheckResult.FilesOk", "" + fileInputList.getFiles().size()), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepDataInterface getStepData() {
        return new LDIFInputData();
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new LDIFInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            if (!this.filefield) {
                ArrayList<FileObject> newFilenames = new ArrayList<FileObject>();
                FileInputList fileList = this.getFiles(space);
                if (fileList.getFiles().size() > 0) {
                    for (FileObject fileObject : fileList.getFiles()) {
                        if (!fileObject.exists()) continue;
                        newFilenames.add(fileObject);
                    }
                    this.fileName = new String[newFilenames.size()];
                    this.fileMask = new String[newFilenames.size()];
                    for (int i = 0; i < newFilenames.size(); ++i) {
                        FileObject fileObject;
                        fileObject = (FileObject)newFilenames.get(i);
                        this.fileName[i] = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                        this.fileMask[i] = null;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

