/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.api;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.modules.autoupdate.ui.ModuleInstallerSupport;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.util.Parameters;

public final class PluginManager {
    private PluginManager() {
    }

    public static boolean openInstallWizard(OperationContainer<InstallSupport> operationContainer) {
        if (operationContainer == null) {
            throw new IllegalArgumentException("OperationContainer cannot be null.");
        }
        List list = operationContainer.listAll();
        if (list.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot be empty.");
        }
        List list2 = operationContainer.listInvalid();
        if (!list2.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot contain invalid elements but " + list2);
        }
        OperationContainer.OperationInfo operationInfo = (OperationContainer.OperationInfo)list.get(0);
        OperationWizardModel.OperationType operationType = operationInfo.getUpdateUnit().getInstalled() == null ? OperationWizardModel.OperationType.INSTALL : OperationWizardModel.OperationType.UPDATE;
        return new InstallUnitWizard().invokeWizard(new InstallUnitWizardModel(operationType, operationContainer), false);
    }

    public static void openInstallWizard(OperationContainer<InstallSupport> operationContainer, boolean bl) {
        if (operationContainer == null) {
            throw new IllegalArgumentException("OperationContainer cannot be null.");
        }
        List list = operationContainer.listAll();
        if (list.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot be empty.");
        }
        List list2 = operationContainer.listInvalid();
        if (!list2.isEmpty()) {
            throw new IllegalArgumentException("OperationContainer cannot contain invalid elements but " + list2);
        }
        OperationContainer.OperationInfo operationInfo = (OperationContainer.OperationInfo)list.get(0);
        OperationWizardModel.OperationType operationType = operationInfo.getUpdateUnit().getInstalled() == null ? OperationWizardModel.OperationType.INSTALL : OperationWizardModel.OperationType.UPDATE;
        new InstallUnitWizard().invokeWizard(new InstallUnitWizardModel(operationType, operationContainer), true, bl);
    }

    @CheckForNull
    public static Object installSingle(@NonNull String string, @NonNull String string2, Object ... objectArray) {
        Parameters.notNull((CharSequence)"cnb", (Object)string);
        Parameters.notNull((CharSequence)"displayName", (Object)string2);
        Parameters.notNull((CharSequence)"alternativeOptions", (Object)objectArray);
        try {
            return new ModuleInstallerSupport(objectArray).installPlugins(string2, Collections.singleton(string));
        }
        catch (OperationException operationException) {
            Logger.getLogger(PluginManager.class.getName()).log(Level.WARNING, null, operationException);
            return -1;
        }
    }

    @CheckForNull
    public static Object install(@NonNull Set<String> set, Object ... objectArray) {
        Parameters.notNull((CharSequence)"cnb", set);
        Parameters.notNull((CharSequence)"alternativeOptions", (Object)objectArray);
        if (set.isEmpty()) {
            throw new IllegalArgumentException("No plugins to install");
        }
        try {
            return new ModuleInstallerSupport(objectArray).installPlugins(null, set);
        }
        catch (OperationException operationException) {
            Logger.getLogger(PluginManager.class.getName()).log(Level.WARNING, null, operationException);
            return -1;
        }
    }
}

