/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.BasicSearchForm;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.IgnoreListPanel;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchScopeList;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.DefaultMatcher;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.netbeans.spi.search.provider.SearchComposition;
import org.netbeans.spi.search.provider.SearchProvider;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class BasicSearchProvider
extends SearchProvider {
    @Override
    public SearchProvider.Presenter createPresenter(boolean bl) {
        return new BasicSearchPresenter(bl, null, null, this, new SearchScopeDefinition[0]);
    }

    @Override
    public boolean isReplaceSupported() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public static SearchProvider.Presenter createBasicPresenter(boolean bl) {
        return new BasicSearchPresenter(bl, null, null, new SearchScopeDefinition[0]);
    }

    public static SearchProvider.Presenter createBasicPresenter(boolean bl, @NullAllowed SearchPattern searchPattern, @NullAllowed String string, @NullAllowed Boolean bl2, @NullAllowed SearchScopeOptions searchScopeOptions, @NullAllowed Boolean bl3, @NullAllowed String string2, SearchScopeDefinition ... searchScopeDefinitionArray) {
        BasicSearchCriteria basicSearchCriteria = BasicSearchProvider.createCriteria(searchScopeOptions, bl3, searchPattern, bl2, bl, string);
        return new BasicSearchPresenter(bl, string2, basicSearchCriteria, searchScopeDefinitionArray);
    }

    @Override
    public String getTitle() {
        return UiUtils.getText("BasicSearchForm.tabText");
    }

    public static void startSearch(@NonNull SearchPattern searchPattern, @NonNull SearchScopeOptions searchScopeOptions, @NullAllowed String string) throws IllegalArgumentException {
        BasicSearchCriteria basicSearchCriteria = BasicSearchProvider.createCriteria(searchScopeOptions, Boolean.FALSE, searchPattern, null, false, null);
        if (!basicSearchCriteria.isUsable()) {
            throw new IllegalArgumentException("Search cannot be started - No restrictions set.");
        }
        SearchScopeDefinition searchScopeDefinition = BasicSearchProvider.findBestSearchScope(string);
        BasicComposition basicComposition = new BasicComposition(searchScopeDefinition.getSearchInfo(), new DefaultMatcher(searchPattern), basicSearchCriteria, null);
        Manager.getInstance().scheduleSearchTask(new SearchTask(basicComposition, false));
    }

    private static BasicSearchCriteria createCriteria(SearchScopeOptions searchScopeOptions, Boolean bl, SearchPattern searchPattern, Boolean bl2, boolean bl3, String string) {
        BasicSearchCriteria basicSearchCriteria = new BasicSearchCriteria();
        basicSearchCriteria.setFileNamePattern(searchScopeOptions.getPattern());
        basicSearchCriteria.setFileNameRegexp(searchScopeOptions.isRegexp());
        basicSearchCriteria.setTextPattern(searchPattern.getSearchExpression());
        basicSearchCriteria.setCaseSensitive(searchPattern.isMatchCase());
        basicSearchCriteria.setWholeWords(searchPattern.isWholeWords());
        basicSearchCriteria.setMatchType(searchPattern.getMatchType());
        if (bl2 != null) {
            basicSearchCriteria.setPreserveCase(bl2);
        }
        if (bl != null) {
            basicSearchCriteria.setUseIgnoreList(bl);
        }
        if (bl3) {
            basicSearchCriteria.setReplaceExpr(string);
        } else {
            basicSearchCriteria.setSearchInArchives(searchScopeOptions.isSearchInArchives());
            basicSearchCriteria.setSearchInGenerated(searchScopeOptions.isSearchInGenerated());
        }
        return basicSearchCriteria;
    }

    private static SearchScopeDefinition findBestSearchScope(String string) throws IllegalStateException {
        SearchScopeList searchScopeList = new SearchScopeList(new SearchScopeDefinition[0]);
        SearchScopeDefinition searchScopeDefinition = null;
        for (SearchScopeDefinition searchScopeDefinition2 : searchScopeList.getSeachScopeDefinitions()) {
            if (!searchScopeDefinition2.isApplicable()) continue;
            if (string != null && searchScopeDefinition2.getTypeId().equals(string)) {
                searchScopeDefinition = searchScopeDefinition2;
                break;
            }
            if (searchScopeDefinition != null) continue;
            searchScopeDefinition = searchScopeDefinition2;
        }
        if (searchScopeDefinition == null) {
            throw new IllegalStateException("No default search scope");
        }
        return searchScopeDefinition;
    }

    public static SearchFilterDefinition getIgnoreListFilter() {
        return new IgnoreListFilter();
    }

    private static class IgnoreListFilter
    extends SearchFilterDefinition {
        private IgnoreListPanel.IgnoreListManager ignoreListManager;

        private IgnoreListFilter() {
        }

        @Override
        public boolean searchFile(FileObject fileObject) throws IllegalArgumentException {
            if (fileObject.isFolder()) {
                throw new IllegalArgumentException(fileObject + " is folder, but should be regular file.");
            }
            return !this.isIgnored(fileObject);
        }

        @Override
        public SearchFilterDefinition.FolderResult traverseFolder(FileObject fileObject) throws IllegalArgumentException {
            if (!fileObject.isFolder()) {
                throw new IllegalArgumentException(fileObject + " is file, but should be folder.");
            }
            if (this.isIgnored(fileObject)) {
                return SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
            }
            return SearchFilterDefinition.FolderResult.TRAVERSE;
        }

        private boolean isIgnored(FileObject fileObject) {
            return this.getIgnoreListManager().isIgnored(fileObject);
        }

        IgnoreListPanel.IgnoreListManager getIgnoreListManager() {
            if (this.ignoreListManager == null) {
                List<String> list = FindDialogMemory.getDefault().getIgnoreList();
                this.ignoreListManager = new IgnoreListPanel.IgnoreListManager(list);
            }
            return this.ignoreListManager;
        }
    }

    private static class BasicSearchPresenter
    extends SearchProvider.Presenter {
        BasicSearchForm form = null;
        private String scopeId;
        private BasicSearchCriteria explicitCriteria;
        private SearchScopeDefinition[] extraSearchScopes;
        private boolean wasUsableAlready = false;

        public BasicSearchPresenter(boolean bl, String string, BasicSearchCriteria basicSearchCriteria, SearchScopeDefinition ... searchScopeDefinitionArray) {
            this(bl, string, basicSearchCriteria, (BasicSearchProvider)Lookup.getDefault().lookup(BasicSearchProvider.class), searchScopeDefinitionArray);
        }

        public BasicSearchPresenter(boolean bl, String string, BasicSearchCriteria basicSearchCriteria, BasicSearchProvider basicSearchProvider, SearchScopeDefinition ... searchScopeDefinitionArray) {
            super(basicSearchProvider, bl);
            this.scopeId = string;
            this.explicitCriteria = basicSearchCriteria;
            this.extraSearchScopes = searchScopeDefinitionArray;
        }

        @Override
        public JComponent getForm() {
            if (this.form == null) {
                String string = this.chooseSearchScope(this.scopeId);
                this.form = new BasicSearchForm(string, this.isReplacing(), this.explicitCriteria, this.extraSearchScopes);
                this.form.setUsabilityChangeListener(changeEvent -> this.fireChange());
            }
            return this.form;
        }

        private String chooseSearchScope(String string) {
            return string == null ? FindDialogMemory.getDefault().getScopeTypeId() : string;
        }

        @Override
        public HelpCtx getHelpCtx() {
            return new HelpCtx(SearchPanel.class.getCanonicalName() + "." + this.isReplacing());
        }

        public SearchComposition<MatchingObject.Def> composeSearch() {
            String string = Manager.getInstance().mayStartSearching();
            if (string != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
                return null;
            }
            this.form.onOk();
            BasicSearchCriteria basicSearchCriteria = this.form.getBasicSearchCriteria();
            SearchScopeOptions searchScopeOptions = basicSearchCriteria.getSearcherOptions();
            if (basicSearchCriteria.isUseIgnoreList()) {
                searchScopeOptions.addFilter(new IgnoreListFilter());
            }
            SearchInfo searchInfo = this.form.getSearchInfo();
            DefaultMatcher defaultMatcher = new DefaultMatcher(basicSearchCriteria.getSearchPattern());
            ((AbstractMatcher)defaultMatcher).setStrict(this.isReplacing());
            return new BasicComposition(searchInfo, defaultMatcher, basicSearchCriteria, this.form.getSelectedScopeName());
        }

        @Override
        public boolean isUsable(NotificationLineSupport notificationLineSupport) {
            boolean bl = this.form.isUsable();
            BasicSearchCriteria basicSearchCriteria = this.form.getBasicSearchCriteria();
            if (!bl) {
                String string;
                if (basicSearchCriteria.isTextPatternInvalid()) {
                    string = "BasicSearchForm.txtErrorTextPattern";
                } else if (basicSearchCriteria.isSearchAndReplace() && basicSearchCriteria.isReplacePatternInvalid()) {
                    string = "BasicSearchForm.txtErrorReplacePattern";
                } else if (basicSearchCriteria.isFileNamePatternInvalid()) {
                    string = "BasicSearchForm.txtErrorFileName";
                } else {
                    string = "BasicSearchForm.txtErrorMissingCriteria";
                    if (!this.wasUsableAlready) {
                        notificationLineSupport.setInformationMessage(UiUtils.getText(string));
                        return false;
                    }
                }
                notificationLineSupport.setErrorMessage(UiUtils.getText(string));
            } else {
                this.wasUsableAlready = true;
                if (!basicSearchCriteria.isFileNameRegexp() && !basicSearchCriteria.getFileNamePatternExpr().isEmpty() && basicSearchCriteria.getFileNamePatternExpr().matches("^[\\w-]*$")) {
                    notificationLineSupport.setInformationMessage(UiUtils.getText("BasicSearchForm.txtInfoNoWildcards"));
                } else {
                    notificationLineSupport.setInformationMessage(UiUtils.getText("BasicSearchForm.txtInfoMultiline"));
                }
            }
            return bl;
        }

        @Override
        public void clean() {
            super.clean();
        }
    }
}

