/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public abstract class TimeBucketCounterBase {
    private static final Log log = LogFactory.getLog(TimeBucketCounterBase.class);
    private static final StringManager sm = StringManager.getManager(TimeBucketCounterBase.class);
    private static final String BUCKET_KEY_DELIMITER = "-";
    private final ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();
    private ScheduledFuture<?> maintenanceFuture;
    private ScheduledFuture<?> monitorFuture;
    private final ScheduledExecutorService executorService;
    private final long sleeptime;
    private final int bucketDuration;

    public TimeBucketCounterBase(int bucketDuration, ScheduledExecutorService executorService) {
        Objects.requireNonNull(executorService);
        this.executorService = executorService;
        this.bucketDuration = bucketDuration;
        int cleanupsPerBucketDuration = bucketDuration >= 60 ? 6 : 3;
        this.sleeptime = (long)bucketDuration * 1000L / (long)cleanupsPerBucketDuration;
        if (this.sleeptime > 0L) {
            this.monitorFuture = executorService.scheduleWithFixedDelay(new MaintenanceMonitor(), 0L, 60L, TimeUnit.SECONDS);
        }
    }

    public int getBucketDuration() {
        return this.bucketDuration;
    }

    public abstract double getRatio();

    public final int increment(String identifier) {
        String key = this.genKey(identifier);
        AtomicInteger ai = this.map.computeIfAbsent(key, v -> new AtomicInteger());
        return ai.incrementAndGet();
    }

    protected final String genKey(String identifier) {
        return this.genKey(identifier, System.currentTimeMillis());
    }

    protected final String genKey(String identifier, long timestamp) {
        return this.getBucketIndex(timestamp) + BUCKET_KEY_DELIMITER + identifier;
    }

    protected abstract long getBucketIndex(long var1);

    public int getCurrentBucketPrefix() {
        return (int)this.getBucketIndex(System.currentTimeMillis());
    }

    public abstract long getMillisUntilNextBucket();

    public void destroy() {
        this.map.clear();
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
            this.monitorFuture = null;
        }
        if (this.maintenanceFuture != null) {
            this.maintenanceFuture.cancel(true);
            this.maintenanceFuture = null;
        }
    }

    public void periodicEvict() {
        long currentBucketIndex = this.getCurrentBucketPrefix();
        String currentBucketPrefix = String.valueOf(currentBucketIndex);
        String nextBucketPrefix = String.valueOf(currentBucketIndex + 1L);
        Set keys = this.map.keySet();
        keys.removeIf(k -> !k.startsWith(currentBucketPrefix) && !k.startsWith(nextBucketPrefix));
    }

    private class MaintenanceMonitor
    implements Runnable {
        private MaintenanceMonitor() {
        }

        @Override
        public void run() {
            if (TimeBucketCounterBase.this.sleeptime > 0L && (TimeBucketCounterBase.this.maintenanceFuture == null || TimeBucketCounterBase.this.maintenanceFuture.isDone())) {
                if (TimeBucketCounterBase.this.maintenanceFuture != null && TimeBucketCounterBase.this.maintenanceFuture.isDone()) {
                    try {
                        TimeBucketCounterBase.this.maintenanceFuture.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        log.error((Object)sm.getString("timebucket.maintenance.error"), (Throwable)e);
                    }
                }
                TimeBucketCounterBase.this.maintenanceFuture = TimeBucketCounterBase.this.executorService.scheduleWithFixedDelay(new Maintenance(), TimeBucketCounterBase.this.sleeptime, TimeBucketCounterBase.this.sleeptime, TimeUnit.MILLISECONDS);
            }
        }
    }

    private class Maintenance
    implements Runnable {
        private Maintenance() {
        }

        @Override
        public void run() {
            TimeBucketCounterBase.this.periodicEvict();
        }
    }
}

