/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.mapper;

import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.intellij.plugins.markdown.dto.MarkdownHeaderInfo;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;

public final class MarkdownHeaderMapper {
    private static final Logger logger = Logger.getInstance(MarkdownHeaderMapper.class);

    public static MarkdownHeaderInfo map(MarkdownHeader header) {
        if (header == null) {
            logger.warn("Header is null, returning null");
            return null;
        }
        String headerText = header.getText();
        PsiFile containingFile = header.getContainingFile();
        if (containingFile == null) {
            throw new IllegalArgumentException("Containing file not found for header: " + headerText);
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalArgumentException("Virtual file not found for header: " + headerText);
        }
        String filePath = virtualFile.getPath();
        String fileName = virtualFile.getName();
        int textOffset = header.getTextOffset();
        int lineNumber = 0;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null) {
            lineNumber = document.getLineNumber(textOffset) + 1;
        }
        VirtualFileId virtualFileId = VirtualFileIdKt.rpcId((VirtualFile)header.getContainingFile().getVirtualFile());
        return new MarkdownHeaderInfo(headerText, filePath, fileName, lineNumber, textOffset, virtualFileId);
    }
}

