/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.commits;

import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.collaboration.ui.codereview.commits.CommitsListCellRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.Side;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0016\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0001\u0010\u0019\u001a\u00020\u0012J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u00020\u00002\u0014\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/collaboration/ui/codereview/commits/CommitsBrowserComponentBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "commitsModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/collaboration/ui/SingleValueModel;)V", "commitRenderer", "Ljavax/swing/ListCellRenderer;", "showCommitDetailsPanel", "", "onCommitSelected", "Lkotlin/Function1;", "", "emptyListText", "", "popupActions", "Lkotlin/Pair;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "setCustomCommitRenderer", "customRenderer", "setEmptyCommitListText", "emptyText", "installPopupActions", "actionGroup", "place", "showCommitDetails", "show", "create", "Ljavax/swing/JComponent;", "createCommitDetailsComponent", "model", "Companion", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nCommitsBrowserComponentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitsBrowserComponentBuilder.kt\ncom/intellij/collaboration/ui/codereview/commits/CommitsBrowserComponentBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class CommitsBrowserComponentBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SingleValueModel<List<VcsCommitMetadata>> commitsModel;
    @NotNull
    private ListCellRenderer<VcsCommitMetadata> commitRenderer;
    private boolean showCommitDetailsPanel;
    @NotNull
    private Function1<? super VcsCommitMetadata, Unit> onCommitSelected;
    @Nullable
    private String emptyListText;
    @Nullable
    private Pair<? extends ActionGroup, String> popupActions;
    @NotNull
    private static final Key<JList<VcsCommitMetadata>> COMMITS_LIST_KEY;

    public CommitsBrowserComponentBuilder(@NotNull Project project, @NotNull SingleValueModel<List<VcsCommitMetadata>> commitsModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commitsModel, (String)"commitsModel");
        this.project = project;
        this.commitsModel = commitsModel;
        this.commitRenderer = new CommitsListCellRenderer();
        this.showCommitDetailsPanel = true;
        this.onCommitSelected = CommitsBrowserComponentBuilder::onCommitSelected$lambda$0;
    }

    @NotNull
    public final CommitsBrowserComponentBuilder setCustomCommitRenderer(@NotNull ListCellRenderer<VcsCommitMetadata> customRenderer) {
        Intrinsics.checkNotNullParameter(customRenderer, (String)"customRenderer");
        this.commitRenderer = customRenderer;
        return this;
    }

    @NotNull
    public final CommitsBrowserComponentBuilder setEmptyCommitListText(@NlsContexts.StatusText @NotNull String emptyText) {
        Intrinsics.checkNotNullParameter((Object)emptyText, (String)"emptyText");
        this.emptyListText = emptyText;
        return this;
    }

    @NotNull
    public final CommitsBrowserComponentBuilder installPopupActions(@NotNull ActionGroup actionGroup, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.popupActions = TuplesKt.to((Object)actionGroup, (Object)place);
        return this;
    }

    @NotNull
    public final CommitsBrowserComponentBuilder showCommitDetails(boolean show2) {
        this.showCommitDetailsPanel = show2;
        return this;
    }

    @NotNull
    public final CommitsBrowserComponentBuilder onCommitSelected(@NotNull Function1<? super VcsCommitMetadata, Unit> onCommitSelected) {
        Intrinsics.checkNotNullParameter(onCommitSelected, (String)"onCommitSelected");
        this.onCommitSelected = onCommitSelected;
        return this;
    }

    @NotNull
    public final JComponent create() {
        JScrollPane jScrollPane;
        JBList jBList;
        CollectionListModel commitsListModel = new CollectionListModel(this.commitsModel.getValue());
        JBList $this$create_u24lambda_u240 = jBList = new JBList((ListModel)commitsListModel);
        boolean bl = false;
        String string = this.emptyListText;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$create_u24lambda_u240.getEmptyText().setText(it);
        }
        $this$create_u24lambda_u240.setSelectionMode(0);
        ListCellRenderer<VcsCommitMetadata> renderer2 = this.commitRenderer;
        $this$create_u24lambda_u240.setCellRenderer(renderer2);
        if (renderer2 instanceof JComponent) {
            UIUtil.putClientProperty((JComponent)((JComponent)$this$create_u24lambda_u240), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)CollectionsKt.listOf(renderer2));
        }
        JBList list = jBList;
        boolean bl3 = false;
        ScrollingUtil.installActions((JList)((JList)list));
        ListUiUtil.Selection.INSTANCE.installSelectionOnFocus((JList)list);
        ListUiUtil.Selection.INSTANCE.installSelectionOnRightClick((JList)list);
        ListSpeedSearch.installOn((JList)((JList)list), arg_0 -> CommitsBrowserComponentBuilder.create$lambda$1$1(CommitsBrowserComponentBuilder::create$lambda$1$0, arg_0));
        Pair<? extends ActionGroup, String> pair = this.popupActions;
        if (pair != null) {
            Pair<? extends ActionGroup, String> pair2 = pair;
            boolean bl4 = false;
            PopupHandler.installSelectionListPopup((JList)((JList)list), (ActionGroup)((ActionGroup)pair2.getFirst()), (String)((String)pair2.getSecond()));
        }
        JBList commitsList = jBList;
        this.commitsModel.addAndInvokeListener((Function1<List<VcsCommitMetadata>, Unit>)((Function1)arg_0 -> CommitsBrowserComponentBuilder.create$lambda$2(commitsListModel, this, commitsList, arg_0)));
        SingleValueModel<Object> commitDetailsModel = new SingleValueModel<Object>(null);
        JComponent commitDetailsComponent = this.showCommitDetailsPanel ? this.createCommitDetailsComponent(commitDetailsModel) : null;
        commitsList.addListSelectionListener(arg_0 -> CommitsBrowserComponentBuilder.create$lambda$3(this, commitsList, arg_0));
        JScrollPane $this$create_u24lambda_u244 = jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)commitsList), (boolean)true);
        boolean bl5 = false;
        $this$create_u24lambda_u244.setOpaque(false);
        $this$create_u24lambda_u244.getViewport().setOpaque(false);
        $this$create_u24lambda_u244.setHorizontalScrollBarPolicy(31);
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"apply(...)");
        JScrollPane commitsScrollPane = jScrollPane2;
        ScrollableContentBorder.Companion.setup$default((ScrollableContentBorder.Companion)ScrollableContentBorder.Companion, (JScrollPane)commitsScrollPane, (Side)Side.TOP, null, (int)4, null);
        JScrollPane $this$create_u24lambda_u245 = jScrollPane = new OnePixelSplitter(true, "Github.PullRequest.Commits.Browser", 0.7f);
        boolean bl6 = false;
        $this$create_u24lambda_u245.setFirstComponent(commitsScrollPane);
        $this$create_u24lambda_u245.setSecondComponent(commitDetailsComponent);
        UIUtil.putClientProperty((JComponent)$this$create_u24lambda_u245, COMMITS_LIST_KEY, (Object)commitsList);
        JScrollPane commitsBrowserComponent = jScrollPane;
        commitsList.addListSelectionListener(arg_0 -> CommitsBrowserComponentBuilder.create$lambda$6(commitsList, commitDetailsModel, commitsListModel, (OnePixelSplitter)commitsBrowserComponent, arg_0));
        return commitsBrowserComponent;
    }

    private final JComponent createCommitDetailsComponent(SingleValueModel<VcsCommitMetadata> model) {
        JScrollPane jScrollPane;
        CommitDetailsPanel commitDetailsPanel = new CommitDetailsPanel(null, 1, null);
        JScrollPane $this$createCommitDetailsComponent_u24lambda_u240 = jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)commitDetailsPanel), (boolean)true);
        boolean bl = false;
        $this$createCommitDetailsComponent_u24lambda_u240.setVisible(false);
        $this$createCommitDetailsComponent_u24lambda_u240.setOpaque(false);
        $this$createCommitDetailsComponent_u24lambda_u240.getViewport().setOpaque(false);
        $this$createCommitDetailsComponent_u24lambda_u240.setHorizontalScrollBarPolicy(31);
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"apply(...)");
        JScrollPane scrollpane = jScrollPane2;
        model.addAndInvokeListener((Function1<VcsCommitMetadata, Unit>)((Function1)arg_0 -> CommitsBrowserComponentBuilder.createCommitDetailsComponent$lambda$1(model, this, commitDetailsPanel, scrollpane, arg_0)));
        return scrollpane;
    }

    private static final Unit onCommitSelected$lambda$0(VcsCommitMetadata it) {
        return Unit.INSTANCE;
    }

    private static final String create$lambda$1$0(VcsCommitMetadata commit) {
        return commit.getSubject();
    }

    private static final String create$lambda$1$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit create$lambda$2(CollectionListModel $commitsListModel, CommitsBrowserComponentBuilder this$0, JBList $commitsList, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List currentList = $commitsListModel.toList();
        List<VcsCommitMetadata> newList = this$0.commitsModel.getValue();
        if (!Intrinsics.areEqual((Object)currentList, newList)) {
            VcsCommitMetadata selectedCommit = (VcsCommitMetadata)$commitsList.getSelectedValue();
            $commitsListModel.replaceAll(newList);
            $commitsList.setSelectedValue((Object)selectedCommit, true);
        }
        return Unit.INSTANCE;
    }

    private static final void create$lambda$3(CommitsBrowserComponentBuilder this$0, JBList $commitsList, ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this$0.onCommitSelected.invoke($commitsList.getSelectedValue());
    }

    private static final void create$lambda$6(JBList $commitsList, SingleValueModel $commitDetailsModel, CollectionListModel $commitsListModel, OnePixelSplitter $commitsBrowserComponent, ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = $commitsList.getSelectedIndex();
        $commitDetailsModel.setValue(index != -1 ? (VcsCommitMetadata)$commitsListModel.getElementAt(index) : null);
        $commitsBrowserComponent.validate();
        $commitsBrowserComponent.repaint();
        if (index != -1) {
            ScrollingUtil.ensureRangeIsVisible((JList)((JList)$commitsList), (int)index, (int)index);
        }
    }

    private static final Unit createCommitDetailsComponent$lambda$1(SingleValueModel $model, CommitsBrowserComponentBuilder this$0, CommitDetailsPanel $commitDetailsPanel, JScrollPane $scrollpane, VcsCommitMetadata it) {
        VcsCommitMetadata commit = (VcsCommitMetadata)$model.getValue();
        if (commit != null) {
            String string = CommitPresentationUtil.formatCommitHashAndAuthor((Hash)((Hash)commit.getId()), (VcsUser)commit.getAuthor(), (long)commit.getAuthorTime(), (VcsUser)commit.getCommitter(), (long)commit.getCommitTime());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatCommitHashAndAuthor(...)");
            String hashAndAuthor = string;
            Project project = this$0.project;
            VirtualFile virtualFile = commit.getRoot();
            String string2 = commit.getFullMessage();
            MultiMap multiMap = MultiMap.empty();
            CommitPresentationUtil.CommitPresentation presentation2 = new CommitPresentationUtil.CommitPresentation(hashAndAuthor, project, virtualFile, string2, (MultiMap<String, CommitId>)multiMap){

                public String getText() {
                    HtmlBuilder htmlBuilder;
                    String string;
                    String string2 = this.myRawMessage;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myRawMessage");
                    int separator = StringsKt.indexOf$default((CharSequence)string2, (String)"\n\n", (int)0, (boolean)false, (int)6, null);
                    if (separator > 0) {
                        String string3 = this.myRawMessage;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"myRawMessage");
                        String string4 = string3;
                        int n = 0;
                        String string5 = string4.substring(n, separator);
                        string = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    } else {
                        String string6 = this.myRawMessage;
                        string = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"myRawMessage");
                    }
                    String subject = string;
                    String string7 = this.myRawMessage;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"myRawMessage");
                    String string8 = string7;
                    int n = subject.length();
                    String string9 = string8.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                    String description = string9;
                    if (StringsKt.contains$default((CharSequence)subject, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                        String string10 = this.myRawMessage;
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"myRawMessage");
                        return string10;
                    }
                    HtmlBuilder $this$getText_u24lambda_u240 = htmlBuilder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.raw((String)subject).bold());
                    boolean bl = false;
                    if (!StringsKt.isBlank((CharSequence)description)) {
                        $this$getText_u24lambda_u240.br().br().appendRaw(description);
                    }
                    String string11 = htmlBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toString(...)");
                    return string11;
                }
            };
            $commitDetailsPanel.setCommit(presentation2);
        }
        $scrollpane.setVisible(commit != null);
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"COMMITS_LIST");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COMMITS_LIST_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R0\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/collaboration/ui/codereview/commits/CommitsBrowserComponentBuilder$Companion;", "", "<init>", "()V", "COMMITS_LIST_KEY", "Lcom/intellij/openapi/util/Key;", "Ljavax/swing/JList;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCOMMITS_LIST_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JList<VcsCommitMetadata>> getCOMMITS_LIST_KEY() {
            return COMMITS_LIST_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

