/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.ai;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.word.StandardWordTokenizer;
import ai.grazie.rules.toolkit.LanguageToolkit;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.cloud.APIQueries;
import com.intellij.grazie.cloud.GrazieCloudConnector;
import com.intellij.grazie.cloud.TaskServerException;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.ui.PaddedListCellRenderer;
import com.intellij.grazie.rule.ParsedSentence;
import com.intellij.grazie.rule.SentenceTokenizer;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.NaturalTextDetector;
import com.intellij.grazie.utils.Text;
import com.intellij.grazie.utils.UtilsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RephraseAction
extends IntentionAndQuickFixAction {
    @IntentionName
    @NotNull
    public String getName() {
        String string = GrazieBundle.message("intention.rephrase.text", new Object[0]);
        if (string == null) {
            RephraseAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RephraseAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            RephraseAction.$$$reportNull$$$0(2);
        }
        if (editor == null || CommitMessage.isCommitMessage((PsiElement)psiFile)) {
            return false;
        }
        if (!GrazieCloudConnector.Companion.seemsCloudConnected()) {
            return false;
        }
        TextContent content = TextExtractor.findTextAt(psiFile, editor.getCaretModel().getOffset(), TextContent.TextDomain.ALL);
        if (content == null || !NaturalTextDetector.seemsNatural(content)) {
            return false;
        }
        TextRange range = content.fileRangeToText(HighlightingUtil.selectionRange(editor));
        if (range == null) {
            return false;
        }
        if (LangDetector.INSTANCE.getLanguage(content.toString()) == null) {
            return false;
        }
        return ContainerUtil.exists(SentenceTokenizer.tokenize(content), sentence -> sentence.start() <= range.getStartOffset() && range.getEndOffset() <= sentence.end());
    }

    public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
        if (project == null) {
            RephraseAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        int selStart = editor.getSelectionModel().getSelectionStart();
        int selEnd = editor.getSelectionModel().getSelectionEnd();
        SuggestionsWithLanguage rephraseData = (SuggestionsWithLanguage)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (SuggestionsWithLanguage)ReadAction.compute(() -> {
            ParsedSentence sentence = ParsedSentence.findSentenceInFile(psiFile, selStart);
            if (sentence == null) {
                return RephraseAction.rephraseTextContent(project, psiFile, selStart, selEnd);
            }
            int sentenceLength = sentence.text.length();
            TextRange textRange = RephraseAction.fileRangeToText(selStart, selEnd, sentence);
            if (textRange == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), sentenceLength, null, null);
            }
            Language iso = LangDetector.INSTANCE.getLanguage(sentence.text);
            if (iso == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), sentenceLength, null, null);
            }
            String rangeText = textRange.subSequence((CharSequence)sentence.text).toString();
            int wordsRangeCount = StandardWordTokenizer.INSTANCE.words(rangeText).size();
            GrazieFUSCounter.INSTANCE.reportRephraseRequested(iso, sentence.text.length(), textRange.getLength(), wordsRangeCount);
            List<TextRange> ranges = RephraseAction.getRangesToRephrase(sentence, textRange);
            List<Pair<TextRange, List<String>>> rephrasedSentences = RephraseAction.rephrase(sentence.text, ranges, iso, project);
            if (rephrasedSentences.isEmpty()) {
                return new SuggestionsWithLanguage(iso, Collections.emptyList(), sentenceLength, textRange.getLength(), wordsRangeCount);
            }
            List suggestions = ContainerUtil.flatMap(rephrasedSentences, s -> RephraseAction.toListItem(sentence, (Pair<TextRange, List<String>>)s));
            return new SuggestionsWithLanguage(iso, suggestions, sentenceLength, textRange.getLength(), wordsRangeCount);
        }), GrazieBundle.message("intention.rephrase.progress.title", new Object[0]), true, project);
        if (rephraseData.suggestions().isEmpty()) {
            GrazieFUSCounter.INSTANCE.reportRephraseEmpty(rephraseData.language, rephraseData.textLength, rephraseData.rangeLength, rephraseData.wordRangeCount);
            HintManager.getInstance().showErrorHint(editor, GrazieBundle.message("intention.rephrase.no.results.popup", new Object[0]));
            return;
        }
        this.showPopup(project, editor, psiFile, rephraseData);
    }

    @NotNull
    private static SuggestionsWithLanguage rephraseTextContent(@NotNull Project project, PsiFile psiFile, int selStart, int selEnd) {
        TextRange textRange;
        TextContent text;
        if (project == null) {
            RephraseAction.$$$reportNull$$$0(4);
        }
        if ((text = TextExtractor.findTextAt(psiFile, selStart, TextContent.TextDomain.ALL)) == null || text.toString().isBlank()) {
            return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), null, null, null);
        }
        Language iso = LangDetector.INSTANCE.getLanguage(text.toString());
        if (iso == null) {
            return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), text.length(), null, null);
        }
        TextRange textRange2 = textRange = selStart == selEnd ? TextRange.allOf((String)text.toString()) : text.fileRangeToText(TextRange.create((int)selStart, (int)selEnd));
        if (textRange == null) {
            return new SuggestionsWithLanguage(iso, Collections.emptyList(), text.length(), null, null);
        }
        List<Pair<TextRange, List<String>>> rephrasedSentences = RephraseAction.rephrase(text.toString(), List.of(textRange), iso, project);
        int wordsRangeCount = StandardWordTokenizer.INSTANCE.words(text.toString()).size();
        if (rephrasedSentences.isEmpty()) {
            return new SuggestionsWithLanguage(iso, Collections.emptyList(), text.length(), textRange.getLength(), wordsRangeCount);
        }
        List suggestions = ContainerUtil.flatMap(rephrasedSentences, s -> RephraseAction.toListItem(text, (Pair<TextRange, List<String>>)s));
        return new SuggestionsWithLanguage(iso, suggestions, text.length(), textRange.getLength(), wordsRangeCount);
    }

    @NotNull
    private static List<ListItem> toListItem(TextContent content, Pair<TextRange, List<String>> rephrasedSentences) {
        TextRange range = (TextRange)rephrasedSentences.getFirst();
        TextRange fileRange = new TextRange(content.textOffsetToFile(range.getStartOffset()), content.textOffsetToFile(range.getEndOffset()));
        List list = ContainerUtil.map((Collection)((Collection)rephrasedSentences.getSecond()), item -> new ListItem(fileRange, (String)item));
        if (list == null) {
            RephraseAction.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<ListItem> toListItem(ParsedSentence sentence, Pair<TextRange, List<String>> rephrasedSentences) {
        TextRange range = (TextRange)rephrasedSentences.getFirst();
        TextRange fileRange = new TextRange(sentence.textOffsetToFile(range.getStartOffset()), sentence.textOffsetToFile(range.getEndOffset()));
        List list = ContainerUtil.map((Collection)((Collection)rephrasedSentences.getSecond()), item -> new ListItem(fileRange, (String)item));
        if (list == null) {
            RephraseAction.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void showPopup(Project project, Editor editor, PsiFile file, final SuggestionsWithLanguage descriptor) {
        final Ref highlighter = new Ref();
        final List<ListItem> suggestions = descriptor.suggestions();
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(suggestions).setSelectionMode(0).setRenderer((ListCellRenderer)new PaddedListCellRenderer()).setItemChosenCallback(item -> WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getName(), null, () -> {
            int selectedRank = suggestions.indexOf(item);
            editor.getDocument().replaceString(item.fileRange.getStartOffset(), item.fileRange.getEndOffset(), (CharSequence)item.replacement);
            int rephraseLength = item.replacement.length();
            int rephraseWordCount = StandardWordTokenizer.INSTANCE.words(item.replacement).size();
            GrazieFUSCounter.INSTANCE.reportRephraseApplied(descriptor.language, suggestions.size(), rephraseLength, rephraseWordCount, selectedRank);
        }, (PsiFile[])new PsiFile[]{file})).setNamerForFiltering(i -> i.replacement).setItemSelectedCallback(item -> {
            RephraseAction.dropHighlighter((Ref<RangeHighlighter>)highlighter);
            if (item != null) {
                highlighter.set((Object)editor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, item.fileRange.getStartOffset(), item.fileRange.getEndOffset(), 6001, HighlighterTargetArea.EXACT_RANGE));
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RephraseAction.dropHighlighter((Ref<RangeHighlighter>)highlighter);
                if (!event.isOk()) {
                    GrazieFUSCounter.INSTANCE.reportRephraseRejected(descriptor.language(), suggestions.size());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/grazie/ide/inspection/ai/RephraseAction$1", "onClosed"));
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    private static void dropHighlighter(Ref<RangeHighlighter> highlighter) {
        RangeHighlighter rh = (RangeHighlighter)highlighter.get();
        if (rh != null) {
            rh.dispose();
        }
        highlighter.set(null);
    }

    @Nullable
    private static TextRange fileRangeToText(int selStart, int selEnd, ParsedSentence sentence) {
        Integer textStart = sentence.fileOffsetToText(selStart);
        Integer textEnd = sentence.fileOffsetToText(selEnd);
        return textStart == null || textEnd == null ? null : new TextRange(textStart.intValue(), textEnd.intValue());
    }

    private static List<TextRange> getRangesToRephrase(ParsedSentence sentence, TextRange textRange) {
        ai.grazie.rules.tree.TextRange range;
        if (textRange.getLength() > 0) {
            return List.of(Text.alignToWordBounds(textRange, sentence.text));
        }
        LanguageToolkit toolkit = LanguageToolkit.forLanguage((Language)sentence.tree.treeSupport().getGrazieLanguage());
        List extendRanges = toolkit.selectioner().calcExtendSelectionRanges(sentence.tree, textRange.getStartOffset(), textRange.getEndOffset());
        assert (!extendRanges.isEmpty());
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.add(UtilsKt.ijRange((ai.grazie.rules.tree.TextRange)extendRanges.getFirst()));
        for (int i = 1; i < extendRanges.size() && Strings.countChars((CharSequence)sentence.text.substring((range = (ai.grazie.rules.tree.TextRange)extendRanges.get(i)).start(), range.end()), (char)' ') <= 10; ++i) {
            result.add(UtilsKt.ijRange(range));
        }
        return result;
    }

    @NotNull
    private static List<Pair<TextRange, List<String>>> rephrase(String content, List<TextRange> ranges, Language iso, Project project) {
        List<Object> list;
        try {
            List<Pair<TextRange, List<String>>> rephrased = APIQueries.getRephraser().rephrase(content, ranges, iso, project);
            list = rephrased == null ? Collections.emptyList() : rephrased;
        }
        catch (TaskServerException e) {
            List<Pair<TextRange, List<String>>> list2 = Collections.emptyList();
            if (list2 == null) {
                RephraseAction.$$$reportNull$$$0(8);
            }
            return list2;
        }
        if (list == null) {
            RephraseAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/inspection/ai/RephraseAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/inspection/ai/RephraseAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toListItem";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "rephrase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rephraseTextContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public record SuggestionsWithLanguage(@NotNull Language language, @NotNull List<ListItem> suggestions, @Nullable Integer textLength, @Nullable Integer rangeLength, @Nullable Integer wordRangeCount) {
        @NotNull
        private final Language language;
        @NotNull
        private final List<ListItem> suggestions;

        public SuggestionsWithLanguage(@NotNull Language language, @NotNull List<ListItem> suggestions, @Nullable Integer textLength, @Nullable Integer rangeLength, @Nullable Integer wordRangeCount) {
            if (language == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(0);
            }
            if (suggestions == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Language language() {
            Language language = this.language;
            if (language == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(2);
            }
            return language;
        }

        @NotNull
        public List<ListItem> suggestions() {
            List<ListItem> list = this.suggestions;
            if (list == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/grazie/ide/inspection/ai/RephraseAction$SuggestionsWithLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/grazie/ide/inspection/ai/RephraseAction$SuggestionsWithLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "language";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private record ListItem(TextRange fileRange, String replacement) {
        @Override
        public String toString() {
            return this.replacement;
        }
    }
}

