/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import java.io.IOException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.TransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.rule.RulePersistenceService;
import org.opensearch.rule.RulePersistenceServiceRegistry;
import org.opensearch.rule.RuleRoutingServiceRegistry;
import org.opensearch.rule.action.UpdateRuleRequest;
import org.opensearch.rule.action.UpdateRuleResponse;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportService;

public class TransportUpdateRuleAction
extends TransportAction<UpdateRuleRequest, UpdateRuleResponse> {
    private final ThreadPool threadPool;
    private final RuleRoutingServiceRegistry ruleRoutingServiceRegistry;
    private final RulePersistenceServiceRegistry rulePersistenceServiceRegistry;

    @Inject
    public TransportUpdateRuleAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, RulePersistenceServiceRegistry rulePersistenceServiceRegistry, RuleRoutingServiceRegistry ruleRoutingServiceRegistry) {
        super("cluster:admin/opensearch/rule/_update", actionFilters, transportService.getTaskManager());
        this.rulePersistenceServiceRegistry = rulePersistenceServiceRegistry;
        this.ruleRoutingServiceRegistry = ruleRoutingServiceRegistry;
        this.threadPool = threadPool;
        transportService.registerRequestHandler("cluster:admin/opensearch/rule/_update", "same", UpdateRuleRequest::new, (TransportRequestHandler)new TransportRequestHandler<UpdateRuleRequest>(){

            public void messageReceived(UpdateRuleRequest request, TransportChannel channel, Task task) {
                TransportUpdateRuleAction.this.executeLocally(request, (ActionListener<UpdateRuleResponse>)ActionListener.wrap(response -> {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (IOException e) {
                        TransportUpdateRuleAction.this.logger.error("Failed to send UpdateRuleResponse to transport channel", (Throwable)e);
                        throw new TransportException("Fail to send", (Throwable)e);
                    }
                }, exception -> {
                    try {
                        channel.sendResponse(exception);
                    }
                    catch (IOException e) {
                        TransportUpdateRuleAction.this.logger.error("Failed to send exception response to transport channel", (Throwable)e);
                        throw new TransportException("Fail to send", (Throwable)e);
                    }
                }));
            }
        });
    }

    protected void doExecute(Task task, UpdateRuleRequest request, ActionListener<UpdateRuleResponse> listener) {
        this.ruleRoutingServiceRegistry.getRuleRoutingService(request.getFeatureType()).handleUpdateRuleRequest(request, listener);
    }

    private void executeLocally(UpdateRuleRequest request, ActionListener<UpdateRuleResponse> listener) {
        this.threadPool.executor("rule_serial_executor").execute(() -> {
            RulePersistenceService rulePersistenceService = this.rulePersistenceServiceRegistry.getRulePersistenceService(request.getFeatureType());
            rulePersistenceService.updateRule(request, listener);
        });
    }
}

