/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning;

import ciir.umass.edu.learning.RankList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Sampler {
    protected List<RankList> samples = null;
    protected List<RankList> remains = null;

    public List<RankList> doSampling(List<RankList> samplingPool, float samplingRate, boolean withReplacement) {
        Random r = new Random();
        this.samples = new ArrayList<RankList>();
        int size = (int)(samplingRate * (float)samplingPool.size());
        if (withReplacement) {
            int i;
            int[] used = new int[samplingPool.size()];
            Arrays.fill(used, 0);
            for (i = 0; i < size; ++i) {
                int selected = r.nextInt(samplingPool.size());
                this.samples.add(samplingPool.get(selected));
                used[selected] = 1;
            }
            this.remains = new ArrayList<RankList>();
            for (i = 0; i < samplingPool.size(); ++i) {
                if (used[i] != 0) continue;
                this.remains.add(samplingPool.get(i));
            }
        } else {
            int i;
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (i = 0; i < samplingPool.size(); ++i) {
                l.add(i);
            }
            for (i = 0; i < size; ++i) {
                int selected = r.nextInt(l.size());
                this.samples.add(samplingPool.get((Integer)l.get(selected)));
                l.remove(selected);
            }
            this.remains = new ArrayList<RankList>();
            for (i = 0; i < l.size(); ++i) {
                this.remains.add(samplingPool.get((Integer)l.get(i)));
            }
        }
        return this.samples;
    }

    public List<RankList> getSamples() {
        return this.samples;
    }

    public List<RankList> getRemains() {
        return this.remains;
    }
}

