/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.messages;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.eclipse.jetty.websocket.jsr356.endpoints.JsrAnnotatedEventDriver;

public class BinaryPartialOnMessage
implements MessageAppender {
    private final JsrAnnotatedEventDriver driver;
    private boolean finished;

    public BinaryPartialOnMessage(JsrAnnotatedEventDriver driver) {
        this.driver = driver;
        this.finished = false;
    }

    public void appendFrame(ByteBuffer payload, boolean isLast) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            this.driver.onPartialBinaryMessage(BufferUtil.EMPTY_BUFFER, isLast);
        } else {
            this.driver.onPartialBinaryMessage(payload, isLast);
        }
    }

    public void messageComplete() {
        this.finished = true;
    }
}

