/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.usbserial.linuxsysfs.internal;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadFactoryBuilder;
import org.openhab.core.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscovery;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.openhab.core.config.discovery.usbserial.linuxsysfs.internal.DeltaUsbSerialScanner;
import org.openhab.core.config.discovery.usbserial.linuxsysfs.internal.UsbSerialScanner;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(configurationPid={"discovery.usbserial.linuxsysfs.pollingscanner"})
public class PollingUsbSerialScanner
implements UsbSerialDiscovery {
    private final Logger logger = LoggerFactory.getLogger(PollingUsbSerialScanner.class);
    private static final String THREAD_NAME = "usb-serial-discovery-linux-sysfs";
    public static final String PAUSE_BETWEEN_SCANS_IN_SECONDS_ATTRIBUTE = "pauseBetweenScansInSeconds";
    private static final Duration DEFAULT_PAUSE_BETWEEN_SCANS = Duration.ofSeconds(15L);
    private Duration pauseBetweenScans = DEFAULT_PAUSE_BETWEEN_SCANS;
    private final DeltaUsbSerialScanner deltaUsbSerialScanner;
    private final Set<UsbSerialDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<UsbSerialDiscoveryListener>();
    private final ScheduledExecutorService scheduler;
    private @Nullable ScheduledFuture<?> backgroundScanningJob;

    @Activate
    public PollingUsbSerialScanner(Map<String, Object> config, @Reference UsbSerialScanner usbSerialScanner) {
        if (config.containsKey(PAUSE_BETWEEN_SCANS_IN_SECONDS_ATTRIBUTE)) {
            this.pauseBetweenScans = Duration.ofSeconds(Long.parseLong(config.get(PAUSE_BETWEEN_SCANS_IN_SECONDS_ATTRIBUTE).toString()));
        }
        this.deltaUsbSerialScanner = new DeltaUsbSerialScanner(usbSerialScanner);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(ThreadFactoryBuilder.create().withName(THREAD_NAME).withDaemonThreads(true).build());
    }

    @Deactivate
    protected void deactivate() {
        this.scheduler.shutdown();
    }

    @Modified
    protected synchronized void modified(Map<String, Object> config) {
        if (config.containsKey(PAUSE_BETWEEN_SCANS_IN_SECONDS_ATTRIBUTE)) {
            this.pauseBetweenScans = Duration.ofSeconds(Long.parseLong(config.get(PAUSE_BETWEEN_SCANS_IN_SECONDS_ATTRIBUTE).toString()));
            if (this.backgroundScanningJob != null) {
                this.stopBackgroundScanning();
                this.startBackgroundScanning();
            }
        }
    }

    public void doSingleScan() {
        this.singleScanInternal(true);
    }

    public synchronized void startBackgroundScanning() {
        if (this.backgroundScanningJob == null) {
            if (this.deltaUsbSerialScanner.canPerformScans()) {
                this.backgroundScanningJob = this.scheduler.scheduleWithFixedDelay(() -> this.singleScanInternal(false), 0L, this.pauseBetweenScans.getSeconds(), TimeUnit.SECONDS);
                this.logger.debug("Scheduled USB-Serial background discovery every {} seconds", (Object)this.pauseBetweenScans.getSeconds());
            } else {
                this.logger.debug("Do not start background scanning, as the configured USB-Serial scanner cannot perform scans on this system");
            }
        }
    }

    public synchronized void stopBackgroundScanning() {
        this.logger.debug("Stopping USB-Serial background discovery");
        ScheduledFuture<?> currentBackgroundScanningJob = this.backgroundScanningJob;
        if (currentBackgroundScanningJob != null && !currentBackgroundScanningJob.isCancelled() && currentBackgroundScanningJob.cancel(true)) {
            this.backgroundScanningJob = null;
            this.logger.debug("Stopped USB-serial background discovery");
        }
    }

    public void registerDiscoveryListener(UsbSerialDiscoveryListener listener) {
        this.discoveryListeners.add(listener);
        for (UsbSerialDeviceInformation deviceInfo : this.deltaUsbSerialScanner.getLastScanResult()) {
            listener.usbSerialDeviceDiscovered(deviceInfo);
        }
    }

    public void unregisterDiscoveryListener(UsbSerialDiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    private void singleScanInternal(boolean announceUnchangedDevices) {
        try {
            DeltaUsbSerialScanner.Delta<UsbSerialDeviceInformation> delta = this.deltaUsbSerialScanner.scan();
            this.announceAddedDevices(delta.getAdded());
            this.announceRemovedDevices(delta.getRemoved());
            if (announceUnchangedDevices) {
                this.announceAddedDevices(delta.getUnchanged());
            }
        }
        catch (IOException e) {
            this.logger.debug("A {} prevented a scan for USB serial devices: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private void announceAddedDevices(Set<UsbSerialDeviceInformation> deviceInfos) {
        for (UsbSerialDeviceInformation deviceInfo : deviceInfos) {
            for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
                listener.usbSerialDeviceDiscovered(deviceInfo);
            }
        }
    }

    private void announceRemovedDevices(Set<UsbSerialDeviceInformation> deviceInfos) {
        for (UsbSerialDeviceInformation deviceInfo : deviceInfos) {
            for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
                listener.usbSerialDeviceRemoved(deviceInfo);
            }
        }
    }
}

