/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.NodePoolPlacementConfigDetails;
import com.oracle.bmc.containerengine.model.NodePoolPodNetworkOptionDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateNodePoolNodeConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="size")
    private final Integer size;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="isPvEncryptionInTransitEnabled")
    private final Boolean isPvEncryptionInTransitEnabled;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="placementConfigs")
    private final List<NodePoolPlacementConfigDetails> placementConfigs;
    @JsonProperty(value="nodePoolPodNetworkOptionDetails")
    private final NodePoolPodNetworkOptionDetails nodePoolPodNetworkOptionDetails;

    @Deprecated
    @ConstructorProperties(value={"size", "nsgIds", "kmsKeyId", "isPvEncryptionInTransitEnabled", "freeformTags", "definedTags", "placementConfigs", "nodePoolPodNetworkOptionDetails"})
    public UpdateNodePoolNodeConfigDetails(Integer size, List<String> nsgIds, String kmsKeyId, Boolean isPvEncryptionInTransitEnabled, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<NodePoolPlacementConfigDetails> placementConfigs, NodePoolPodNetworkOptionDetails nodePoolPodNetworkOptionDetails) {
        this.size = size;
        this.nsgIds = nsgIds;
        this.kmsKeyId = kmsKeyId;
        this.isPvEncryptionInTransitEnabled = isPvEncryptionInTransitEnabled;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.placementConfigs = placementConfigs;
        this.nodePoolPodNetworkOptionDetails = nodePoolPodNetworkOptionDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getSize() {
        return this.size;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean getIsPvEncryptionInTransitEnabled() {
        return this.isPvEncryptionInTransitEnabled;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<NodePoolPlacementConfigDetails> getPlacementConfigs() {
        return this.placementConfigs;
    }

    public NodePoolPodNetworkOptionDetails getNodePoolPodNetworkOptionDetails() {
        return this.nodePoolPodNetworkOptionDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateNodePoolNodeConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("size=").append(String.valueOf(this.size));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", isPvEncryptionInTransitEnabled=").append(String.valueOf(this.isPvEncryptionInTransitEnabled));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", placementConfigs=").append(String.valueOf(this.placementConfigs));
        sb.append(", nodePoolPodNetworkOptionDetails=").append(String.valueOf((Object)this.nodePoolPodNetworkOptionDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateNodePoolNodeConfigDetails)) {
            return false;
        }
        UpdateNodePoolNodeConfigDetails other = (UpdateNodePoolNodeConfigDetails)((Object)o);
        return Objects.equals(this.size, other.size) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.isPvEncryptionInTransitEnabled, other.isPvEncryptionInTransitEnabled) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.placementConfigs, other.placementConfigs) && Objects.equals((Object)this.nodePoolPodNetworkOptionDetails, (Object)other.nodePoolPodNetworkOptionDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.isPvEncryptionInTransitEnabled == null ? 43 : this.isPvEncryptionInTransitEnabled.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.placementConfigs == null ? 43 : this.placementConfigs.hashCode());
        result = result * 59 + (this.nodePoolPodNetworkOptionDetails == null ? 43 : this.nodePoolPodNetworkOptionDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="size")
        private Integer size;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="isPvEncryptionInTransitEnabled")
        private Boolean isPvEncryptionInTransitEnabled;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="placementConfigs")
        private List<NodePoolPlacementConfigDetails> placementConfigs;
        @JsonProperty(value="nodePoolPodNetworkOptionDetails")
        private NodePoolPodNetworkOptionDetails nodePoolPodNetworkOptionDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder size(Integer size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder isPvEncryptionInTransitEnabled(Boolean isPvEncryptionInTransitEnabled) {
            this.isPvEncryptionInTransitEnabled = isPvEncryptionInTransitEnabled;
            this.__explicitlySet__.add("isPvEncryptionInTransitEnabled");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder placementConfigs(List<NodePoolPlacementConfigDetails> placementConfigs) {
            this.placementConfigs = placementConfigs;
            this.__explicitlySet__.add("placementConfigs");
            return this;
        }

        public Builder nodePoolPodNetworkOptionDetails(NodePoolPodNetworkOptionDetails nodePoolPodNetworkOptionDetails) {
            this.nodePoolPodNetworkOptionDetails = nodePoolPodNetworkOptionDetails;
            this.__explicitlySet__.add("nodePoolPodNetworkOptionDetails");
            return this;
        }

        public UpdateNodePoolNodeConfigDetails build() {
            UpdateNodePoolNodeConfigDetails model = new UpdateNodePoolNodeConfigDetails(this.size, this.nsgIds, this.kmsKeyId, this.isPvEncryptionInTransitEnabled, this.freeformTags, this.definedTags, this.placementConfigs, this.nodePoolPodNetworkOptionDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateNodePoolNodeConfigDetails model) {
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("isPvEncryptionInTransitEnabled")) {
                this.isPvEncryptionInTransitEnabled(model.getIsPvEncryptionInTransitEnabled());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("placementConfigs")) {
                this.placementConfigs(model.getPlacementConfigs());
            }
            if (model.wasPropertyExplicitlySet("nodePoolPodNetworkOptionDetails")) {
                this.nodePoolPodNetworkOptionDetails(model.getNodePoolPodNetworkOptionDetails());
            }
            return this;
        }
    }
}

