/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cloud.oracle.assets.SuggestedItem;
import org.netbeans.modules.cloud.oracle.assets.SuggestionAnalyzer;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;

public final class DependenciesAnalyzer
implements SuggestionAnalyzer {
    private static final Map<String, String> DEPENDENCIES = new HashMap(){
        {
            this.put("micronaut-oraclecloud-atp", "Database");
            this.put("micronaut-object-storage-oracle-cloud", "Bucket");
            this.put("micronaut-oraclecloud-vault", "Vault");
            this.put("micronaut-oraclecloud-micrometer", "MetricsNamespace");
        }
    };

    @Override
    public Set<SuggestedItem> findSuggestions(Project[] projects) {
        HashSet<SuggestedItem> result = new HashSet<SuggestedItem>();
        if (projects == null) {
            return null;
        }
        for (int i = 0; i < projects.length; ++i) {
            ProjectDependencies.DependencyQueryBuilder b = ProjectDependencies.newBuilder().online();
            DependencyResult r = ProjectDependencies.findDependencies((Project)projects[i], (ProjectDependencies.DependencyQuery)b.build());
            List children = r.getRoot().getChildren();
            for (Dependency dependency : children) {
                String artifactId = dependency.getArtifact().getArtifactId();
                if (!DEPENDENCIES.containsKey(artifactId)) continue;
                String path = DEPENDENCIES.get(artifactId);
                result.add(SuggestedItem.forPath(path));
            }
        }
        result.add(SuggestedItem.forPath("Cluster"));
        result.add(SuggestedItem.forPath("ComputeInstance"));
        result.add(SuggestedItem.forPath("ContainerRepository"));
        return result;
    }
}

