/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.samples.wizard.iterator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.client.samples.wizard.iterator.AbstractWizardIterator;
import org.netbeans.modules.web.client.samples.wizard.ui.SamplePanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SampleWizardIterator
extends AbstractWizardIterator {
    @Override
    protected WizardDescriptor.Panel[] createPanels(WizardDescriptor wizard) {
        return new WizardDescriptor.Panel[]{new SamplePanel(this.descriptor)};
    }

    @Override
    public Set<?> instantiate(ProgressHandle handle) throws IOException {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.descriptor);
        String targetName = Templates.getTargetName((WizardDescriptor)this.descriptor);
        FileUtil.toFile((FileObject)targetFolder).mkdirs();
        FileObject projectFolder = targetFolder.createFolder(targetName);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.descriptor);
        this.unZipFile(template.getInputStream(), projectFolder);
        ProjectManager.getDefault().clearNonProjectCache();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("${project.name}", targetName);
        this.replaceTokens(projectFolder, map, "nbproject/project.properties");
        ProjectChooser.setProjectsFolder((File)FileUtil.toFile((FileObject)targetFolder));
        return Collections.singleton(projectFolder);
    }

    private void replaceTokens(FileObject dir, Map<String, String> map, String ... files) throws IOException {
        for (String file : files) {
            this.replaceToken(dir.getFileObject(file), map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceToken(FileObject fo, Map<String, String> map) throws IOException {
        if (fo == null) {
            return;
        }
        FileLock lock = fo.lock();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.toFile((FileObject)fo)), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    line = line.replace(entry.getKey(), entry.getValue());
                }
                sb.append(line);
                sb.append("\n");
            }
            OutputStreamWriter writer = new OutputStreamWriter(fo.getOutputStream(lock), StandardCharsets.UTF_8);
            try {
                writer.write(sb.toString());
            }
            finally {
                writer.close();
                reader.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unZipFile(InputStream source, FileObject rootFolder) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)rootFolder, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)rootFolder, (String)entry.getName());
                FileLock lock = fo.lock();
                try (OutputStream out = fo.getOutputStream(lock);){
                    FileUtil.copy((InputStream)str, (OutputStream)out);
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            source.close();
        }
    }
}

