/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.java.j2semodule.J2SEModularProjectUtil;
import org.netbeans.modules.java.j2semodule.ui.customizer.J2SEModularProjectProperties;
import org.netbeans.modules.java.j2semodule.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2semodule.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PanelOptionsVisual
extends SettingsPanel {
    private PanelConfigureProject panel;
    private JButton managePlatformsButton;
    private JComboBox<String> platformComboBox;
    private JLabel platformLabel;

    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.panel = panel;
        this.initComponents();
        this.platformComboBox.setModel(this.createPlatformComboBoxModel());
        this.platformComboBox.setRenderer(PlatformUiSupport.createPlatformListCellRenderer());
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)new JavaPlatformChangeListener(), (Object)JavaPlatformManager.getDefault()));
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("javaPlatform", (Object)this.getSelectedPlatform());
    }

    @Override
    void read(WizardDescriptor d) {
    }

    @Override
    boolean valid(WizardDescriptor d) {
        return J2SEModularProjectProperties.MODULAR_PLATFORM_FILTER.accept(this.getSelectedPlatform());
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    private void initComponents() {
        this.platformLabel = new JLabel();
        this.platformComboBox = new JComboBox();
        this.managePlatformsButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.platformLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.platformLabel.text"));
        this.platformComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.platformComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.platformComboBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatformsButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.managePlatformsButton.text"));
        this.managePlatformsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.managePlatformsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.platformLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformComboBox, -2, 237, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.managePlatformsButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.platformLabel).addComponent(this.platformComboBox, -2, -1, -2).addComponent(this.managePlatformsButton)).addGap(0, 275, Short.MAX_VALUE)));
    }

    private void managePlatformsButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelectedPlatform());
    }

    private void platformComboBoxItemStateChanged(ItemEvent evt) {
        this.panel.fireChangeEvent();
    }

    private JavaPlatform getSelectedPlatform() {
        Object selectedItem = this.platformComboBox.getSelectedItem();
        JavaPlatform platform = selectedItem == null ? null : PlatformUiSupport.getPlatform((Object)selectedItem);
        return platform;
    }

    private ComboBoxModel createPlatformComboBoxModel() {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", J2SEModularProjectUtil.MIN_SOURCE_LEVEL));
        return PlatformUiSupport.createPlatformComboBoxModel(platforms.length > 0 ? (String)platforms[0].getProperties().get("platform.ant.name") : null, Collections.singleton(J2SEModularProjectProperties.MODULAR_PLATFORM_FILTER));
    }

    private class JavaPlatformChangeListener
    implements PropertyChangeListener {
        private JavaPlatformChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PanelOptionsVisual.this.panel.fireChangeEvent();
        }
    }
}

